/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.clients.plugins.auth.oauth.internals;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.security.oauthbearer.JwtValidator;
import org.apache.kafka.common.security.oauthbearer.JwtValidatorException;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.internals.secured.BasicOAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.internals.secured.SerializedJwt;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerIllegalTokenException;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerUnsecuredJws;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpireJwtTokenLoginValidator
implements JwtValidator {
    private static final Logger log = LoggerFactory.getLogger(SpireJwtTokenLoginValidator.class);
    public static final String EXPIRATION_CLAIM_NAME = "exp";
    public static final String ISSUED_AT_CLAIM_NAME = "iat";
    public static final String SUBJECT_CLAIM_NAME = "sub";

    public OAuthBearerToken validate(String accessToken) throws JwtValidatorException {
        Map payload;
        SerializedJwt serializedJwt = new SerializedJwt(accessToken);
        try {
            payload = OAuthBearerUnsecuredJws.toMap((String)serializedJwt.getPayload());
        }
        catch (OAuthBearerIllegalTokenException e) {
            throw new JwtValidatorException(String.format("Could not validate the access token: %s", e.getMessage()), (Throwable)e);
        }
        long expiration = this.validateExpiration(this.getClaim(payload, EXPIRATION_CLAIM_NAME));
        String subject = this.validateSubject(this.getClaim(payload, SUBJECT_CLAIM_NAME));
        long issuedAt = this.validateIat(this.getClaim(payload, ISSUED_AT_CLAIM_NAME));
        return new BasicOAuthBearerToken(accessToken, Collections.emptySet(), expiration, subject, Long.valueOf(issuedAt));
    }

    private long validateExpiration(Object exp) {
        this.validateNonNullClaim(EXPIRATION_CLAIM_NAME, exp);
        if (!(exp instanceof Number)) {
            throw new JwtValidatorException("exp value must be a number");
        }
        Number expNumericDate = (Number)exp;
        if (expNumericDate.longValue() < 0L) {
            throw new JwtValidatorException("exp value must be non-negative");
        }
        if (System.currentTimeMillis() >= expNumericDate.longValue() * 1000L) {
            throw new JwtValidatorException("Token has expired");
        }
        return expNumericDate.longValue() * 1000L;
    }

    private String validateSubject(Object sub) {
        this.validateNonNullClaim(SUBJECT_CLAIM_NAME, sub);
        if (!(sub instanceof String)) {
            throw new JwtValidatorException("sub value must be a string");
        }
        String subString = (String)sub;
        if (!subString.startsWith("spiffe")) {
            throw new JwtValidatorException("sub value must be a spiffe id");
        }
        return subString;
    }

    private long validateIat(Object iat) {
        this.validateNonNullClaim(ISSUED_AT_CLAIM_NAME, iat);
        if (!(iat instanceof Number)) {
            throw new JwtValidatorException("iat value must be a number");
        }
        Number iatNumericDate = (Number)iat;
        if (iatNumericDate.longValue() < 0L) {
            throw new JwtValidatorException("iat value must be non-negative");
        }
        if (System.currentTimeMillis() < iatNumericDate.longValue() * 1000L) {
            throw new JwtValidatorException("iat has future value");
        }
        return iatNumericDate.longValue() * 1000L;
    }

    private void validateNonNullClaim(String claimName, Object claimValue) {
        if (claimValue == null) {
            throw new JwtValidatorException(String.format("%s value must be non-null", claimName));
        }
    }

    private Object getClaim(Map<String, Object> payload, String claimName) {
        Object value = payload.get(claimName);
        log.debug("getClaim - {}: {}", (Object)claimName, value);
        return value;
    }
}

