/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.function.sdk.v1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.function.sdk.v1.types.CfltFunctionPoolSpec;
import io.confluent.function.sdk.v1.types.CfltFunctionSpec;
import io.confluent.function.sdk.v1.types.ObjectMetadata;

public class RequestUtils {
    private static ObjectMapper mapper = new ObjectMapper();

    private static void initMapperIfNecessary() {
        if (mapper != null) {
            return;
        }
        ObjectMapper inst = new ObjectMapper();
        inst.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper = inst;
    }

    public static String buildCreateCfltFunctionRequestPayload(ObjectMetadata funcMetadata, CfltFunctionSpec funcSpec) throws JsonProcessingException {
        RequestUtils.initMapperIfNecessary();
        String template = "{\n    \"kind\": \"CfltFunction\",\n    \"apiVersion\": \"compute/v1\",\n    \"metadata\": {FUNC_METADATA},\n    \"spec\": {FUNC_SPEC}\n}\n";
        return template.replace("{FUNC_METADATA}", mapper.writeValueAsString((Object)funcMetadata)).replace("{FUNC_SPEC}", mapper.writeValueAsString((Object)funcSpec));
    }

    public static String buildCreateOrListCfltFunctionApiUrlPath(ObjectMetadata funcMetadata) {
        return "/apis/compute/v1/orgs/" + funcMetadata.getOrg() + "/environments/" + funcMetadata.getEnvironment() + "/cfltfunctions";
    }

    public static String buildCfltFunctionApiUrlPath(ObjectMetadata funcMetadata) {
        return "/apis/compute/v1/orgs/" + funcMetadata.getOrg() + "/environments/" + funcMetadata.getEnvironment() + "/cfltfunctions/" + funcMetadata.getName();
    }

    public static String buildCreateCfltFunctionPoolRequestPayload(ObjectMetadata poolMetadata, CfltFunctionPoolSpec poolSpec) throws JsonProcessingException {
        RequestUtils.initMapperIfNecessary();
        String template = "{\n    \"kind\": \"CfltFunctionPool\",\n    \"apiVersion\": \"compute/v1\",\n    \"metadata\": {POOL_METADATA},\n    \"spec\": {POOL_SPEC}\n}\n";
        return template.replace("{POOL_METADATA}", mapper.writeValueAsString((Object)poolMetadata)).replace("{POOL_SPEC}", mapper.writeValueAsString((Object)poolSpec));
    }

    public static String buildCreateOrListCfltFunctionPoolApiUrlPath(ObjectMetadata poolMetadata) {
        return "/apis/compute/v1/orgs/" + poolMetadata.getOrg() + "/environments/" + poolMetadata.getEnvironment() + "/cfltfunctionpools";
    }

    public static String buildCfltFunctionPoolApiUrlPath(ObjectMetadata poolMetadata) {
        return "/apis/compute/v1/orgs/" + poolMetadata.getOrg() + "/environments/" + poolMetadata.getEnvironment() + "/cfltfunctionpools/" + poolMetadata.getName();
    }
}

