/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.resourcemanager.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.resourcemanager.api.annotations.Group;
import io.confluent.resourcemanager.api.annotations.Version;
import io.confluent.resourcemanager.api.model.identifier.ObjectIdentifier;
import io.confluent.resourcemanager.protobuf.apis.meta.v1.ObjectMeta;

public interface HasMetadata {
    public ObjectMeta getMetadata();

    public ObjectIdentifier<? extends HasMetadata> identifier();

    @JsonProperty(value="kind", access=JsonProperty.Access.READ_ONLY)
    default public String getKind() {
        return HasMetadata.getKind(this.getClass());
    }

    @JsonProperty(value="apiVersion", access=JsonProperty.Access.READ_ONLY)
    default public String getApiVersion() {
        return String.format("%s/%s", this.getGroup(), this.getVersion());
    }

    @JsonIgnore
    default public String getGroup() {
        return HasMetadata.getGroup(this.getClass());
    }

    @JsonIgnore
    default public String getVersion() {
        return HasMetadata.getVersion(this.getClass());
    }

    public static String getGroup(Class<?> clazz) {
        Group group = clazz.getAnnotation(Group.class);
        if (group == null) {
            throw new IllegalArgumentException("You need to specify a @Group annotation on " + String.valueOf(clazz));
        }
        return group.value();
    }

    public static String getVersion(Class<?> clazz) {
        Version version = clazz.getAnnotation(Version.class);
        if (version == null) {
            throw new IllegalArgumentException("You need to specify a @Version annotation on " + String.valueOf(clazz));
        }
        return version.value();
    }

    public static String getKind(Class<?> clazz) {
        return clazz.getSimpleName();
    }
}

