/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.resourcemanager.api.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.confluent.resourcemanager.api.model.ListMeta;
import io.confluent.resourcemanager.api.model.StatusDetails;

@JsonIgnoreProperties(ignoreUnknown=true)
public record Status(ListMeta metadata, String status, String message, Reason reason, StatusDetails details, Integer code) {

    public static enum Reason {
        Unauthorized,
        Forbidden,
        NotFound,
        AlreadyExists,
        Conflict,
        Gone,
        Invalid,
        ServerTimeout,
        Timeout,
        TooManyRequests,
        BadRequest,
        MethodNotAllowed,
        NotAcceptable,
        RequestEntityTooLarge,
        UnsupportedMediaType,
        InternalError,
        Expired,
        ServiceUnavailable,
        ClientClosedRequest,
        UNKNOWN;


        public static Reason fromString(String value) {
            try {
                return Reason.valueOf(value);
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }
    }
}

