/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.resourcemanager.api.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.errorprone.annotations.DoNotCall;
import io.confluent.resourcemanager.api.client.ClientImpl;
import io.confluent.resourcemanager.api.model.GroupVersionKind;
import io.confluent.resourcemanager.api.model.HasMetadata;
import io.confluent.resourcemanager.api.model.identifier.ObjectIdentifier;
import io.confluent.resourcemanager.api.model.location.Location;
import io.confluent.resourcemanager.protobuf.apis.meta.v1.ObjectMeta;
import java.util.Objects;
import lombok.Generated;

public class Adapter<T>
implements HasMetadata {
    @JsonValue
    private T openApiObject;
    private GroupVersionKind groupVersionKind;

    @Override
    public String getGroup() {
        return this.groupVersionKind.group();
    }

    @Override
    public String getVersion() {
        return this.groupVersionKind.version();
    }

    @Override
    public String getKind() {
        return this.groupVersionKind.kind();
    }

    @JsonCreator
    protected Adapter(T openApiObject) {
        this.openApiObject = openApiObject;
    }

    @Override
    public String getApiVersion() {
        return String.format("%s/%s", this.getGroup(), this.getVersion());
    }

    public Adapter(T openApiObject, GroupVersionKind gvk) {
        this.openApiObject = Objects.requireNonNull(openApiObject);
        this.groupVersionKind = gvk;
    }

    public JavaType getJavaType() {
        return TypeFactory.defaultInstance().constructParametricType(Adapter.class, new Class[]{this.openApiObject.getClass()});
    }

    @Override
    @Deprecated
    @DoNotCall(value="For internal use only. Use `.getOpenApiObject().getMetadata()` instead.")
    public final ObjectMeta getMetadata() {
        JsonNode tree = ClientImpl.OBJECT_MAPPER.valueToTree(this.openApiObject);
        JsonNode metadata = tree.get("metadata");
        if (metadata == null) {
            return ObjectMeta.newBuilder().build();
        }
        try {
            return (ObjectMeta)ClientImpl.OBJECT_MAPPER.treeToValue((TreeNode)metadata, ObjectMeta.class);
        }
        catch (JsonProcessingException | IllegalArgumentException e) {
            return ObjectMeta.newBuilder().build();
        }
    }

    public ObjectIdentifier<? extends Adapter<T>> identifier() {
        ObjectMeta metadata = this.getMetadata();
        return new ObjectIdentifier(Location.from(metadata.getLocation()), metadata.getScopeList(), metadata.getName(), this.getJavaType(), this.groupVersionKind);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Adapter)) {
            return false;
        }
        Adapter other = (Adapter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$openApiObject = this.getOpenApiObject();
        T other$openApiObject = other.getOpenApiObject();
        return !(this$openApiObject == null ? other$openApiObject != null : !this$openApiObject.equals(other$openApiObject));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Adapter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $openApiObject = this.getOpenApiObject();
        result = result * 59 + ($openApiObject == null ? 43 : $openApiObject.hashCode());
        return result;
    }

    @Generated
    public T getOpenApiObject() {
        return this.openApiObject;
    }

    @Generated
    public void setOpenApiObject(T openApiObject) {
        this.openApiObject = openApiObject;
    }

    @Generated
    public void setGroupVersionKind(GroupVersionKind groupVersionKind) {
        this.groupVersionKind = groupVersionKind;
    }
}

