/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.resourcemanager.internal.discovery;

import io.confluent.resourcemanager.api.client.ClientImpl;
import io.confluent.resourcemanager.internal.discovery.model.APIGroupDiscoveryList;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class DiscoveryClient {
    private final OkHttpClient httpClient;
    private final String url;

    public DiscoveryClient(String httpHost) {
        this(httpHost, new OkHttpClient());
    }

    public DiscoveryClient(String httpHost, OkHttpClient httpClient) {
        if (httpHost == null || httpHost.isEmpty()) {
            throw new IllegalArgumentException("httpHost cannot be null or empty");
        }
        HttpUrl url = HttpUrl.parse((String)httpHost);
        if (url == null) {
            throw new IllegalArgumentException("httpHost is not a valid URL: " + httpHost);
        }
        this.url = url.newBuilder().addPathSegment("apis").build().toString();
        this.httpClient = httpClient;
    }

    public CompletableFuture<APIGroupDiscoveryList> listAPIGroups() {
        final CompletableFuture<APIGroupDiscoveryList> future = new CompletableFuture<APIGroupDiscoveryList>();
        this.httpClient.newCall(new Request.Builder().url(this.url).build()).enqueue(new Callback(){

            public void onResponse(Call call, Response resp) throws IOException {
                if (resp.code() != 200) {
                    future.completeExceptionally(new IOException("Failed to list API groups: " + resp.code()));
                    return;
                }
                APIGroupDiscoveryList apiGroupDiscoveryList = (APIGroupDiscoveryList)ClientImpl.OBJECT_MAPPER.readValue(resp.body().string(), APIGroupDiscoveryList.class);
                future.complete(apiGroupDiscoveryList);
            }

            public void onFailure(Call arg0, IOException arg1) {
                future.completeExceptionally(arg1);
            }
        });
        return future;
    }
}

