/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.dataplane;

import com.google.common.annotations.VisibleForTesting;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import io.confluent.kafka.multitenant.utils.AuthUtils;
import io.confluent.security.auth.dataplane.DataplaneBaseAuthStore;
import io.confluent.security.auth.store.data.IdentityPoolValue;
import io.confluent.security.auth.store.data.JwtIssuerKey;
import io.confluent.security.auth.utils.MetricsUtils;
import io.confluent.security.store.KeyValueStore;
import io.confluent.security.store.kafka.KafkaStoreConfig;
import io.confluent.security.store.kafka.clients.ConsumerListener;
import io.confluent.security.store.kafka.clients.KafkaReader;
import io.confluent.security.store.kafka.clients.StatusListener;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataplaneAuthReader<K, V>
extends KafkaReader<K, V> {
    private static final Logger log = LoggerFactory.getLogger(DataplaneAuthReader.class);
    private static final String METRIC_TYPE = DataplaneAuthReader.class.getSimpleName();
    private final Map<K, Long> lastSequenceId;
    private final Set<MetricName> metricNames = new HashSet<MetricName>();
    private final Meter recordFailureMeter;

    public DataplaneAuthReader(String topic, int numPartitions, Future<Consumer<K, V>> consumerFuture, KeyValueStore<K, V> cache, ConsumerListener<K, V> consumerListener, StatusListener statusListener, KafkaStoreConfig kafkaStoreConfig, Time time, Meter recordFailureMeter) {
        super(topic, numPartitions, consumerFuture, cache, consumerListener, statusListener, kafkaStoreConfig, time);
        this.prepareReaderStartupState = false;
        this.lastSequenceId = new HashMap<K, Long>();
        this.recordFailureMeter = recordFailureMeter;
    }

    public DataplaneAuthReader(String topic, int numPartitions, Future<Consumer<K, V>> consumerFuture, KeyValueStore<K, V> cache, ConsumerListener<K, V> consumerListener, StatusListener statusListener, KafkaStoreConfig kafkaStoreConfig, Time time) {
        super(topic, numPartitions, consumerFuture, cache, consumerListener, statusListener, kafkaStoreConfig, time);
        this.prepareReaderStartupState = false;
        this.lastSequenceId = new HashMap<K, Long>();
        MetricName metricName = MetricsUtils.metricName("confluent.metadata", METRIC_TYPE, "record-error-rate", Collections.emptyMap());
        this.recordFailureMeter = MetricsUtils.newMeter(metricName, "records");
        this.metricNames.add(metricName);
    }

    @Override
    protected List<CompletableFuture<Void>> partitionReadyFutures() {
        return this.partitionStates.values().stream().map(s -> s.existingRecordsFuture).collect(Collectors.toList());
    }

    public CompletableFuture<Void> existingRecordsFuture(TopicPartition topicPartition) {
        return ((KafkaReader.PartitionState)this.partitionStates.get((Object)topicPartition)).existingRecordsFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @VisibleForTesting
    public void processConsumerRecord(ConsumerRecord<K, V> record) {
        try {
            log.debug("Processing new record {}", record);
            Object key = record.key();
            if (key == null) {
                log.error("Record {} is missing a key. Ignoring this record.", record);
                this.recordFailureMeter.mark();
                return;
            }
            Long currSeqId = AuthUtils.tryParseEventsSequenceId(record);
            if (currSeqId == null) {
                log.error("Sequence id is missing from the headers of record with key {}, offset {}, partition {}. Ignoring this record.", new Object[]{key, record.offset(), record.partition()});
                this.recordFailureMeter.mark();
                return;
            }
            if (this.deserializationErrorForRecordKey(record) || this.deserializationErrorForRecordValue(record)) {
                return;
            }
            this.updateAuthCache(record, currSeqId);
        }
        catch (Exception e) {
            log.error("Error while processing the auth topic record with key {}, offset {}, partition {}. Ignoring the record.", new Object[]{record.key(), record.offset(), record.partition(), e});
            this.recordFailureMeter.mark();
        }
        finally {
            KafkaReader.PartitionState partitionState = (KafkaReader.PartitionState)this.partitionStates.get(new TopicPartition(record.topic(), record.partition()));
            if (partitionState != null) {
                partitionState.onConsume(record.offset(), true);
            }
        }
    }

    protected boolean isValidJwtIssuerKey(ConsumerRecord<K, V> record) {
        boolean valid = true;
        Object key = record.key();
        if (key instanceof JwtIssuerKey) {
            JwtIssuerKey jwtIssuerKey = (JwtIssuerKey)key;
            boolean bl = valid = !Utils.isBlank((String)jwtIssuerKey.jwksEndpoint());
        }
        if (!valid) {
            log.warn("JwtIssuerKey is invalid. Ignoring the record. Record Key : {}, offset {}, partition {}", new Object[]{key, record.offset(), record.partition()});
        }
        return valid;
    }

    protected boolean isValidIdentityPoolValue(ConsumerRecord<K, V> record) {
        boolean valid = true;
        Object value = record.value();
        if (value instanceof IdentityPoolValue) {
            IdentityPoolValue identityPoolValue = (IdentityPoolValue)value;
            boolean bl = valid = !Utils.isBlank((String)identityPoolValue.jwksEndpoint());
        }
        if (!valid) {
            log.warn("IdentityPoolValue is invalid. JwksEndpoint is missing. Ignoring the record. Record Value : {}, offset {}, partition {}", new Object[]{value, record.offset(), record.partition()});
        }
        return valid;
    }

    private boolean deserializationErrorForRecordKey(ConsumerRecord<K, V> record) {
        Object key = record.key();
        if (key instanceof DataplaneBaseAuthStore.DeserializerErrorForKey) {
            log.error("Error occurred while deserializing the key of the record. Ignoring the record. Error details : {}, offset {}, partition {}", new Object[]{key, record.offset(), record.partition()});
            this.recordFailureMeter.mark();
            return true;
        }
        return key instanceof JwtIssuerKey && !this.isValidJwtIssuerKey(record);
    }

    private boolean deserializationErrorForRecordValue(ConsumerRecord<K, V> record) {
        Object key = record.key();
        Object value = record.value();
        if (value instanceof DataplaneBaseAuthStore.DeserializerErrorForValue) {
            log.error("Error occurred while deserializing value of the record. Ignoring the record. Record key {}, Error details : {}, offset {}, partition {}", new Object[]{key, value, record.offset(), record.partition()});
            this.recordFailureMeter.mark();
            return true;
        }
        return value instanceof IdentityPoolValue && !this.isValidIdentityPoolValue(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAuthCache(ConsumerRecord<K, V> record, long currSeqId) {
        Object key = record.key();
        Object newValue = record.value();
        Long prevSeqId = this.lastSequenceId.get(key);
        if (prevSeqId != null && prevSeqId != -1L && prevSeqId >= currSeqId) {
            log.warn("Ignoring older message for key {} with sequence id: {} (last seen id is {})", new Object[]{key, currSeqId, prevSeqId});
        } else {
            try {
                Object oldValue = newValue != null ? this.cache.put(key, newValue) : this.cache.remove(key);
                log.debug("Processing new record {}-{}:{} key {} newValue {} oldValue {}", new Object[]{record.topic(), record.partition(), record.offset(), key, newValue, oldValue});
                if (this.consumerListener != null) {
                    this.consumerListener.onConsumerRecord(record, oldValue);
                }
            }
            finally {
                this.lastSequenceId.put(key, currSeqId);
            }
        }
    }

    Map<K, Long> getLastSequenceId() {
        return Collections.unmodifiableMap(this.lastSequenceId);
    }

    @Override
    public void close(Duration closeTimeout) {
        super.close(closeTimeout);
        MetricsUtils.removeMetrics(this.metricNames);
    }
}

