/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.ipFiltering;

import io.confluent.security.auth.ipFiltering.IpFilteringUtils;
import io.confluent.security.authorizer.AccessRule;
import io.confluent.security.authorizer.AuthorizePolicy;
import io.confluent.security.authorizer.ResourcePattern;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.roledefinitions.Operation;
import io.confluent.security.roledefinitions.PermissionType;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public class IpFilteringAccessRule
extends AccessRule {
    private final String operationGroup;
    private final Collection<String> cidrs;
    private final Scope scope;

    public IpFilteringAccessRule(String operationGroup, Collection<String> cidrs, Scope scope) {
        super(ResourcePattern.ALL, KafkaPrincipal.ANONYMOUS, PermissionType.DENY, "*", Operation.ALL, AuthorizePolicy.PolicyType.DENY_IPF);
        this.operationGroup = Objects.requireNonNull(operationGroup);
        this.cidrs = Objects.requireNonNull(cidrs);
        this.scope = Objects.requireNonNull(scope);
    }

    public String operationGroup() {
        return this.operationGroup;
    }

    public Collection<String> cidrs() {
        return this.cidrs;
    }

    public Scope scope() {
        return this.scope;
    }

    public boolean matches(Set<KafkaPrincipal> matchingPrincipals, String host, Operation requestedOperation, PermissionType permissionType) {
        return this.matches(host, requestedOperation, permissionType);
    }

    public boolean matches(String host, Operation requestedOperation, PermissionType permissionType) {
        boolean isMatched = super.matches(host, requestedOperation, permissionType);
        if (isMatched) {
            for (String cidr : this.cidrs) {
                if (!IpFilteringUtils.isIpInCidr(host, cidr)) continue;
                isMatched = false;
                break;
            }
        }
        return isMatched;
    }

    public String toString() {
        return String.format("This is the IpFilteringAccessRule with policyType: %s, operation group: %s, scope: %s, CIDRs: %s", this.policyType(), this.operationGroup, this.scope, this.cidrs);
    }
}

