/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.ipFiltering;

import com.yammer.metrics.core.MetricName;
import io.confluent.security.auth.dataplane.DataplaneAuthReader;
import io.confluent.security.auth.dataplane.DataplaneAuthStore;
import io.confluent.security.auth.ipFiltering.IpFilteringAuthCache;
import io.confluent.security.auth.ipFiltering.IpFilteringAuthStoreMetrics;
import io.confluent.security.auth.metadata.AuthCache;
import io.confluent.security.auth.metadata.AuthStore;
import io.confluent.security.auth.metadata.AuthWriter;
import io.confluent.security.auth.store.data.AuthKey;
import io.confluent.security.auth.store.data.AuthValue;
import io.confluent.security.auth.store.data.LatencyRecordKey;
import io.confluent.security.auth.store.data.LatencyRecordValue;
import io.confluent.security.auth.store.kafka.KafkaAuthStore;
import io.confluent.security.auth.utils.MetricsUtils;
import io.confluent.security.operationgroupdefinitions.IpfOperationGroupDefinitions;
import io.confluent.security.store.kafka.KafkaStoreConfig;
import io.confluent.security.store.kafka.clients.ConsumerListener;
import io.confluent.security.store.kafka.clients.JsonSerde;
import io.confluent.security.store.kafka.clients.StatusListener;
import io.confluent.security.trustservice.store.TrustCache;
import java.net.URL;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.authorizer.internals.ConfluentAuthorizerServerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpFilteringAuthStore
implements AuthStore,
ConsumerListener<AuthKey, AuthValue> {
    private static final Logger log = LoggerFactory.getLogger(IpFilteringAuthStore.class);
    private static final Duration CLOSE_TIMEOUT = Duration.ofSeconds(30L);
    private KafkaStoreConfig clientConfig;
    private KafkaAuthStore.BackOffDecorator<Consumer<AuthKey, AuthValue>> decorator;
    private DataplaneAuthReader<AuthKey, AuthValue> reader;
    private final ConfluentAuthorizerServerInfo serverInfo;
    private final IpFilteringAuthCache authCache;
    private final JsonSerde<AuthKey> keySerde;
    private final JsonSerde<AuthValue> valueSerde;
    private final Time time;
    private final int numAuthTopicPartitions;
    private final IpFilteringStoreStatusListener statusListener;
    private final IpfOperationGroupDefinitions ipfOperationGroupDefinitions;
    private final IpFilteringLatencyRecordListener latencyRecordListener;
    private final Set<MetricName> metricNames;
    private static final String METRIC_TYPE = IpFilteringAuthStore.class.getSimpleName();
    private static final String METRIC_GROUP = "confluent.metadata";
    private final IpFilteringAuthStoreMetrics authStoreMetrics;

    public IpFilteringAuthStore(ConfluentAuthorizerServerInfo serverInfo) {
        this(serverInfo, Time.SYSTEM, 6);
    }

    public IpFilteringAuthStore(ConfluentAuthorizerServerInfo serverInfo, Time time, int numAuthTopicPartitions) {
        this.serverInfo = serverInfo;
        this.time = time;
        this.keySerde = DataplaneAuthStore.keySerde();
        this.valueSerde = DataplaneAuthStore.valueSerde();
        this.numAuthTopicPartitions = numAuthTopicPartitions;
        this.statusListener = new IpFilteringStoreStatusListener();
        this.ipfOperationGroupDefinitions = IpfOperationGroupDefinitions.loadDefaultPolicy();
        this.authCache = this.initializeCache();
        this.latencyRecordListener = new IpFilteringLatencyRecordListener();
        this.metricNames = new HashSet<MetricName>();
        this.metricNames.add(MetricsUtils.newGauge(METRIC_GROUP, METRIC_TYPE, "reader-failure-start-seconds-ago", Collections.emptyMap(), this.statusListener::secondsAfterReaderFailure));
        this.authStoreMetrics = new IpFilteringAuthStoreMetrics(serverInfo.metrics(), this.authCache);
    }

    public void configure(Map<String, ?> configs) {
        this.clientConfig = new KafkaStoreConfig((AuthorizerServerInfo)this.serverInfo, configs);
        Duration timeout = this.clientConfig.topicCreateTimeout;
        this.decorator = new KafkaAuthStore.BackOffDecorator(timeout, 0);
        CompletableFuture readyConsumer = this.decorator.withBackOff(() -> this.createConsumer(this.clientConfig.consumerConfigs("_confluent-metadata-auth")), KafkaAuthStore::retryPredicate);
        this.reader = new DataplaneAuthReader<AuthKey, AuthValue>("_confluent-metadata-auth", this.numAuthTopicPartitions, readyConsumer, this.authCache, this, this.statusListener, this.clientConfig, this.time);
        log.debug("Configured {} with configs {}", (Object)this.getClass().getName(), (Object)this.clientConfig);
    }

    public CompletionStage<Void> startReader() {
        return this.reader.start(this.clientConfig.topicCreateTimeout);
    }

    public CompletionStage<Void> startService(Collection<URL> serverUrls) {
        throw new UnsupportedOperationException("IpFilteringAuthStore does not support `startService`");
    }

    public AuthCache authCache() {
        throw new UnsupportedOperationException("IpFilteringAuthStore does not support `authCache`");
    }

    public void close() {
        Throwable exception;
        log.debug("Closing IpFilteringAuthStore");
        AtomicReference<Throwable> firstException = new AtomicReference<Throwable>();
        if (this.reader != null) {
            try {
                this.reader.close(CLOSE_TIMEOUT);
            }
            catch (Throwable e) {
                log.error("Failed to close reader", e);
                firstException.compareAndSet(null, e);
            }
            this.reader = null;
        }
        if (this.decorator != null) {
            try {
                this.decorator.close();
            }
            catch (Throwable e) {
                log.error("Failed to close decorator", e);
                firstException.compareAndSet(null, e);
            }
            this.decorator = null;
        }
        if ((exception = (Throwable)firstException.getAndSet(null)) != null) {
            throw new KafkaException("Failed to close IpFilteringAuthStore", exception);
        }
    }

    public TrustCache trustCache() {
        throw new UnsupportedOperationException("IpFilteringAuthStore does not support `trustCache`");
    }

    public AuthWriter writer() {
        throw new UnsupportedOperationException("IpFilteringAuthStore does not support `writer`");
    }

    public boolean isMasterWriter() {
        return false;
    }

    public URL masterWriterUrl(String protocol) {
        throw new UnsupportedOperationException("IpFilteringAuthStore does not support `masterWriterUrl`. Provided protocol: " + protocol);
    }

    public Integer masterWriterId() {
        throw new UnsupportedOperationException("IpFilteringAuthStore does not support `masterWriterId`");
    }

    public Collection<URL> activeNodeUrls(String protocol) {
        throw new UnsupportedOperationException("IpFilteringAuthStore does not support `activeNodeUrls`. Provided protocol: " + protocol);
    }

    public IpFilteringAuthCache ipFilteringAuthCache() {
        return this.authCache;
    }

    private Consumer<AuthKey, AuthValue> createConsumer(Map<String, Object> configs) {
        return new KafkaConsumer(configs, this.keySerde.deserializer(), this.valueSerde.deserializer());
    }

    private IpFilteringAuthCache initializeCache() {
        return new IpFilteringAuthCache(this.ipfOperationGroupDefinitions);
    }

    @Override
    public void onConsumerRecord(ConsumerRecord<AuthKey, AuthValue> record, AuthValue oldValue) {
        if (((AuthKey)record.key()).entryType() != null) {
            this.authStoreMetrics.recordsProcessedSensors.get(((AuthKey)record.key()).entryType()).record();
        }
        if (record.key() instanceof LatencyRecordKey && this.existingPartitionRecordsRead(new TopicPartition(record.topic(), record.partition()))) {
            this.latencyRecordListener.onLatencyRecord((LatencyRecordKey)record.key(), (LatencyRecordValue)record.value());
        }
    }

    private boolean existingPartitionRecordsRead(TopicPartition topicPartition) {
        return this.reader.existingRecordsFuture(topicPartition).isDone() && !this.reader.existingRecordsFuture(topicPartition).isCancelled() && !this.reader.existingRecordsFuture(topicPartition).isCompletedExceptionally();
    }

    private class IpFilteringStoreStatusListener
    implements StatusListener {
        private final AtomicLong readerFailureStartMs = new AtomicLong(0L);

        private IpFilteringStoreStatusListener() {
        }

        long secondsAfterReaderFailure() {
            return MetricsUtils.elapsedSeconds(IpFilteringAuthStore.this.time, this.readerFailureStartMs.get());
        }

        @Override
        public void onReaderSuccess() {
            this.readerFailureStartMs.set(0L);
        }

        @Override
        public boolean onReaderFailure() {
            this.readerFailureStartMs.compareAndSet(0L, IpFilteringAuthStore.this.time.milliseconds());
            return this.failed(this.readerFailureStartMs.get());
        }

        @Override
        public void onWriterSuccess(int partition) {
        }

        @Override
        public boolean onWriterFailure(int partition) {
            return false;
        }

        @Override
        public void onProduceSuccess(int partition) {
        }

        @Override
        public void onProduceFailure(int partition) {
        }

        @Override
        public void onRemoteSuccess(int partition) {
        }

        @Override
        public boolean onRemoteFailure(int partition) {
            return false;
        }

        private boolean failed(Long firstFailureMs) {
            if (firstFailureMs == null) {
                return false;
            }
            return IpFilteringAuthStore.this.time.milliseconds() > firstFailureMs + IpFilteringAuthStore.this.clientConfig.retryTimeout.toMillis();
        }
    }

    private class IpFilteringLatencyRecordListener {
        private final Map<String, Long> latencyRecordLastSeenByApp = new HashMap<String, Long>();

        IpFilteringLatencyRecordListener() {
        }

        protected synchronized Long secondsAfterLastLatencyRecordSeen(String app) {
            Long lastSeenMs = this.latencyRecordLastSeenByApp.getOrDefault(app, -1L);
            return lastSeenMs == -1L ? -1L : TimeUnit.MILLISECONDS.toSeconds(IpFilteringAuthStore.this.time.milliseconds() - lastSeenMs);
        }

        public synchronized void onLatencyRecord(LatencyRecordKey latencyRecordKey, LatencyRecordValue latencyRecordValue) {
            long currentTimeMs = IpFilteringAuthStore.this.time.milliseconds();
            this.latencyRecordLastSeenByApp.put(latencyRecordKey.app(), currentTimeMs);
            IpFilteringAuthStore.this.authStoreMetrics.registerLatencyGauge(latencyRecordKey.app(), () -> this.secondsAfterLastLatencyRecordSeen(latencyRecordKey.app()));
            IpFilteringAuthStore.this.authStoreMetrics.recordLatencyMetric(latencyRecordKey, currentTimeMs - latencyRecordValue.timestamp());
        }
    }
}

