/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.ipFiltering;

import io.confluent.security.auth.ipFiltering.IpFilteringAuthCache;
import io.confluent.security.auth.store.data.AuthEntryType;
import io.confluent.security.auth.store.data.LatencyRecordKey;
import io.confluent.security.auth.utils.LongGauge;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Meter;
import org.apache.kafka.common.metrics.stats.Min;
import org.apache.kafka.common.metrics.stats.Percentile;
import org.apache.kafka.common.metrics.stats.Percentiles;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.common.utils.Utils;

public class IpFilteringAuthStoreMetrics {
    public static final String GROUP_NAME = "confluent-ip-filtering-auth-store-metrics";
    public static final String IP_FILTERING_COUNT = "ip-filtering-count";
    public static final String IP_FILTERING_ACCESS_RULE_COUNT = "ip-filtering-access-rule-count";
    public static final String RECORD_IP_FILTERING_LATENCY_GAUGE = "ip_filtering.synthetic.time_since_last_message";
    public static final String RECORD_IP_FILTERING_LATENCY_METRIC = "ip_filtering.synthetic.latest_message_latency";
    private final Metrics metrics;
    public final EnumMap<AuthEntryType, Sensor> recordsProcessedSensors;
    private final IpFilteringAuthCache authCache;
    private final Map<LatencyRecordKey, Sensor> recordLatencySensors;

    public IpFilteringAuthStoreMetrics(Metrics metrics, IpFilteringAuthCache authCache) {
        this.metrics = metrics;
        this.authCache = authCache;
        this.recordsProcessedSensors = new EnumMap(AuthEntryType.class);
        this.registerAuthStoreMeters();
        this.recordLatencySensors = new HashMap<LatencyRecordKey, Sensor>();
    }

    public Metrics metrics() {
        return this.metrics;
    }

    private void registerAuthStoreMeters() {
        this.metrics.addMetricIfAbsent(this.metrics.metricName(IP_FILTERING_COUNT, GROUP_NAME, "The number of ip filtering defined"), null, (MetricValueProvider)((Gauge)(config, now) -> this.authCache.totalIpFilterings()));
        this.metrics.addMetricIfAbsent(this.metrics.metricName(IP_FILTERING_ACCESS_RULE_COUNT, GROUP_NAME, "The number of ip filtering access rules defined"), null, (MetricValueProvider)((Gauge)(config, now) -> this.authCache.totalIpFilteringAccessRules()));
        String recordType = AuthEntryType.IP_FILTERING.name().toLowerCase(Locale.ROOT);
        Sensor sensor = this.metrics.sensor("auth-records-processed-count-" + recordType);
        sensor.add((CompoundStat)new Meter(this.metrics.metricName("auth-records-processed-rate", GROUP_NAME, "The average number of records processed per second by the IP Filtering AuthStore consumer.", new String[]{"record-type", recordType}), this.metrics.metricName("auth-records-processed-total", GROUP_NAME, "The total number of records processed by the IP Filtering AuthStore consumer.", new String[]{"record-type", recordType})));
        this.recordsProcessedSensors.put(AuthEntryType.IP_FILTERING, sensor);
    }

    public void registerLatencyGauge(String app, Supplier<Long> valueSupplier) {
        MetricName metricName = this.metrics.metricName(RECORD_IP_FILTERING_LATENCY_GAUGE, GROUP_NAME, "Time in seconds elapsed since last latency record seen", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"app", (Object)app)}));
        if (this.metrics.metrics().get(metricName) == null) {
            this.metrics.addMetric(metricName, (MetricValueProvider)new LongGauge(valueSupplier));
        }
    }

    public void recordLatencyMetric(LatencyRecordKey latencyRecordKey, long latency) {
        if (this.recordLatencySensors.get(latencyRecordKey) == null) {
            this.registerLatencyMetrics(latencyRecordKey);
        }
        this.recordLatencySensors.get(latencyRecordKey).record((double)latency);
    }

    private void registerLatencyMetrics(LatencyRecordKey latencyRecordKey) {
        String metricBaseDescription = "Time in milliseconds to consume latency records";
        Map tags = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"app", (Object)latencyRecordKey.app()), Utils.mkEntry((Object)"cluster", (Object)latencyRecordKey.cluster())});
        Sensor sensor = this.metrics.sensor("ip_filtering.synthetic.latest_message_latency_sensor." + latencyRecordKey.app() + "." + latencyRecordKey.cluster());
        sensor.add(this.metrics.metricName(RECORD_IP_FILTERING_LATENCY_METRIC, GROUP_NAME, metricBaseDescription, tags), (MeasurableStat)new Value());
        sensor.add(this.metrics.metricName("ip_filtering.synthetic.latest_message_latency_min", GROUP_NAME, metricBaseDescription + " min", tags), (MeasurableStat)new Min());
        sensor.add(this.metrics.metricName("ip_filtering.synthetic.latest_message_latency_max", GROUP_NAME, metricBaseDescription + " max", tags), (MeasurableStat)new Max());
        sensor.add(this.metrics.metricName("ip_filtering.synthetic.latest_message_latency_avg", GROUP_NAME, metricBaseDescription + " avg", tags), (MeasurableStat)new Avg());
        double maxTotalTimeMs = 100000.0;
        int totalBucketSizeInBytes = 4000;
        Percentile p50 = new Percentile(this.metrics.metricName("ip_filtering.synthetic.latest_message_latency_p50", GROUP_NAME, metricBaseDescription + " p50", tags), 50.0);
        Percentile p95 = new Percentile(this.metrics.metricName("ip_filtering.synthetic.latest_message_latency_p90", GROUP_NAME, metricBaseDescription + " p90", tags), 90.0);
        Percentile p99 = new Percentile(this.metrics.metricName("ip_filtering.synthetic.latest_message_latency_p99", GROUP_NAME, metricBaseDescription + " p99", tags), 99.0);
        sensor.add((CompoundStat)new Percentiles(totalBucketSizeInBytes, maxTotalTimeMs, Percentiles.BucketSizing.LINEAR, new Percentile[]{p50, p95, p99}));
        this.recordLatencySensors.put(latencyRecordKey, sensor);
    }
}

