/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.ipFiltering;

import io.confluent.security.auth.ipFiltering.IpFilteringAuthCache;
import io.confluent.security.auth.ipFiltering.IpFilteringAuthStore;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.authorizer.provider.AccessRuleProvider;
import io.confluent.security.authorizer.provider.AuthorizeRule;
import io.confluent.security.authorizer.provider.ResourceAuthorizeRules;
import io.confluent.security.roledefinitions.Operation;
import io.confluent.security.roledefinitions.ResourceType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.authorizer.internals.ConfluentAuthorizerServerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpFilteringProvider
implements AccessRuleProvider {
    public static final String PROVIDER_NAME = "IP_FILTERING";
    private IpFilteringAuthStore authStore;
    private IpFilteringAuthCache authCache;
    private volatile boolean isStarted = false;
    private CompletionStage<Void> future = null;
    private Map<String, ?> configs;
    private Metrics kafkaMetrics = null;
    private static final Logger log = LoggerFactory.getLogger(IpFilteringProvider.class);

    public CompletionStage<Void> start(ConfluentAuthorizerServerInfo serverInfo) {
        log.info(String.format("Starting %s.", this.getClass().getName()));
        if (this.isStarted) {
            log.info(String.format("%s already started. Returning existing future.", this.getClass().getName()));
            return this.future;
        }
        HashMap mergedConfigs = new HashMap(this.configs);
        mergedConfigs.putAll(serverInfo.interBrokerClientConfig());
        this.authStore = this.createAuthStore(serverInfo, mergedConfigs);
        this.authCache = this.authStore.ipFilteringAuthCache();
        this.kafkaMetrics = serverInfo.metrics();
        CompletionStage<Void> readerFuture = this.authStore.startReader();
        this.future = readerFuture;
        this.isStarted = true;
        return this.future;
    }

    public void configure(Map<String, ?> configs) {
        log.info(String.format("Configuring %s.", this.getClass().getName()));
        if (this.isStarted) {
            log.info(String.format("%s already configured. Returning.", this.getClass().getName()));
            return;
        }
        this.configs = configs;
    }

    public boolean isSuperUser(KafkaPrincipal principal, Scope scope) {
        return false;
    }

    public AuthorizeRule findRule(KafkaPrincipal sessionPrincipal, Set<KafkaPrincipal> groupPrincipals, String host, Action action) {
        return this.authCache.findRule(host, action);
    }

    public void addMatchingRules(ResourceAuthorizeRules matchingRules, KafkaPrincipal sessionPrincipal, Set<KafkaPrincipal> groupPrincipals, String host, Operation operation, Scope resourceScope, ResourceType resourceType) {
        this.authCache.addMatchingRule(matchingRules, resourceScope, host, operation, resourceType);
    }

    public boolean mayDeny() {
        return true;
    }

    public String providerName() {
        return PROVIDER_NAME;
    }

    public boolean usesMetadataFromThisKafkaCluster() {
        return false;
    }

    public void close() {
        log.debug("Closing IpFiltering provider");
        AtomicReference<Object> firstException = new AtomicReference<Object>();
        Utils.closeQuietly((AutoCloseable)((Object)this.authStore), (String)"authStore", firstException);
        Throwable exception = firstException.getAndSet(null);
        if (exception != null) {
            throw new KafkaException("IpFilteringProvider could not be closed cleanly", exception);
        }
    }

    protected IpFilteringAuthStore createAuthStore(ConfluentAuthorizerServerInfo serverInfo, Map<String, ?> configs) {
        IpFilteringAuthStore authStore = new IpFilteringAuthStore(serverInfo);
        authStore.configure(configs);
        return authStore;
    }

    public boolean isStarted() {
        return this.isStarted;
    }
}

