/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.ipFiltering;

import org.apache.commons.net.util.SubnetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpFilteringUtils {
    private static final Logger log = LoggerFactory.getLogger(IpFilteringUtils.class);

    public static void validateCidr(String cidr) {
        try {
            new SubnetUtils(cidr);
        }
        catch (IllegalArgumentException e) {
            log.error("Invalid CIDR format: {}", (Object)cidr, (Object)e);
            throw e;
        }
    }

    public static boolean isIpInCidr(String host, String cidr) {
        try {
            SubnetUtils subnetUtils = new SubnetUtils(cidr);
            subnetUtils.setInclusiveHostCount(true);
            return subnetUtils.getInfo().isInRange(host);
        }
        catch (IllegalArgumentException e) {
            log.error("Invalid CIDR format: {}", (Object)cidr, (Object)e);
            return false;
        }
    }
}

