/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.provider.ldap;

import io.confluent.security.auth.metadata.AuthCache;
import io.confluent.security.auth.provider.ldap.LdapConfig;
import io.confluent.security.auth.provider.ldap.LdapGroupManager;
import io.confluent.security.auth.store.data.AuthKey;
import io.confluent.security.auth.store.data.AuthValue;
import io.confluent.security.auth.store.data.UserKey;
import io.confluent.security.auth.store.data.UserValue;
import io.confluent.security.auth.store.external.ExternalStore;
import io.confluent.security.auth.store.external.ExternalStoreListener;
import io.confluent.security.auth.store.kafka.KafkaAuthWriter;
import io.confluent.security.store.MetadataStoreStatus;
import java.util.Map;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapStore
implements ExternalStore {
    private static final Logger log = LoggerFactory.getLogger(LdapStore.class);
    private final Time time;
    private final UserStoreListener listener;
    private LdapConfig config;
    private LdapGroupManager ldapGroupManager;

    public LdapStore(AuthCache authCache, KafkaAuthWriter writer, Time time) {
        this.time = time;
        this.listener = new UserStoreListener(authCache, writer);
    }

    public void configure(Map<String, ?> configs) {
        this.config = new LdapConfig(configs);
    }

    @Override
    public void start(int generationId) {
        log.info("Starting LdapStore");
        if (this.ldapGroupManager != null) {
            throw new IllegalStateException("LDAP group manager for generation " + this.listener.generationId + " is still active");
        }
        this.listener.generationId = generationId;
        this.ldapGroupManager = this.createLdapGroupManager(this.listener);
        this.ldapGroupManager.start();
    }

    @Override
    public void stop(Integer generationId) {
        log.info("Stopping LdapStore");
        this.listener.stop();
        if (this.ldapGroupManager != null) {
            this.ldapGroupManager.close();
            this.ldapGroupManager = null;
        }
        this.listener.generationId = -1;
    }

    @Override
    public boolean failed() {
        LdapGroupManager manager = this.ldapGroupManager;
        return manager != null && manager.failed();
    }

    protected LdapGroupManager createLdapGroupManager(ExternalStoreListener<UserKey, UserValue> listener) {
        return new LdapGroupManager(this.config, this.time, listener);
    }

    private static class UserStoreListener
    implements ExternalStoreListener<UserKey, UserValue> {
        private final AuthCache authCache;
        private final KafkaAuthWriter writer;
        private volatile int generationId;
        private volatile boolean active;

        UserStoreListener(AuthCache authCache, KafkaAuthWriter writer) {
            this.authCache = authCache;
            this.writer = writer;
        }

        @Override
        public void start() {
            this.active = true;
        }

        @Override
        public void stop() {
            this.active = false;
        }

        @Override
        public void initialize(Map<UserKey, UserValue> initialValues) {
            Map cachedUsers = this.authCache.users();
            cachedUsers.forEach((user, metadata) -> {
                UserKey key = new UserKey(user);
                UserValue value = (UserValue)initialValues.get(key);
                if (value != null) {
                    if (!value.groups().equals(metadata.groups())) {
                        this.update(key, value);
                    }
                } else {
                    this.delete(key);
                }
            });
            initialValues.entrySet().stream().filter(e -> !cachedUsers.containsKey(((UserKey)e.getKey()).principal())).forEach(e -> this.update((UserKey)e.getKey(), (UserValue)e.getValue()));
        }

        @Override
        public void update(UserKey key, UserValue value) {
            if (this.active) {
                this.writer.writeExternalEntry((AuthKey)key, (AuthValue)value, this.generationId);
            }
        }

        @Override
        public void delete(UserKey key) {
            if (this.active) {
                this.writer.writeExternalEntry((AuthKey)key, null, this.generationId);
            }
        }

        @Override
        public void fail(String errorMessage) {
            if (this.active) {
                this.writer.writeExternalStatus(MetadataStoreStatus.FAILED, errorMessage, this.generationId);
            }
        }

        @Override
        public void resetFailure() {
            if (this.active) {
                this.writer.writeExternalStatus(MetadataStoreStatus.INITIALIZED, null, this.generationId);
            }
        }
    }
}

