/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.store.cache;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.annotations.VisibleForTesting;
import io.confluent.security.auth.metadata.AuthCache;
import io.confluent.security.auth.mtls.CaCertificatesUtils;
import io.confluent.security.auth.mtls.CertIdentityPool;
import io.confluent.security.auth.mtls.DefaultMTlsTruststoreManager;
import io.confluent.security.auth.store.cache.AccessRuleStore;
import io.confluent.security.auth.store.data.AclBindingKey;
import io.confluent.security.auth.store.data.AclBindingValue;
import io.confluent.security.auth.store.data.AuthEntryType;
import io.confluent.security.auth.store.data.AuthKey;
import io.confluent.security.auth.store.data.AuthValue;
import io.confluent.security.auth.store.data.CaCertCrlKey;
import io.confluent.security.auth.store.data.CaCertCrlValue;
import io.confluent.security.auth.store.data.CaCertificatesKey;
import io.confluent.security.auth.store.data.CaCertificatesValue;
import io.confluent.security.auth.store.data.CertIdentityPoolKey;
import io.confluent.security.auth.store.data.CertIdentityPoolValue;
import io.confluent.security.auth.store.data.IdentityPoolKey;
import io.confluent.security.auth.store.data.IdentityPoolValue;
import io.confluent.security.auth.store.data.IdentityProviderKey;
import io.confluent.security.auth.store.data.IdentityProviderValue;
import io.confluent.security.auth.store.data.JwtIssuerKey;
import io.confluent.security.auth.store.data.JwtIssuerValue;
import io.confluent.security.auth.store.data.RefreshTokenInfoKey;
import io.confluent.security.auth.store.data.RefreshTokenInfoValue;
import io.confluent.security.auth.store.data.RoleBindingKey;
import io.confluent.security.auth.store.data.RoleBindingValue;
import io.confluent.security.auth.store.data.StatusKey;
import io.confluent.security.auth.store.data.StatusValue;
import io.confluent.security.auth.store.data.TrustCacheUtils;
import io.confluent.security.auth.store.data.UserKey;
import io.confluent.security.auth.store.data.UserValue;
import io.confluent.security.authentication.oidc.RefreshTokenInfo;
import io.confluent.security.authorizer.AccessRule;
import io.confluent.security.authorizer.AclAccessRule;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.AuthorizePolicy;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.authorizer.acl.AclRule;
import io.confluent.security.authorizer.provider.AuthorizeRule;
import io.confluent.security.authorizer.provider.InvalidScopeException;
import io.confluent.security.authorizer.provider.ResourceAuthorizeRules;
import io.confluent.security.authorizer.utils.JsonMapper;
import io.confluent.security.mtls.CertIdentityPoolFilter;
import io.confluent.security.mtls.CertificateMetadata;
import io.confluent.security.mtls.CertificateUtils;
import io.confluent.security.rbac.InvalidRoleBindingException;
import io.confluent.security.rbac.RbacAccessRule;
import io.confluent.security.rbac.RoleBinding;
import io.confluent.security.rbac.RoleBindingFilter;
import io.confluent.security.rbac.UserMetadata;
import io.confluent.security.roledefinitions.AccessPolicy;
import io.confluent.security.roledefinitions.Operation;
import io.confluent.security.roledefinitions.PermissionType;
import io.confluent.security.roledefinitions.RbacRoles;
import io.confluent.security.roledefinitions.ResourceType;
import io.confluent.security.roledefinitions.Role;
import io.confluent.security.store.KeyValueStore;
import io.confluent.security.store.MetadataStoreException;
import io.confluent.security.store.MetadataStoreStatus;
import io.confluent.security.trustservice.store.TrustCache;
import io.confluent.security.trustservice.store.data.IdentityPool;
import io.confluent.security.trustservice.store.data.IdentityProvider;
import java.io.IOException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.network.PublicCredential;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.security.auth.ConfluentPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.mtls.MTlsConnectionManager;
import org.apache.kafka.common.security.mtls.MTlsTruststoreManager;
import org.jose4j.jwk.JsonWebKeySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuthCache
implements AuthCache,
TrustCache,
KeyValueStore<AuthKey, AuthValue> {
    private static final Logger log = LoggerFactory.getLogger(AbstractAuthCache.class);
    private static final String WILDCARD_HOST = "*";
    private static final Map<RoleBindingKey, RoleBindingValue> NO_ROLE_BINDINGS = Collections.emptyMap();
    private static final String IP_FILTERING_NOT_SUPPORTED_MSG = "IP filtering entry type is not supported in this cache";
    private final RbacRoles rbacRoles;
    protected final Scope rootScope;
    private final Map<KafkaPrincipal, UserMetadata> users;
    protected final Map<KafkaPrincipal, Map<RoleBindingKey, RoleBindingValue>> roleBindings;
    private final Map<String, Set<String>> orgToProvidersMapping;
    private final Map<String, IdentityProvider> identityProviders;
    private final Map<String, Set<String>> providerToPoolsMapping;
    protected final Map<String, JsonWebKeySet> jsonWebKeys;
    protected final Map<String, IdentityPool> identityPools;
    private final Map<Integer, StatusValue> partitionStatus;
    private final Map<String, RefreshTokenInfo> refreshTokens;
    protected final AccessRuleStore rbacAccessRuleStore;
    protected final AccessRuleStore aclAccessRuleStore;
    private final Map<Certificate, Map<String, Set<String>>> caCertToProvidersMapping;
    private final Map<String, Map<String, Set<Certificate>>> orgToCaCertMapping;
    private final Map<String, CaCertificatesValue> caCertificates;
    private MTlsTruststoreManager mTlsTruststoreManager;
    private final Map<String, CertIdentityPool> certIdentityPools;
    private final CertIdentityPoolFilter certIdentityPoolFilter;
    private MTlsConnectionManager mTlsConnectionManager;
    private final Map<String, Map<String, X509CRL>> caCrls;

    public AbstractAuthCache(RbacRoles rbacRoles, Scope rootScope, AccessRuleStore rbacAccessRuleStore, AccessRuleStore aclAccessRuleStore) {
        this.rbacRoles = rbacRoles;
        this.rootScope = rootScope;
        this.users = new ConcurrentHashMap<KafkaPrincipal, UserMetadata>();
        this.roleBindings = new ConcurrentHashMap<KafkaPrincipal, Map<RoleBindingKey, RoleBindingValue>>();
        this.jsonWebKeys = new ConcurrentHashMap<String, JsonWebKeySet>();
        this.identityPools = new ConcurrentHashMap<String, IdentityPool>();
        this.partitionStatus = new ConcurrentHashMap<Integer, StatusValue>();
        this.refreshTokens = new ConcurrentHashMap<String, RefreshTokenInfo>();
        this.rbacAccessRuleStore = rbacAccessRuleStore;
        this.aclAccessRuleStore = aclAccessRuleStore;
        this.caCertificates = new ConcurrentHashMap<String, CaCertificatesValue>();
        this.caCertToProvidersMapping = new ConcurrentHashMap<Certificate, Map<String, Set<String>>>();
        this.orgToCaCertMapping = new ConcurrentHashMap<String, Map<String, Set<Certificate>>>();
        this.certIdentityPools = new ConcurrentHashMap<String, CertIdentityPool>();
        this.certIdentityPoolFilter = new CertIdentityPoolFilter();
        this.caCrls = new ConcurrentHashMap<String, Map<String, X509CRL>>();
        this.orgToProvidersMapping = new ConcurrentHashMap<String, Set<String>>();
        this.identityProviders = new ConcurrentHashMap<String, IdentityProvider>();
        this.providerToPoolsMapping = new ConcurrentHashMap<String, Set<String>>();
    }

    public abstract AuthorizeRule findRule(KafkaPrincipal var1, Set<KafkaPrincipal> var2, String var3, Action var4);

    public Set<KafkaPrincipal> groups(KafkaPrincipal sessionPrincipal) {
        this.ensureNotFailed();
        HashSet<KafkaPrincipal> result = new HashSet<KafkaPrincipal>(this.groupPrincipals(sessionPrincipal));
        KafkaPrincipal userPrincipal = this.userPrincipal(sessionPrincipal);
        UserMetadata user = this.users.get(userPrincipal);
        if (user != null) {
            result.addAll(user.groups());
        }
        return result;
    }

    private KafkaPrincipal userPrincipal(KafkaPrincipal sessionPrincipal) {
        return Objects.nonNull(sessionPrincipal) && sessionPrincipal.getClass() != KafkaPrincipal.class ? new KafkaPrincipal(sessionPrincipal.getPrincipalType(), sessionPrincipal.getName()) : sessionPrincipal;
    }

    private Set<KafkaPrincipal> groupPrincipals(KafkaPrincipal sessionPrincipal) {
        return Optional.of(sessionPrincipal).filter(p -> p instanceof ConfluentPrincipal).map((? super T p) -> (ConfluentPrincipal)p).map(ConfluentPrincipal::getGroups).orElse(Collections.emptySet()).stream().map((? super T group) -> new KafkaPrincipal("Group", group)).collect(Collectors.toSet());
    }

    public Set<RoleBinding> rbacRoleBindings(Scope scope) {
        this.ensureNotFailed();
        HashSet<RoleBinding> bindings = new HashSet<RoleBinding>();
        this.roleBindings.values().stream().flatMap(map -> map.entrySet().stream()).filter(e -> scope.equals((Object)((RoleBindingKey)e.getKey()).scope())).forEach(e -> bindings.add(this.roleBinding((RoleBindingKey)e.getKey(), (RoleBindingValue)e.getValue())));
        return bindings;
    }

    public Set<RoleBinding> rbacRoleBindings(Set<Scope> scopes) {
        this.ensureNotFailed();
        HashSet<RoleBinding> bindings = new HashSet<RoleBinding>();
        this.roleBindings.values().stream().flatMap(map -> map.entrySet().stream()).filter(e -> scopes.contains(((RoleBindingKey)e.getKey()).scope())).forEach(e -> bindings.add(this.roleBinding((RoleBindingKey)e.getKey(), (RoleBindingValue)e.getValue())));
        return bindings;
    }

    public Set<RoleBinding> rbacRoleBindings(RoleBindingFilter filter) {
        this.ensureNotFailed();
        HashSet<RoleBinding> bindings = new HashSet<RoleBinding>();
        this.roleBindings.values().stream().flatMap(map -> map.entrySet().stream()).map((? super T e) -> this.roleBinding((RoleBindingKey)e.getKey(), (RoleBindingValue)e.getValue())).forEach(binding -> {
            RoleBinding matching = filter.matchingBinding(binding, this.rbacRoles.role(binding.role()).bindWithResource());
            if (matching != null) {
                bindings.add(matching);
            }
        });
        return bindings;
    }

    public Set<RoleBinding> rbacRoleBindings(KafkaPrincipal principal) {
        this.ensureNotFailed();
        Set<KafkaPrincipal> principals = this.principalsToLookup(principal);
        return principals.stream().map(this.roleBindings::get).filter(Objects::nonNull).flatMap(map -> map.entrySet().stream()).map((? super T entry) -> this.roleBinding((RoleBindingKey)entry.getKey(), (RoleBindingValue)entry.getValue())).collect(Collectors.toSet());
    }

    private Set<KafkaPrincipal> principalsToLookup(KafkaPrincipal principal) {
        HashSet<KafkaPrincipal> principals = new HashSet<KafkaPrincipal>(this.groups(principal));
        principals.add(this.userPrincipal(principal));
        return principals;
    }

    public Set<RoleBinding> rbacRoleBindings(KafkaPrincipal principal, Set<Scope> scopes) {
        this.ensureNotFailed();
        Set<KafkaPrincipal> principals = this.principalsToLookup(principal);
        return principals.stream().map(this.roleBindings::get).filter(Objects::nonNull).flatMap(map -> map.entrySet().stream()).filter(entry -> scopes.contains(((RoleBindingKey)entry.getKey()).scope())).map((? super T entry) -> this.roleBinding((RoleBindingKey)entry.getKey(), (RoleBindingValue)entry.getValue())).collect(Collectors.toSet());
    }

    public Map<String, JsonWebKeySet> jsonWebKeySets() {
        return Collections.unmodifiableMap(this.jsonWebKeys);
    }

    public JsonWebKeySet jsonWebKeySet(String jwtKey) {
        return this.jsonWebKeys.getOrDefault(jwtKey, null);
    }

    public IdentityPool identityPool(String poolId) {
        return this.identityPools.get(poolId);
    }

    public Map<String, IdentityPool> identityPools() {
        return Collections.unmodifiableMap(this.identityPools);
    }

    public RefreshTokenInfo refreshTokenInfo(String refreshTokenKey) {
        return this.refreshTokens.get(refreshTokenKey);
    }

    public UserMetadata userMetadata(KafkaPrincipal userPrincipal) {
        return this.users.get(userPrincipal);
    }

    public Map<KafkaPrincipal, UserMetadata> users() {
        return Collections.unmodifiableMap(this.users);
    }

    public Set<Scope> knownScopes() {
        this.ensureNotFailed();
        return new HashSet<Scope>(this.rbacAccessRuleStore.knownScopes());
    }

    public Scope rootScope() {
        return this.rootScope;
    }

    public RbacRoles rbacRoles() {
        return this.rbacRoles;
    }

    public Map<io.confluent.security.authorizer.ResourcePattern, Set<AccessRule>> aclRules(Scope scope) {
        this.ensureNotFailed();
        return Collections.unmodifiableMap(this.aclAccessRuleStore.get(scope));
    }

    public Collection<AclBinding> aclBindings(Scope scope, AclBindingFilter aclBindingFilter, Predicate<io.confluent.security.authorizer.ResourcePattern> resourceAccess) {
        this.ensureNotFailed();
        if (!this.rootScope.containsScope(scope)) {
            throw new InvalidScopeException("This authorization cache does not contain scope " + String.valueOf(scope));
        }
        if (aclBindingFilter.isUnknown()) {
            throw new InvalidRequestException("The AclBindingFilter must not contain UNKNOWN elements.");
        }
        HashSet<AclBinding> aclBindings = new HashSet<AclBinding>();
        for (Scope nextScope = scope; nextScope != null; nextScope = nextScope.parent()) {
            NavigableMap<io.confluent.security.authorizer.ResourcePattern, Set<AccessRule>> rules = this.aclAccessRuleStore.get(nextScope);
            if (rules == null) continue;
            for (Map.Entry e : rules.entrySet()) {
                io.confluent.security.authorizer.ResourcePattern resourcePattern = (io.confluent.security.authorizer.ResourcePattern)e.getKey();
                if (!resourceAccess.test(resourcePattern)) continue;
                Set accessRules = (Set)e.getValue();
                for (AccessRule accessRule : accessRules) {
                    AclBinding fixture = new AclBinding(io.confluent.security.authorizer.ResourcePattern.to((io.confluent.security.authorizer.ResourcePattern)resourcePattern), AclRule.accessControlEntry((AccessRule)accessRule));
                    if (!aclBindingFilter.matches(fixture)) continue;
                    aclBindings.add(fixture);
                }
            }
        }
        return aclBindings;
    }

    public void addMatchingRules(ResourceAuthorizeRules matchingRules, KafkaPrincipal userPrincipal, Set<KafkaPrincipal> groupPrincipals, String host, Operation operation, Scope resourceScope, ResourceType resourceType) {
        this.ensureNotFailed();
        if (!this.rootScope.containsScope(resourceScope)) {
            throw new InvalidScopeException("This authorization cache does not contain scope " + String.valueOf(resourceScope));
        }
        Set matchingPrincipals = AccessRule.matchingPrincipals((KafkaPrincipal)userPrincipal, groupPrincipals, (KafkaPrincipal)AccessRule.WILDCARD_USER_PRINCIPAL, (KafkaPrincipal)AccessRule.WILDCARD_GROUP_PRINCIPAL);
        this.aclAccessRuleStore.addMatchingRules(matchingRules, resourceScope, matchingPrincipals, host, operation, resourceType);
        this.rbacAccessRuleStore.addMatchingRules(matchingRules, resourceScope, matchingPrincipals, host, operation, resourceType);
    }

    public AuthCache.Result healthcheck() {
        try {
            this.ensureNotFailed();
            return AuthCache.Result.healthy();
        }
        catch (Exception e) {
            return AuthCache.Result.unhealthy((String)e.getMessage());
        }
    }

    public AuthValue get(AuthKey key) {
        switch (key.entryType()) {
            case ROLE_BINDING: {
                RoleBindingKey roleBindingKey = (RoleBindingKey)key;
                return (AuthValue)this.roleBindings.getOrDefault(roleBindingKey.principal(), NO_ROLE_BINDINGS).get(roleBindingKey);
            }
            case USER: {
                UserMetadata user = this.users.get(((UserKey)key).principal());
                return user == null ? null : new UserValue((Collection)user.groups());
            }
            case STATUS: {
                StatusKey statusKey = (StatusKey)key;
                return (AuthValue)this.partitionStatus.get(statusKey.partition());
            }
            case ACL_BINDING: {
                AclBindingKey aclBindingKey = (AclBindingKey)key;
                NavigableMap<io.confluent.security.authorizer.ResourcePattern, Set<AccessRule>> scopeRules = this.aclAccessRuleStore.get(aclBindingKey.scope());
                if (scopeRules != null) {
                    Set accessRules = (Set)scopeRules.get(aclBindingKey.resourcePattern());
                    return accessRules == null ? null : this.aclBindingValue(accessRules);
                }
                return null;
            }
            case IDENTITY_PROVIDER: {
                return this.getIdentityProvider((IdentityProviderKey)key);
            }
            case JWT_ISSUER: {
                return this.getJwtIssuer((JwtIssuerKey)key);
            }
            case IDENTITY_POOL: {
                return this.getIdentityPool((IdentityPoolKey)key);
            }
            case REFRESH_TOKEN_INFO: {
                RefreshTokenInfoKey refreshTokenInfoKey = (RefreshTokenInfoKey)key;
                RefreshTokenInfo refreshTokenInfo = this.refreshTokens.get(refreshTokenInfoKey.cacheKey());
                return refreshTokenInfo == null ? null : new RefreshTokenInfoValue(refreshTokenInfo);
            }
            case CA_CERTIFICATES: {
                return this.getCaCertificates((CaCertificatesKey)key);
            }
            case CERT_IDENTITY_POOL: {
                return this.getCertIdentityPool((CertIdentityPoolKey)key);
            }
            case CA_CERT_CRL: {
                return this.getCaCertCrl((CaCertCrlKey)key);
            }
            case IP_FILTERING: {
                log.info(IP_FILTERING_NOT_SUPPORTED_MSG);
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown key type " + String.valueOf(key.entryType()));
    }

    public void updateAuthCacheExternally(String key, String value) throws JsonProcessingException {
        log.trace("update auth cache externally from confluentKeyValueStreams, key: " + key + " value: " + value);
        AuthKey authkey = (AuthKey)JsonMapper.objectMapper().readValue(key, AuthKey.class);
        if (value != null && !value.isEmpty()) {
            AuthValue authValue = (AuthValue)JsonMapper.objectMapper().readValue(value, AuthValue.class);
            this.put(authkey, authValue);
        } else {
            this.remove(authkey);
        }
    }

    public AuthValue put(AuthKey key, AuthValue value) {
        if (value == null) {
            throw new IllegalArgumentException("Value must not be null");
        }
        if (key.entryType() != value.entryType()) {
            throw new CorruptRecordException("Invalid record with key=" + String.valueOf(key) + ", value=" + String.valueOf(value));
        }
        switch (key.entryType()) {
            case ROLE_BINDING: {
                return this.updateRoleBinding((RoleBindingKey)key, (RoleBindingValue)value);
            }
            case ACL_BINDING: {
                return this.updateAclBinding((AclBindingKey)key, (AclBindingValue)value);
            }
            case USER: {
                return this.updateUser((UserKey)key, (UserValue)value);
            }
            case IDENTITY_PROVIDER: {
                return this.updateIdentityProvider((IdentityProviderKey)key, (IdentityProviderValue)value);
            }
            case JWT_ISSUER: {
                return this.updateJwtIssuer((JwtIssuerKey)key, (JwtIssuerValue)value);
            }
            case IDENTITY_POOL: {
                return this.updateIdentityPool((IdentityPoolKey)key, (IdentityPoolValue)value);
            }
            case STATUS: {
                StatusValue status = (StatusValue)value;
                if (status.status() == MetadataStoreStatus.FAILED) {
                    log.error("Received failed status with key {} value {}", (Object)key, (Object)value);
                } else {
                    log.debug("Processing status with key {} value {}", (Object)key, (Object)value);
                }
                return (AuthValue)this.partitionStatus.put(((StatusKey)key).partition(), status);
            }
            case LATENCY_RECORD: {
                return null;
            }
            case REFRESH_TOKEN_INFO: {
                return this.updateRefreshTokenInfo((RefreshTokenInfoKey)key, (RefreshTokenInfoValue)value);
            }
            case CA_CERTIFICATES: {
                return this.updateCaCertificates((CaCertificatesKey)key, (CaCertificatesValue)value);
            }
            case CERT_IDENTITY_POOL: {
                return this.updateCertIdentityPool((CertIdentityPoolKey)key, (CertIdentityPoolValue)value);
            }
            case CA_CERT_CRL: {
                return this.updateCaCertCrl((CaCertCrlKey)key, (CaCertCrlValue)value);
            }
            case IP_FILTERING: {
                log.info(IP_FILTERING_NOT_SUPPORTED_MSG);
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown key type " + String.valueOf(key.entryType()));
    }

    public AuthValue remove(AuthKey key) {
        switch (key.entryType()) {
            case ROLE_BINDING: {
                return this.removeRoleBinding((RoleBindingKey)key);
            }
            case ACL_BINDING: {
                return this.removeAclBinding((AclBindingKey)key);
            }
            case USER: {
                UserMetadata oldUser = this.users.remove(((UserKey)key).principal());
                return oldUser == null ? null : new UserValue((Collection)oldUser.groups());
            }
            case IDENTITY_PROVIDER: {
                return this.removeIdentityProvider((IdentityProviderKey)key);
            }
            case JWT_ISSUER: {
                return this.removeJwtIssuer((JwtIssuerKey)key);
            }
            case IDENTITY_POOL: {
                return this.removeIdentityPool((IdentityPoolKey)key);
            }
            case STATUS: {
                return (AuthValue)this.partitionStatus.remove(((StatusKey)key).partition());
            }
            case LATENCY_RECORD: {
                return null;
            }
            case REFRESH_TOKEN_INFO: {
                RefreshTokenInfo oldRefreshTokenInfo = this.refreshTokens.remove(((RefreshTokenInfoKey)key).cacheKey());
                return oldRefreshTokenInfo == null ? null : new RefreshTokenInfoValue(oldRefreshTokenInfo);
            }
            case CA_CERTIFICATES: {
                return this.removeCaCertificates((CaCertificatesKey)key);
            }
            case CERT_IDENTITY_POOL: {
                return this.removeCertIdentityPool((CertIdentityPoolKey)key);
            }
            case CA_CERT_CRL: {
                return this.removeCaCertCrl((CaCertCrlKey)key);
            }
            case IP_FILTERING: {
                log.info(IP_FILTERING_NOT_SUPPORTED_MSG);
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown key type " + String.valueOf(key.entryType()));
    }

    public Map<? extends AuthKey, ? extends AuthValue> map(String type) {
        AuthEntryType entryType = AuthEntryType.valueOf((String)type);
        switch (entryType) {
            case ROLE_BINDING: {
                Map<RoleBindingKey, RoleBindingValue> roleBindingsMap = this.roleBindings.values().stream().flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                return Collections.unmodifiableMap(roleBindingsMap);
            }
            case USER: {
                return this.users.entrySet().stream().collect(Collectors.toMap(e -> new UserKey((KafkaPrincipal)e.getKey()), e -> new UserValue((Collection)((UserMetadata)e.getValue()).groups())));
            }
            case STATUS: {
                return this.partitionStatus.entrySet().stream().collect(Collectors.toMap(e -> new StatusKey(((Integer)e.getKey()).intValue()), Map.Entry::getValue));
            }
            case IP_FILTERING: {
                log.info(IP_FILTERING_NOT_SUPPORTED_MSG);
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown key type " + String.valueOf(entryType));
    }

    public void fail(int partition, String errorMessage) {
        this.partitionStatus.put(partition, new StatusValue(MetadataStoreStatus.FAILED, -1, null, errorMessage));
    }

    public MetadataStoreStatus status(int partition) {
        StatusValue statusValue = this.partitionStatus.get(partition);
        return statusValue != null ? statusValue.status() : MetadataStoreStatus.UNKNOWN;
    }

    public Collection<IdentityPool> findIdentityPools(String providerId) {
        return TrustCacheUtils.findIdentityPools(this.identityPools, this.providerToPoolsMapping, (String)providerId);
    }

    public Collection<String> findIdentityProviderIds(String organizationId) {
        return TrustCacheUtils.findIdentityProviderIds(this.orgToProvidersMapping, (String)organizationId);
    }

    public IdentityProvider identityProvider(String providerId) {
        return this.identityProviders.get(providerId);
    }

    public Collection<CaCertificatesKey> findCertIdentityProviders(Certificate[] certificates, String organizationId) {
        if (organizationId == null || organizationId.isEmpty()) {
            throw new IllegalArgumentException("organizationId must not be null or empty");
        }
        if (certificates == null || certificates.length == 0) {
            throw new IllegalArgumentException("certificates must not be null or empty");
        }
        for (Certificate certificate : certificates) {
            Set<String> providers;
            Map<String, Set<String>> identityProviders = this.caCertToProvidersMapping.get(certificate);
            if (identityProviders == null || (providers = identityProviders.get(organizationId)) == null || providers.isEmpty()) continue;
            return providers.stream().map((? super T providerId) -> new CaCertificatesKey(providerId, organizationId)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public Collection<CertIdentityPool> findCertIdentityPools(X509Certificate cert, String orgId, String providerId) {
        if (orgId == null || orgId.isEmpty()) {
            throw new IllegalArgumentException("orgId must be provided");
        }
        if (cert == null) {
            return Collections.emptyList();
        }
        Map parsedCertMetadata = new CertificateMetadata(cert).getCelVars();
        return this.findCertIdentityPools(parsedCertMetadata, orgId, providerId);
    }

    public Collection<CertIdentityPool> findCertIdentityPools(Map<String, String> parsedCertMetadata, String orgId, String providerId) {
        if (orgId == null || orgId.isEmpty()) {
            throw new IllegalArgumentException("orgId must be provided");
        }
        if (parsedCertMetadata == null) {
            return Collections.emptyList();
        }
        return this.certIdentityPools.values().stream().filter(pool -> pool.organizationId().equals(orgId) && (providerId == null || pool.providerId().equals(providerId)) && this.certIdentityPoolFilter.filter(pool.filter(), parsedCertMetadata)).collect(Collectors.toList());
    }

    public boolean isRevoked(X509Certificate certificate, String organizationId, String providerId) {
        if (certificate == null) {
            throw new IllegalArgumentException("certificate must not be null");
        }
        if (organizationId == null || organizationId.isEmpty()) {
            throw new IllegalArgumentException("organizationId must not be null or empty");
        }
        if (providerId == null || providerId.isEmpty()) {
            throw new IllegalArgumentException("providerId must not be null or empty");
        }
        X509CRL crl = this.getCrl(organizationId, providerId);
        if (crl == null) {
            return false;
        }
        return crl.getIssuerX500Principal().equals(certificate.getIssuerX500Principal()) && crl.isRevoked(certificate);
    }

    public boolean isRevoked(Certificate[] certificates, String organizationId, String providerId) {
        if (certificates == null || certificates.length == 0) {
            throw new IllegalArgumentException("certificates must not be null or empty");
        }
        for (Certificate certificate : certificates) {
            if (!this.isRevoked((X509Certificate)certificate, organizationId, providerId)) continue;
            return true;
        }
        return false;
    }

    public boolean isCompleteCertChain(Certificate[] certChain, String organizationId) {
        if (organizationId == null || organizationId.isEmpty()) {
            throw new IllegalArgumentException("organizationId must not be null or empty");
        }
        if (certChain == null || certChain.length == 0) {
            throw new IllegalArgumentException("certChain must not be null or empty");
        }
        if (!this.caCertToProvidersMapping.containsKey(certChain[certChain.length - 1]) || this.caCertToProvidersMapping.get(certChain[certChain.length - 1]).getOrDefault(organizationId, Collections.emptySet()).isEmpty()) {
            return false;
        }
        for (int i = 0; i < certChain.length - 1; ++i) {
            Certificate cert = certChain[i];
            Certificate issuer = certChain[i + 1];
            try {
                cert.verify(issuer.getPublicKey());
                continue;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public Certificate[] getCertChain(Certificate[] partialChain, String organizationId) {
        if (organizationId == null || organizationId.isEmpty()) {
            throw new IllegalArgumentException("organizationId must not be null or empty");
        }
        return CaCertificatesUtils.buildCertChain(partialChain, this.orgToCaCertMapping.getOrDefault(organizationId, Collections.emptyMap()));
    }

    public int totalRoleBindings() {
        return this.roleBindings.values().stream().mapToInt(Map::size).sum();
    }

    public long totalRbacAccessRules() {
        return this.rbacAccessRuleStore.ruleCount();
    }

    public long totalAclAccessRules() {
        return this.aclAccessRuleStore.ruleCount();
    }

    public int totalJwtIssuers() {
        return this.jsonWebKeys.size();
    }

    public long totalIdentityPools() {
        return this.identityPools.size();
    }

    public long totalRefreshTokenInfos() {
        return this.refreshTokens.size();
    }

    public int caCertificatesCount() {
        return this.caCertificates.size();
    }

    public int certIdentityPoolsCount() {
        return this.certIdentityPools.size();
    }

    protected RoleBindingValue updateRoleBinding(RoleBindingKey key, RoleBindingValue value) {
        if (!this.rootScope.containsScope(key.scope())) {
            return null;
        }
        Map<String, Collection<AccessPolicy>> accessPolicies = this.accessPolicies(key);
        if (accessPolicies.isEmpty()) {
            return null;
        }
        KafkaPrincipal principal = key.principal();
        String role = key.role();
        RoleBindingValue oldValue = this.roleBindings.computeIfAbsent(key.principal(), p -> new ConcurrentHashMap()).put(key, value);
        for (String bindingScope : accessPolicies.keySet()) {
            Scope policyScope = key.scope().ancestorWithBindingScope(bindingScope);
            if (policyScope == null) {
                throw new InvalidRoleBindingException("Binding at scope " + bindingScope + " is missing enclosing scope " + bindingScope);
            }
            RoleBindingKey policyKey = new RoleBindingKey(principal, role, policyScope);
            Map<io.confluent.security.authorizer.ResourcePattern, Set<AccessRule>> accessRules = this.accessRules(policyKey, value);
            this.rbacAccessRuleStore.add(policyScope, principal, accessRules);
            this.removeDeletedAccessPolicies(principal, policyScope);
        }
        return oldValue;
    }

    protected RoleBindingValue removeRoleBinding(RoleBindingKey key) {
        Scope scope = key.scope();
        if (!this.rootScope.containsScope(scope)) {
            return null;
        }
        Map<RoleBindingKey, RoleBindingValue> principalRoleBindings = this.roleBindings.get(key.principal());
        if (principalRoleBindings == null) {
            return null;
        }
        RoleBindingValue existing = principalRoleBindings.remove(key);
        if (existing != null) {
            if (principalRoleBindings.isEmpty()) {
                this.roleBindings.remove(key.principal());
            }
            Role role = this.rbacRoles.role(key.role());
            for (String bindingScope : role.bindingScopes()) {
                this.removeDeletedAccessPolicies(key.principal(), scope.ancestorWithBindingScope(bindingScope));
            }
            return existing;
        }
        return null;
    }

    protected IdentityProviderValue updateIdentityProvider(IdentityProviderKey key, IdentityProviderValue value) {
        return TrustCacheUtils.updateIdentityProvider(this.identityProviders, this.orgToProvidersMapping, (IdentityProviderKey)key, (IdentityProviderValue)value);
    }

    protected IdentityProviderValue removeIdentityProvider(IdentityProviderKey key) {
        return TrustCacheUtils.removeIdentityProvider(this.identityProviders, this.orgToProvidersMapping, (IdentityProviderKey)key);
    }

    protected IdentityProviderValue getIdentityProvider(IdentityProviderKey key) {
        return TrustCacheUtils.getIdentityProvider(this.identityProviders, (IdentityProviderKey)key);
    }

    protected IdentityPoolValue updateIdentityPool(IdentityPoolKey key, IdentityPoolValue value) {
        return TrustCacheUtils.updateIdentityPool(this.identityPools, this.providerToPoolsMapping, (IdentityPoolKey)key, (IdentityPoolValue)value);
    }

    protected IdentityPoolValue removeIdentityPool(IdentityPoolKey key) {
        return TrustCacheUtils.removeIdentityPool(this.identityPools, this.providerToPoolsMapping, (IdentityPoolKey)key);
    }

    protected IdentityPoolValue getIdentityPool(IdentityPoolKey identityPoolKey) {
        return TrustCacheUtils.getIdentityPool(this.identityPools, (IdentityPoolKey)identityPoolKey);
    }

    protected JwtIssuerValue updateJwtIssuer(JwtIssuerKey key, JwtIssuerValue value) {
        return TrustCacheUtils.updateJwtIssuer(this.jsonWebKeys, (JwtIssuerKey)key, (JwtIssuerValue)value);
    }

    protected JwtIssuerValue removeJwtIssuer(JwtIssuerKey key) {
        return TrustCacheUtils.removeJwtIssuer(this.jsonWebKeys, (JwtIssuerKey)key);
    }

    protected JwtIssuerValue getJwtIssuer(JwtIssuerKey key) {
        return TrustCacheUtils.getJwtIssuer(this.jsonWebKeys, (JwtIssuerKey)key);
    }

    private RefreshTokenInfoValue updateRefreshTokenInfo(RefreshTokenInfoKey key, RefreshTokenInfoValue value) {
        RefreshTokenInfo oldValue = this.refreshTokens.put(key.cacheKey(), new RefreshTokenInfo(value.issuer(), value.encryptedRefreshToken(), value.issuedAt(), value.subClaim(), value.sessionId()));
        return oldValue == null ? null : new RefreshTokenInfoValue(oldValue);
    }

    private UserValue updateUser(UserKey key, UserValue value) {
        UserMetadata oldValue = this.users.put(key.principal(), new UserMetadata(value.groups()));
        return oldValue == null ? null : new UserValue((Collection)oldValue.groups());
    }

    protected void ensureNotFailed() {
        Map<Integer, String> exceptions = this.partitionStatus.entrySet().stream().filter(e -> ((StatusValue)e.getValue()).status() == MetadataStoreStatus.FAILED).collect(Collectors.toMap(Map.Entry::getKey, e -> ((StatusValue)e.getValue()).errorMessage()));
        if (!exceptions.isEmpty()) {
            throw new MetadataStoreException("Some partitions have failed: " + String.valueOf(exceptions));
        }
    }

    protected Map<String, Collection<AccessPolicy>> accessPolicies(RoleBindingKey roleBindingKey) {
        Role role = this.rbacRoles.role(roleBindingKey.role());
        if (role == null) {
            log.error("Unknown role, ignoring role binding {}", (Object)roleBindingKey);
            return Collections.emptyMap();
        }
        return role.accessPolicies();
    }

    NavigableMap<io.confluent.security.authorizer.ResourcePattern, Set<AccessRule>> rbacRules(Scope scope) {
        return this.rbacAccessRuleStore.get(scope);
    }

    public void setMTlsTruststoreManager(MTlsTruststoreManager mTlsTruststoreManager) {
        Objects.requireNonNull(mTlsTruststoreManager, "mTls truststore manager must not be null");
        if (this.mTlsTruststoreManager != null) {
            throw new IllegalStateException("mTls truststore manager already set");
        }
        this.mTlsTruststoreManager = mTlsTruststoreManager;
    }

    public void setMTlsConnectionManager(MTlsConnectionManager mTlsConnectionManager) {
        Objects.requireNonNull(mTlsConnectionManager, "mTls connection manager must not be null");
        if (this.mTlsConnectionManager != null) {
            throw new IllegalStateException("mTls connection manager already set");
        }
        this.mTlsConnectionManager = mTlsConnectionManager;
    }

    private String bindingScope(RoleBindingKey roleBindingKey) {
        return roleBindingKey.scope().bindingScope();
    }

    private Map<io.confluent.security.authorizer.ResourcePattern, Set<AccessRule>> accessRules(RoleBindingKey roleBindingKey, RoleBindingValue roleBindingValue) {
        HashMap<io.confluent.security.authorizer.ResourcePattern, Set<AccessRule>> accessRules = new HashMap<io.confluent.security.authorizer.ResourcePattern, Set<AccessRule>>();
        RoleBinding roleBinding = this.roleBinding(roleBindingKey, roleBindingValue);
        KafkaPrincipal principal = roleBindingKey.principal();
        String bindingScope = this.bindingScope(roleBindingKey);
        Collection<AccessPolicy> accessPolicies = this.accessPolicies(roleBindingKey).get(bindingScope);
        if (accessPolicies == null) {
            return accessRules;
        }
        for (AccessPolicy accessPolicy : accessPolicies) {
            if (accessPolicy == null) continue;
            Collection<Object> resources = !accessPolicy.bindWithResource() ? this.wildcardResourcePatterns(accessPolicy) : (roleBindingValue.resources().isEmpty() ? Collections.emptySet() : roleBindingValue.resources());
            for (io.confluent.security.authorizer.ResourcePattern resource : resources) {
                HashSet<RbacAccessRule> resourceRules = new HashSet<RbacAccessRule>();
                for (Operation op : accessPolicy.allowedOperations(resource.resourceType())) {
                    RbacAccessRule rule = new RbacAccessRule(resource, principal, PermissionType.ALLOW, WILDCARD_HOST, op, AuthorizePolicy.PolicyType.ALLOW_ROLE, roleBinding);
                    resourceRules.add(rule);
                }
                accessRules.put(resource, resourceRules);
            }
        }
        return accessRules;
    }

    private List<io.confluent.security.authorizer.ResourcePattern> wildcardResourcePatterns(AccessPolicy accessPolicy) {
        if (accessPolicy.bindWithResource()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(accessPolicy.allowedOperations().stream().map((? super T resourceOperation) -> new io.confluent.security.authorizer.ResourcePattern(resourceOperation.resourceType(), WILDCARD_HOST, PatternType.LITERAL)).collect(Collectors.toList()));
    }

    private void removeDeletedAccessPolicies(KafkaPrincipal principal, Scope scope) {
        HashMap<io.confluent.security.authorizer.ResourcePattern, Set<AccessRule>> keepRules = new HashMap<io.confluent.security.authorizer.ResourcePattern, Set<AccessRule>>();
        this.roleBindings.getOrDefault(principal, NO_ROLE_BINDINGS).entrySet().stream().filter(e -> scope.containsScope(((RoleBindingKey)e.getKey()).scope())).flatMap(e -> {
            RoleBindingKey key = new RoleBindingKey(((RoleBindingKey)e.getKey()).principal(), ((RoleBindingKey)e.getKey()).role(), scope);
            return this.accessRules(key, (RoleBindingValue)e.getValue()).entrySet().stream();
        }).forEach(e -> keepRules.computeIfAbsent((io.confluent.security.authorizer.ResourcePattern)e.getKey(), r -> ConcurrentHashMap.newKeySet()).addAll((Collection)e.getValue()));
        this.rbacAccessRuleStore.removeDeletedAccessRules(scope, principal, keepRules);
    }

    private RoleBinding roleBinding(RoleBindingKey key, RoleBindingValue value) {
        return new RoleBinding(key.principal(), key.role(), key.scope(), value.resources());
    }

    private AclBindingValue aclBindingValue(Set<AccessRule> rules) {
        return new AclBindingValue((Collection)rules.stream().map(AclRule::from).collect(Collectors.toSet()));
    }

    private AccessRule accessRule(io.confluent.security.authorizer.ResourcePattern resource, AclRule rule) {
        ResourcePattern kafkaResource = io.confluent.security.authorizer.ResourcePattern.to((io.confluent.security.authorizer.ResourcePattern)resource);
        AclBinding aclBinding = new AclBinding(kafkaResource, rule.toAccessControlEntry());
        AuthorizePolicy.PolicyType policyType = rule.permissionType() == PermissionType.ALLOW ? AuthorizePolicy.PolicyType.ALLOW_ACL : AuthorizePolicy.PolicyType.DENY_ACL;
        return new AclAccessRule(resource, rule.principal(), rule.permissionType(), rule.host(), rule.operation(), policyType, aclBinding);
    }

    private AclBindingValue updateAclBinding(AclBindingKey key, AclBindingValue value) {
        Scope scope = key.scope();
        if (!this.rootScope.containsScope(scope)) {
            return null;
        }
        AclBindingValue oldValue = (AclBindingValue)this.get((AuthKey)key);
        Set<AccessRule> newRules = value.aclRules().stream().map((? super T aclRule) -> this.accessRule(key.resourcePattern(), (AclRule)aclRule)).collect(Collectors.toSet());
        this.aclAccessRuleStore.update(scope, key.resourcePattern(), newRules);
        return oldValue;
    }

    private AclBindingValue removeAclBinding(AclBindingKey key) {
        Scope scope = key.scope();
        if (!this.rootScope.containsScope(scope)) {
            return null;
        }
        Set<AccessRule> accessRules = this.aclAccessRuleStore.remove(scope, key.resourcePattern());
        if (accessRules != null) {
            return this.aclBindingValue(accessRules);
        }
        return null;
    }

    private CertIdentityPoolValue updateCertIdentityPool(CertIdentityPoolKey key, CertIdentityPoolValue value) {
        CertIdentityPool oldValue = this.certIdentityPools.put(key.poolId(), new CertIdentityPool(key.poolId(), value.providerId(), value.organizationId(), value.externalId(), value.filter()));
        return oldValue == null ? null : new CertIdentityPoolValue(oldValue.poolId(), oldValue.providerId(), oldValue.organizationId(), oldValue.externalIdentifier(), oldValue.filter());
    }

    private CertIdentityPoolValue removeCertIdentityPool(CertIdentityPoolKey key) {
        CertIdentityPool oldValue = this.certIdentityPools.remove(key.poolId());
        return oldValue == null ? null : new CertIdentityPoolValue(oldValue.poolId(), oldValue.providerId(), oldValue.organizationId(), oldValue.externalIdentifier(), oldValue.filter());
    }

    private CertIdentityPoolValue getCertIdentityPool(CertIdentityPoolKey key) {
        CertIdentityPool curValue = this.certIdentityPools.get(key.poolId());
        return curValue == null ? null : new CertIdentityPoolValue(curValue.poolId(), curValue.providerId(), curValue.organizationId(), curValue.externalIdentifier(), curValue.filter());
    }

    private CaCertificatesValue updateCaCertificates(CaCertificatesKey key, CaCertificatesValue value) {
        if (this.mTlsTruststoreManager == null) {
            return null;
        }
        String orgId = key.organizationId();
        String providerId = key.providerId();
        try {
            Certificate[] certificates = CaCertificatesUtils.x509CertificatesFromPem(value.certificates());
            this.mTlsTruststoreManager.addCertificates(orgId, providerId, (X509Certificate[])certificates);
            for (X509Certificate x509Certificate : certificates) {
                this.caCertToProvidersMapping.computeIfAbsent(x509Certificate, k -> new ConcurrentHashMap()).computeIfAbsent(orgId, k -> ConcurrentHashMap.newKeySet()).add(providerId);
            }
            log.info("Updated CA certificates: {} for orgId: {}, providerId: {}, current mapping: {}", new Object[]{CertificateUtils.certChainToString((Certificate[])certificates), key.organizationId(), key.providerId(), this.getCaCertToProvidersMappingStr()});
            this.orgToCaCertMapping.computeIfAbsent(orgId, k -> new ConcurrentHashMap()).put(providerId, Collections.unmodifiableSet(Arrays.stream(certificates).collect(Collectors.toSet())));
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Encounter exception while updating CA certs for orgId: %s, providerId: %s", orgId, providerId), e);
        }
        String identifier = AbstractAuthCache.getIdentifier(key);
        CaCertificatesValue oldValue = this.caCertificates.get(identifier);
        this.caCertificates.put(identifier, value);
        return oldValue;
    }

    private CaCertificatesValue removeCaCertificates(CaCertificatesKey key) {
        if (this.mTlsTruststoreManager == null) {
            return null;
        }
        try {
            this.mTlsTruststoreManager.removeCertificates(key.organizationId(), key.providerId());
            for (Map.Entry<Certificate, Map<String, Set<String>>> entry2 : this.caCertToProvidersMapping.entrySet()) {
                ((Set)entry2.getValue().getOrDefault(key.organizationId(), new HashSet())).remove(key.providerId());
                if (!entry2.getValue().getOrDefault(key.organizationId(), Collections.emptySet()).isEmpty()) continue;
                entry2.getValue().remove(key.organizationId());
            }
            this.caCertToProvidersMapping.entrySet().removeIf(entry -> ((Map)entry.getValue()).isEmpty());
            ((Map)this.orgToCaCertMapping.getOrDefault(key.organizationId(), new ConcurrentHashMap())).remove(key.providerId());
            if (this.orgToCaCertMapping.getOrDefault(key.organizationId(), Collections.emptyMap()).isEmpty()) {
                this.orgToCaCertMapping.remove(key.organizationId());
            }
            log.info("Removed CA certificates for orgId: {}, providerId: {}, current mapping: {}", new Object[]{key.organizationId(), key.providerId(), this.getCaCertToProvidersMappingStr()});
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Encounter exception while removing CA certs for orgId: %s, providerId: %s", key.organizationId(), key.providerId()), e);
        }
        String identifier = AbstractAuthCache.getIdentifier(key);
        return this.caCertificates.remove(identifier);
    }

    private CaCertificatesValue getCaCertificates(CaCertificatesKey key) {
        if (this.mTlsTruststoreManager == null) {
            return null;
        }
        String identifier = AbstractAuthCache.getIdentifier(key);
        return this.caCertificates.get(identifier);
    }

    private static String getIdentifier(CaCertificatesKey key) {
        return AbstractAuthCache.getIdentifier(key.organizationId(), key.providerId());
    }

    private static String getIdentifier(String orgId, String providerId) {
        return orgId + DefaultMTlsTruststoreManager.ALIAS_SEPARATOR + providerId;
    }

    private CaCertCrlValue getCaCertCrl(CaCertCrlKey key) {
        if (this.mTlsTruststoreManager == null) {
            return null;
        }
        X509CRL crl = (X509CRL)this.caCrls.getOrDefault(key.organizationId(), Collections.emptyMap()).get(key.providerId());
        return this.toCaCertCrlValue(crl);
    }

    private CaCertCrlValue updateCaCertCrl(CaCertCrlKey key, CaCertCrlValue value) {
        if (this.mTlsTruststoreManager == null) {
            return null;
        }
        CaCertificatesValue caCertsValue = this.caCertificates.get(AbstractAuthCache.getIdentifier(key.organizationId(), key.providerId()));
        if (caCertsValue == null) {
            throw new IllegalStateException(String.format("No CA certificates found, could not update CA CRL for orgId: %s, providerId: %s", key.organizationId(), key.providerId()));
        }
        X509CRL currValue = (X509CRL)this.caCrls.getOrDefault(key.organizationId(), Collections.emptyMap()).get(key.providerId());
        try {
            X509CRL crl = CaCertificatesUtils.x509CrlFromPem(value.crl());
            this.verifyCrlSigning(crl, caCertsValue, key.organizationId(), key.providerId());
            this.caCrls.computeIfAbsent(key.organizationId(), k -> new ConcurrentHashMap()).put(key.providerId(), crl);
            if (this.mTlsConnectionManager != null) {
                String issuerDn = CertificateMetadata.getIssuerDn((X509CRL)crl);
                Set<? extends X509CRLEntry> revokedCerts = crl.getRevokedCertificates();
                if (revokedCerts != null) {
                    for (X509CRLEntry x509CRLEntry : revokedCerts) {
                        String serialNumber = CertificateMetadata.getSerialNumber((X509CRLEntry)x509CRLEntry);
                        log.info("Closing connections using the revoked certificate: issuerDN: {}, serialNumber: {}", (Object)issuerDn, (Object)serialNumber);
                        this.mTlsConnectionManager.closeConnections(PublicCredential.mTlsCredential((String)key.organizationId(), (String)key.providerId(), (String)issuerDn, (String)serialNumber));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Encounter exception while updating CA CRL for orgId: %s, providerId: %s", key.organizationId(), key.providerId()), e);
        }
        return this.toCaCertCrlValue(currValue);
    }

    private CaCertCrlValue removeCaCertCrl(CaCertCrlKey key) {
        if (this.mTlsTruststoreManager == null) {
            return null;
        }
        X509CRL crl = (X509CRL)this.caCrls.getOrDefault(key.organizationId(), Collections.emptyMap()).remove(key.providerId());
        return this.toCaCertCrlValue(crl);
    }

    private X509CRL getCrl(String organizationId, String providerId) {
        Map<String, X509CRL> crls = this.caCrls.get(organizationId);
        if (crls == null || crls.isEmpty()) {
            return null;
        }
        return crls.get(providerId);
    }

    private CaCertCrlValue toCaCertCrlValue(X509CRL crl) {
        if (crl == null) {
            return null;
        }
        try {
            return new CaCertCrlValue(CaCertificatesUtils.x509CrlToPem(crl));
        }
        catch (CRLException e) {
            return null;
        }
    }

    private void verifyCrlSigning(X509CRL crl, CaCertificatesValue caCertsValue, String orgId, String providerId) throws CertificateException, IOException {
        X509Certificate[] certificates = CaCertificatesUtils.x509CertificatesFromPem(caCertsValue.certificates());
        boolean crlVerified = false;
        for (X509Certificate certificate : certificates) {
            try {
                crl.verify(certificate.getPublicKey());
                crlVerified = true;
                break;
            }
            catch (Throwable throwable) {
            }
        }
        if (!crlVerified) {
            throw new IllegalArgumentException("CRL is not verified by any of the CA certificates for providerId: " + providerId + ", orgId: " + orgId);
        }
    }

    private Set<Certificate> getCaCertsForOrg(String organizationId) {
        HashSet<Certificate> caCerts = new HashSet<Certificate>();
        for (Map.Entry<Certificate, Map<String, Set<String>>> entry : this.caCertToProvidersMapping.entrySet()) {
            if (!entry.getValue().containsKey(organizationId)) continue;
            caCerts.add(entry.getKey());
        }
        return caCerts;
    }

    private String getCaCertToProvidersMappingStr() {
        return this.caCertToProvidersMapping.entrySet().stream().map((? super T entry) -> CertificateUtils.certToString((Certificate)((Certificate)entry.getKey())) + "->" + String.valueOf(entry.getValue())).collect(Collectors.joining(", ", "{", "}"));
    }

    @VisibleForTesting
    Map<Certificate, Map<String, Set<String>>> getCaCertToProvidersMapping() {
        return Collections.unmodifiableMap(this.caCertToProvidersMapping);
    }

    @VisibleForTesting
    Map<String, Map<String, Set<Certificate>>> getOrgToCaCertMapping() {
        return Collections.unmodifiableMap(this.orgToCaCertMapping);
    }
}

