/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.store.cache;

import io.confluent.security.auth.store.cache.AccessRuleStore;
import io.confluent.security.authorizer.AccessRule;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.ResourcePattern;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.authorizer.provider.AuthorizeRule;
import io.confluent.security.authorizer.provider.ResourceAuthorizeRules;
import io.confluent.security.roledefinitions.Operation;
import io.confluent.security.roledefinitions.PermissionType;
import io.confluent.security.roledefinitions.ResourceType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.stream.Collectors;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public class ScopePrincipalAccessRuleStore
implements AccessRuleStore {
    private static final NavigableMap<ResourcePattern, Set<AccessRule>> NO_RULES = Collections.emptyNavigableMap();
    private final Map<Scope, Map<KafkaPrincipal, NavigableMap<ResourcePattern, Set<AccessRule>>>> accessRules;

    public ScopePrincipalAccessRuleStore() {
        this(new ConcurrentHashMap<Scope, Map<KafkaPrincipal, NavigableMap<ResourcePattern, Set<AccessRule>>>>());
    }

    public ScopePrincipalAccessRuleStore(Map<Scope, Map<KafkaPrincipal, NavigableMap<ResourcePattern, Set<AccessRule>>>> accessRules) {
        this.accessRules = accessRules;
    }

    @Override
    public Set<Scope> knownScopes() {
        return this.accessRules.keySet();
    }

    @Override
    public NavigableMap<ResourcePattern, Set<AccessRule>> get(Scope scope) {
        Map<KafkaPrincipal, NavigableMap<ResourcePattern, Set<AccessRule>>> scopeRules = this.accessRules.get(scope);
        if (scopeRules == null) {
            return NO_RULES;
        }
        ConcurrentSkipListMap<ResourcePattern, Set<AccessRule>> allRules = new ConcurrentSkipListMap<ResourcePattern, Set<AccessRule>>();
        scopeRules.entrySet().stream().flatMap(principalMap -> ((NavigableMap)principalMap.getValue()).entrySet().stream()).forEach(entry -> allRules.computeIfAbsent((ResourcePattern)entry.getKey(), x -> ConcurrentHashMap.newKeySet()).addAll((Collection)entry.getValue()));
        return allRules;
    }

    private NavigableMap<ResourcePattern, Set<AccessRule>> getPrincipalRules(Scope scope, KafkaPrincipal principal) {
        Map<KafkaPrincipal, NavigableMap<ResourcePattern, Set<AccessRule>>> scopeRules = this.accessRules.get(scope);
        if (scopeRules == null) {
            return NO_RULES;
        }
        return scopeRules.getOrDefault(principal, NO_RULES);
    }

    @Override
    public void add(Scope scope, KafkaPrincipal principal, Map<ResourcePattern, Set<AccessRule>> rules) {
        Map scopeRules = this.accessRules.computeIfAbsent(scope, scope1 -> new ConcurrentHashMap());
        NavigableMap principalRules = scopeRules.computeIfAbsent(principal, p -> new ConcurrentSkipListMap());
        rules.forEach((r, a) -> principalRules.computeIfAbsent(r, x -> ConcurrentHashMap.newKeySet()).addAll(a));
    }

    @Override
    public void update(Scope scope, ResourcePattern resourcePattern, Set<AccessRule> newRules) {
        Map principalRules = this.accessRules.computeIfAbsent(scope, s -> new ConcurrentHashMap());
        principalRules.values().stream().map(map -> (Set)map.get(resourcePattern)).forEach(Set::clear);
        Map<KafkaPrincipal, List<AccessRule>> newPrincipalRules = newRules.stream().collect(Collectors.groupingBy(AccessRule::principal));
        newPrincipalRules.forEach((principal, rules) -> {
            Set newAccessRules = principalRules.computeIfAbsent(principal, p -> new ConcurrentSkipListMap()).computeIfAbsent(resourcePattern, r -> ConcurrentHashMap.newKeySet());
            newAccessRules.clear();
            newAccessRules.addAll(rules);
        });
    }

    @Override
    public Set<AccessRule> remove(Scope scope, ResourcePattern resourcePattern) {
        Map<KafkaPrincipal, NavigableMap<ResourcePattern, Set<AccessRule>>> scopeRules = this.accessRules.get(scope);
        HashSet allRules = null;
        if (scopeRules != null) {
            allRules = new HashSet();
            for (Map.Entry<KafkaPrincipal, NavigableMap<ResourcePattern, Set<AccessRule>>> entry : scopeRules.entrySet()) {
                Set accessRules = (Set)entry.getValue().get(resourcePattern);
                if (accessRules == null) continue;
                allRules.addAll(accessRules);
                entry.getValue().remove(resourcePattern);
            }
            if (allRules.isEmpty()) {
                return null;
            }
        }
        return allRules;
    }

    @Override
    public AuthorizeRule findMatchingRule(Set<KafkaPrincipal> matchingPrincipals, String host, Action action) {
        Scope resourceScope = action.scope();
        ResourcePattern resource = action.resourcePattern();
        AuthorizeRule authorizeRule = new AuthorizeRule();
        authorizeRule.noResourceAcls(false);
        for (Scope nextScope = resourceScope; nextScope != null; nextScope = nextScope.parent()) {
            for (KafkaPrincipal kafkaPrincipal : matchingPrincipals) {
                NavigableMap<ResourcePattern, Set<AccessRule>> rules = this.getPrincipalRules(nextScope, kafkaPrincipal);
                if (rules.isEmpty()) continue;
                String resourceName = resource.name();
                ResourceType resourceType = resource.resourceType();
                if (this.updateAuthorizeRule((Collection)rules.get(resource), host, action, authorizeRule)) {
                    return authorizeRule;
                }
                if (this.updateAuthorizeRule((Collection)rules.get(ResourcePattern.all((ResourceType)resourceType)), host, action, authorizeRule)) {
                    return authorizeRule;
                }
                if (this.updateAuthorizeRule((Collection)rules.get(ResourcePattern.ALL), host, action, authorizeRule)) {
                    return authorizeRule;
                }
                if (this.updateAuthorizeRule((Collection)rules.get(new ResourcePattern(ResourceType.ALL, resourceName, PatternType.LITERAL)), host, action, authorizeRule)) {
                    return authorizeRule;
                }
                if (resourceName.isEmpty() || !rules.subMap(new ResourcePattern(resourceType.name(), resourceName, PatternType.PREFIXED), true, new ResourcePattern(resourceType.name(), resourceName.substring(0, 1), PatternType.PREFIXED), true).entrySet().stream().filter(e -> resourceName.startsWith(((ResourcePattern)e.getKey()).name())).anyMatch(e -> this.updateAuthorizeRule((Collection)e.getValue(), host, action, authorizeRule))) continue;
                return authorizeRule;
            }
        }
        return authorizeRule;
    }

    @Override
    public void addMatchingRules(ResourceAuthorizeRules matchingRules, Scope resourceScope, Set<KafkaPrincipal> principals, String host, Operation operation, ResourceType resourceType) {
        for (Scope nextScope = resourceScope; nextScope != null; nextScope = nextScope.parent()) {
            for (KafkaPrincipal kafkaPrincipal : principals) {
                NavigableMap<ResourcePattern, Set<AccessRule>> rules = this.getPrincipalRules(nextScope, kafkaPrincipal);
                if (rules.isEmpty()) continue;
                for (Map.Entry entry : rules.entrySet()) {
                    ResourcePattern resourcePattern = (ResourcePattern)entry.getKey();
                    if (!resourceType.equals((Object)resourcePattern.resourceType())) continue;
                    for (AccessRule rule : (Set)entry.getValue()) {
                        if (!rule.matches(host, operation, PermissionType.DENY) && !rule.matches(host, operation, PermissionType.ALLOW)) continue;
                        matchingRules.addRuleIfNotExist(rule);
                    }
                }
            }
        }
    }

    @Override
    public long ruleCount() {
        int count = 0;
        for (Map<KafkaPrincipal, NavigableMap<ResourcePattern, Set<AccessRule>>> entryFromPrincipalMap : this.accessRules.values()) {
            for (NavigableMap<ResourcePattern, Set<AccessRule>> entryFromResourceMap : entryFromPrincipalMap.values()) {
                for (Set accessRules : entryFromResourceMap.values()) {
                    count += accessRules.size();
                }
            }
        }
        return count;
    }

    @Override
    public void removeDeletedAccessRules(Scope scope, KafkaPrincipal principal, Map<ResourcePattern, Set<AccessRule>> keepRules) {
        NavigableMap<ResourcePattern, Set<AccessRule>> scopeRules = this.getPrincipalRules(scope, principal);
        if (!scopeRules.isEmpty()) {
            HashMap<ResourcePattern, Set> deletedRules = new HashMap<ResourcePattern, Set>();
            scopeRules.forEach((resource, rules) -> {
                HashSet principalRules = new HashSet(rules);
                deletedRules.put((ResourcePattern)resource, principalRules);
            });
            keepRules.forEach((r, ruleSet) -> {
                Set rules = (Set)deletedRules.get(r);
                if (rules != null) {
                    rules.removeAll((Collection<?>)ruleSet);
                }
            });
            deletedRules.forEach((resource, rules) -> {
                Set resourceRules = (Set)scopeRules.get(resource);
                if (resourceRules != null) {
                    resourceRules.removeAll((Collection<?>)rules);
                    if (resourceRules.isEmpty()) {
                        scopeRules.remove(resource);
                    }
                }
            });
        }
    }

    private boolean updateAuthorizeRule(Collection<AccessRule> inputRules, String host, Action action, AuthorizeRule authorizeRule) {
        if (inputRules != null) {
            for (AccessRule rule : inputRules) {
                if (!rule.matches(host, action.operation(), PermissionType.ALLOW)) continue;
                authorizeRule.addRuleIfNotExist(rule);
                return true;
            }
        }
        return false;
    }
}

