/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.store.kafka;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import io.confluent.security.auth.cloud.CloudAuthCache;
import io.confluent.security.auth.dataplane.DataplaneAuthWriter;
import io.confluent.security.auth.metadata.AuthCache;
import io.confluent.security.auth.metadata.AuthStore;
import io.confluent.security.auth.metadata.AuthWriter;
import io.confluent.security.auth.mtls.DefaultMTlsTruststoreManager;
import io.confluent.security.auth.store.cache.AbstractAuthCache;
import io.confluent.security.auth.store.data.AuthKey;
import io.confluent.security.auth.store.kafka.KafkaAuthStore;
import io.confluent.security.auth.utils.AuthStoreMetrics;
import io.confluent.security.auth.utils.MetricsUtils;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.authorizer.utils.JsonMapper;
import io.confluent.security.roledefinitions.RbacRoles;
import io.confluent.security.store.kafka.KafkaStoreConfig;
import io.confluent.security.trustservice.store.TrustCache;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.IntStream;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.mtls.MTlsConnectionManager;
import org.apache.kafka.common.security.mtls.MTlsTruststoreManager;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.authorizer.internals.ConfluentAuthorizerServerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalKafkaAuthStore
implements AuthStore {
    protected static final Logger log = LoggerFactory.getLogger(ExternalKafkaAuthStore.class);
    AbstractAuthCache authCache;
    ConfluentAuthorizerServerInfo serverInfo;
    protected String sessionUuid;
    protected KafkaStoreConfig clientConfig;
    Scope scope;
    RbacRoles rbacRoles;
    public static final String METRIC_GROUP = "confluent.metadata";
    private static final String METRIC_TYPE = KafkaAuthStore.class.getSimpleName();
    private final Set<MetricName> metricNames;
    private final AuthStoreMetrics authStoreMetrics;
    protected MTlsTruststoreManager mTlsTruststoreManager;
    private Meter recordFailureMeter;

    public ExternalKafkaAuthStore(Scope scope, ConfluentAuthorizerServerInfo serverInfo) {
        this(scope, serverInfo, RbacRoles.loadDataPlanePolicy());
    }

    public ExternalKafkaAuthStore(Scope scope, ConfluentAuthorizerServerInfo serverInfo, RbacRoles rbacRoles) {
        this.authCache = new CloudAuthCache(rbacRoles, scope);
        this.scope = scope;
        this.serverInfo = serverInfo;
        this.rbacRoles = rbacRoles;
        this.authStoreMetrics = new AuthStoreMetrics(serverInfo.metrics(), this.authCache);
        this.metricNames = new HashSet<MetricName>();
        IntStream.range(0, 6).forEach(p -> {
            Map tags = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"topic", (Object)"_confluent-metadata-auth"), Utils.mkEntry((Object)"partition", (Object)String.valueOf(p))});
            this.metricNames.add(MetricsUtils.newGauge(METRIC_GROUP, METRIC_TYPE, "metadata-status", tags, () -> this.authCache.status(p).name()));
        });
        MetricName errorMetricName = MetricsUtils.metricName(METRIC_GROUP, METRIC_TYPE, "record-error-rate", Collections.emptyMap());
        this.recordFailureMeter = MetricsUtils.newMeter(errorMetricName, "records");
        this.metricNames.add(errorMetricName);
    }

    public CompletionStage<Void> startReader() {
        return CompletableFuture.completedFuture(null);
    }

    public CompletionStage<Void> startService(Collection<URL> serverUrls) {
        return null;
    }

    public AuthCache authCache() {
        return this.authCache;
    }

    public TrustCache trustCache() {
        return this.authCache;
    }

    public AuthWriter writer() {
        return new DataplaneAuthWriter();
    }

    public boolean isMasterWriter() {
        return false;
    }

    public URL masterWriterUrl(String protocol) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public Integer masterWriterId() {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public Collection<URL> activeNodeUrls(String protocol) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public void close() throws IOException {
        log.debug("Closing RbacAuthStore");
        if (this.mTlsTruststoreManager != null) {
            try {
                this.mTlsTruststoreManager.close();
            }
            catch (Exception e) {
                log.error("Unable to close MTlsTruststoreManager", (Throwable)e);
            }
        }
        MetricsUtils.removeMetrics(this.metricNames);
    }

    protected Metrics metrics() {
        return this.authStoreMetrics.metrics();
    }

    public void configure(Map<String, ?> configs) {
        this.clientConfig = new KafkaStoreConfig((AuthorizerServerInfo)this.serverInfo, configs);
        if (ConfluentConfigs.getMTlsEnable(configs)) {
            this.mTlsTruststoreManager = this.createCaCertificateManager(configs);
            log.info("Initializing {} for mTLS on listener {}", (Object)this.mTlsTruststoreManager.getClass(), (Object)ConfluentConfigs.getMTlsListenerName(configs));
            if (this.mTlsTruststoreManager instanceof DefaultMTlsTruststoreManager) {
                ((DefaultMTlsTruststoreManager)this.mTlsTruststoreManager).setAdminSupplierAndCreateClient(() -> {
                    Map<String, Object> adminClientConfigs = this.clientConfig.adminClientConfigs();
                    String clientId = String.format("DefaultMTlsTruststoreManager-admin-client-%s", this.serverInfo.brokerId());
                    adminClientConfigs.put("client.id", clientId);
                    return AdminClient.create(this.clientConfig.adminClientConfigs());
                });
            }
            this.mTlsTruststoreManager.configure(configs);
            this.authCache.setMTlsTruststoreManager(this.mTlsTruststoreManager);
            MTlsConnectionManager mTlsConnectionManager = ConfluentConfigs.buildMTlsConnectionManager(configs);
            log.info("Initializing {} for mTLS", (Object)mTlsConnectionManager.getClass());
            this.authCache.setMTlsConnectionManager(mTlsConnectionManager);
        }
        log.debug("Configured {} with configs {}", (Object)this.getClass().getName(), (Object)this.clientConfig);
    }

    protected MTlsTruststoreManager createCaCertificateManager(Map<String, ?> configs) {
        Class clazz = ConfluentConfigs.getMTlsTruststoreManagerClass(configs);
        if (clazz == null) {
            return new DefaultMTlsTruststoreManager();
        }
        return (MTlsTruststoreManager)Utils.newInstance((Class)clazz);
    }

    public void updateStoreAuthCacheExternally(String key, String value) {
        try {
            this.authCache.updateAuthCacheExternally(key, value);
            AuthKey authkey = (AuthKey)JsonMapper.objectMapper().readValue(key, AuthKey.class);
            this.authStoreMetrics.recordsProcessedSensors.get(authkey.entryType()).record();
        }
        catch (JsonProcessingException e) {
            this.recordFailureMeter.mark();
            log.error("error parsing string to auth key and value, exception: " + String.valueOf((Object)e));
        }
    }
}

