/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.store.kafka;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaStoreConfig
extends AbstractConfig {
    public static final String PREFIX = "confluent.metadata.";
    public static final int NUM_PARTITIONS = 6;
    public static final String REPLICATION_FACTOR_PROP = "confluent.metadata.topic.replication.factor";
    private static final short REPLICATION_FACTOR_DEFAULT = 3;
    private static final String REPLICATION_FACTOR_DOC = "Replication factor of the metadata topic. This is used for creation of the topic if it doesn't exist. Replication factor cannot be altered after the topic is created.";
    public static final String TOPIC_CREATE_TIMEOUT_PROP = "confluent.metadata.topic.create.timeout.ms";
    private static final int TOPIC_CREATE_TIMEOUT_DEFAULT_DELTA = 30000;
    private static final int TOPIC_CREATE_TIMEOUT_DEFAULT = 570000;
    private static final String TOPIC_CREATE_TIMEOUT_DOC = "The number of milliseconds to wait for metadata topic to be created during start up.";
    public static final String REFRESH_TIMEOUT_PROP = "confluent.metadata.refresh.timeout.ms";
    private static final int REFRESH_TIMEOUT_DEFAULT = 60000;
    private static final String REFRESH_TIMEOUT_DOC = "The number of milliseconds to wait for cache to be refreshed after a write completes successfully.";
    public static final String RETRY_TIMEOUT_PROP = "confluent.metadata.retry.timeout.ms";
    private static final int RETRY_TIMEOUT_DEFAULT = 86400000;
    private static final String RETRY_TIMEOUT_DOC = "Timeout for metadata store retries after which the authorizer is marked as failed. All requests are denied access if all metadata reader or writer operations fail for this duration.";
    public static final String ALLOW_READER_TO_CREATE_AUTH_TOPIC = "confluent.metadata.allow.reader.to.create.auth.topic";
    public static final String BOOTSTRAP_SERVERS_PROP = "confluent.metadata.bootstrap.servers";
    public static final String TOPIC_PREFIX = "_confluent-metadata";
    private static final ConfigDef CONFIG = new ConfigDef().define("confluent.metadata.topic.replication.factor", ConfigDef.Type.SHORT, (Object)3, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, "Replication factor of the metadata topic. This is used for creation of the topic if it doesn't exist. Replication factor cannot be altered after the topic is created.").define("confluent.metadata.topic.create.timeout.ms", ConfigDef.Type.INT, (Object)570000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, "The number of milliseconds to wait for metadata topic to be created during start up.").define("confluent.metadata.refresh.timeout.ms", ConfigDef.Type.INT, (Object)60000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, "The number of milliseconds to wait for cache to be refreshed after a write completes successfully.").define("confluent.metadata.retry.timeout.ms", ConfigDef.Type.INT, (Object)86400000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, "Timeout for metadata store retries after which the authorizer is marked as failed. All requests are denied access if all metadata reader or writer operations fail for this duration.");
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public final Duration topicCreateTimeout;
    public final Duration refreshTimeout;
    public final Duration retryTimeout;
    public final int brokerId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KafkaStoreConfig(AuthorizerServerInfo serverInfo, Map<?, ?> props) {
        super(CONFIG, props);
        Map originals = this.originals();
        if (originals.containsKey("confluent.authorizer.init.timeout.ms") && !originals.containsKey(TOPIC_CREATE_TIMEOUT_PROP)) {
            Duration tcTimeout = null;
            try {
                long initTimeout = Long.parseLong((String)originals.get("confluent.authorizer.init.timeout.ms"));
                tcTimeout = Duration.ofMillis(Math.max(30000L, initTimeout - 30000L));
            }
            catch (Exception e) {
                this.log.error("Unable to get timeout value from init timeout. Using default.", (Throwable)e);
                tcTimeout = Duration.ofMillis(this.getInt(TOPIC_CREATE_TIMEOUT_PROP).intValue());
            }
            finally {
                this.topicCreateTimeout = tcTimeout;
            }
        } else {
            this.topicCreateTimeout = Duration.ofMillis(this.getInt(TOPIC_CREATE_TIMEOUT_PROP).intValue());
        }
        this.refreshTimeout = Duration.ofMillis(this.getInt(REFRESH_TIMEOUT_PROP).intValue());
        this.retryTimeout = Duration.ofMillis(this.getInt(RETRY_TIMEOUT_PROP).intValue());
        this.brokerId = serverInfo.brokerId();
    }

    public KafkaStoreConfig(int componentId, Map<?, ?> props) {
        super(CONFIG, props);
        this.topicCreateTimeout = Duration.ofMillis(this.getInt(TOPIC_CREATE_TIMEOUT_PROP).intValue());
        this.refreshTimeout = Duration.ofMillis(this.getInt(REFRESH_TIMEOUT_PROP).intValue());
        this.retryTimeout = Duration.ofMillis(this.getInt(RETRY_TIMEOUT_PROP).intValue());
        this.brokerId = componentId;
    }

    public Map<String, Object> consumerConfigs(String topic) {
        Map configs = ConfluentConfigs.clientConfigs((AbstractConfig)this, (String)PREFIX, (ConfluentConfigs.ClientType)ConfluentConfigs.ClientType.CONSUMER, (String)topic, (String)String.valueOf(this.brokerId));
        configs.remove("interceptor.classes");
        configs.put("auto.offset.reset", "earliest");
        configs.put("enable.auto.commit", "false");
        configs.put("allow.auto.create.topics", "false");
        return configs;
    }

    public Map<String, Object> producerConfigs(String topic) {
        Map configs = ConfluentConfigs.clientConfigs((AbstractConfig)this, (String)PREFIX, (ConfluentConfigs.ClientType)ConfluentConfigs.ClientType.PRODUCER, (String)topic, (String)String.valueOf(this.brokerId));
        configs.remove("interceptor.classes");
        configs.put("acks", "all");
        configs.put("retries", "0");
        configs.put("enable.idempotence", "false");
        configs.put("max.in.flight.requests.per.connection", "1");
        return configs;
    }

    public Map<String, Object> coordinatorConfigs() {
        Map configs = ConfluentConfigs.clientConfigs((AbstractConfig)this, (String)PREFIX, (ConfluentConfigs.ClientType)ConfluentConfigs.ClientType.COORDINATOR, (String)TOPIC_PREFIX, (String)String.valueOf(this.brokerId));
        configs.remove("interceptor.classes");
        configs.put("group.id", "_confluent-metadata-coordinator-group");
        configs.put("auto.offset.reset", "latest");
        configs.put("enable.auto.commit", "false");
        configs.put("allow.auto.create.topics", "false");
        configs.put("key.deserializer", ByteArrayDeserializer.class);
        configs.put("value.deserializer", ByteArrayDeserializer.class);
        return configs;
    }

    public Map<String, Object> adminClientConfigs() {
        return ConfluentConfigs.clientConfigs((AbstractConfig)this, (String)PREFIX, (ConfluentConfigs.ClientType)ConfluentConfigs.ClientType.ADMIN, (String)TOPIC_PREFIX, (String)String.valueOf(this.brokerId));
    }

    public NewTopic metadataTopicCreateConfig(String topic, int numPartitions) {
        short replicationFactor = this.getShort(REPLICATION_FACTOR_PROP);
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("compression.type", "producer");
        configs.put("segment.bytes", String.valueOf(0xA00000));
        String configPrefix = "confluent.metadata.topic.";
        this.originalsWithPrefix(configPrefix, true).forEach((k, v) -> {
            if (!CONFIG.names().contains(configPrefix + k)) {
                configs.put((String)k, String.valueOf(v));
            }
        });
        configs.put("cleanup.policy", "compact");
        configs.put("unclean.leader.election.enable", "false");
        configs.put("min.insync.replicas", String.valueOf(this.minInSyncReplicas()));
        return new NewTopic(topic, numPartitions, replicationFactor).configs(configs);
    }

    public int minInSyncReplicas() {
        short replicationFactor = this.getShort(REPLICATION_FACTOR_PROP);
        return Math.min(replicationFactor, 2);
    }

    public String toString() {
        return String.format("%s: %n\t%s", ((Object)((Object)this)).getClass().getName(), Utils.mkString((Map)this.values(), (String)"", (String)"", (String)"=", (String)"%n\t"));
    }

    public static void main(String[] args) throws Exception {
        try (PrintStream out = args.length == 0 ? System.out : new PrintStream((OutputStream)new FileOutputStream(args[0]), false, StandardCharsets.UTF_8.name());){
            out.println(CONFIG.toHtmlTable());
            if (out != System.out) {
                out.close();
            }
        }
    }
}

