/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.store.kafka.coordinator;

import io.confluent.security.authorizer.utils.JsonMapper;
import io.confluent.security.store.kafka.coordinator.MetadataServiceAssignment;
import io.confluent.security.store.kafka.coordinator.MetadataServiceRebalanceListener;
import io.confluent.security.store.kafka.coordinator.NodeMetadata;
import java.net.URI;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.kafka.clients.GroupRebalanceConfig;
import org.apache.kafka.clients.consumer.CloseOptions;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.internals.AbstractCoordinator;
import org.apache.kafka.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.slf4j.Logger;

public class MetadataServiceCoordinator
extends AbstractCoordinator {
    private static final String PROTOCOL_TYPE = "metadata-service";
    public static final String PROTOCOL = "v0";
    private final Logger log;
    private final MetadataServiceRebalanceListener rebalanceListener;
    private final NodeMetadata nodeMetadata;
    private final AtomicBoolean isAlive;
    private MetadataServiceAssignment currentAssignment;

    public MetadataServiceCoordinator(LogContext logContext, ConsumerNetworkClient client, NodeMetadata nodeMetadata, ConsumerConfig consumerConfig, Metrics metrics, String metricGrpPrefix, Time time, MetadataServiceRebalanceListener rebalanceListener) {
        super(new GroupRebalanceConfig((AbstractConfig)consumerConfig, GroupRebalanceConfig.ProtocolType.CONSUMER), logContext, client, metrics, metricGrpPrefix, time);
        this.log = logContext.logger(MetadataServiceCoordinator.class);
        this.rebalanceListener = Objects.requireNonNull(rebalanceListener, "rebalanceListener");
        this.nodeMetadata = Objects.requireNonNull(nodeMetadata, "nodeMetadata");
        this.isAlive = new AtomicBoolean(true);
    }

    protected String protocolType() {
        return PROTOCOL_TYPE;
    }

    protected JoinGroupRequestData.JoinGroupRequestProtocolCollection metadata() {
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocolSet = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
        protocolSet.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName(PROTOCOL).setMetadata(this.nodeMetadata.serialize().array()));
        return protocolSet;
    }

    protected boolean onJoinPrepare(Timer timer, int generation, String memberId) {
        this.rebalanceListener.onRevoked(generation);
        this.currentAssignment = null;
        return true;
    }

    protected Map<String, ByteBuffer> onLeaderElected(String coordinationLeaderId, String protocol, List<JoinGroupResponseData.JoinGroupResponseMember> allMemberMetadata, boolean skipAssignment) {
        if (!PROTOCOL.equals(protocol)) {
            throw new IllegalArgumentException("Invalid protocol received for join complete");
        }
        if (skipAssignment) {
            throw new IllegalStateException("Can't skip assignment because MetadataServiceCoordinator does not support static membership.");
        }
        Map<String, NodeMetadata> allMembers = allMemberMetadata.stream().collect(Collectors.toMap(e -> e.memberId(), e -> NodeMetadata.deserialize(ByteBuffer.wrap(e.metadata()))));
        this.log.debug("Perform assignment on leader {} members {}", (Object)coordinationLeaderId, allMemberMetadata);
        MetadataServiceAssignment.AssignmentError error = MetadataServiceAssignment.AssignmentError.NONE;
        HashSet<URI> memberUris = new HashSet<URI>();
        for (NodeMetadata nodeMetadata : allMembers.values()) {
            if (nodeMetadata.uris().stream().anyMatch(memberUris::contains)) {
                error = MetadataServiceAssignment.AssignmentError.DUPLICATE_URLS;
                this.log.error("Some members are using duplicate URL: {}. Every Metadata Service instance  must be configured with a unique URL.", allMembers);
                break;
            }
            memberUris.addAll(nodeMetadata.uris());
        }
        Map.Entry writerEntry = Collections.min(allMembers.entrySet(), Comparator.comparing(Map.Entry::getValue));
        String writerMemberId = (String)writerEntry.getKey();
        NodeMetadata writerNodeMetdata = (NodeMetadata)writerEntry.getValue();
        MetadataServiceAssignment newAssignment = new MetadataServiceAssignment(error.errorCode, allMembers, writerMemberId, writerNodeMetdata);
        this.log.debug("Node {} with memberId {} elected as writer", (Object)writerNodeMetdata, (Object)writerMemberId);
        return allMemberMetadata.stream().collect(Collectors.toMap(e -> e.memberId(), e -> newAssignment.serialize()));
    }

    protected void onJoinComplete(int generation, String memberId, String protocol, ByteBuffer memberAssignment) {
        if (!PROTOCOL.equals(protocol)) {
            throw new IllegalArgumentException("Invalid protocol received for join complete");
        }
        this.currentAssignment = (MetadataServiceAssignment)JsonMapper.fromByteBuffer((ByteBuffer)memberAssignment, MetadataServiceAssignment.class);
        this.rebalanceListener.onAssigned(this.currentAssignment, generation);
    }

    void poll(Duration timeout) {
        long now = this.time.milliseconds();
        long endMs = now + timeout.toMillis();
        do {
            if (this.coordinatorUnknown()) {
                this.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
                now = this.time.milliseconds();
            }
            if (this.rejoinNeededOrPending() && this.isAlive.get()) {
                this.ensureActiveGroup();
                now = this.time.milliseconds();
            }
            if (!this.isAlive.get()) continue;
            this.pollHeartbeat(now);
            this.client.poll(this.time.timer(Math.min(Math.max(0L, endMs - now), this.timeToNextHeartbeat(now))));
        } while ((now = this.time.milliseconds()) < endMs && this.isAlive.get());
    }

    protected boolean rejoinNeededOrPending() {
        return super.rejoinNeededOrPending() || this.currentAssignment == null;
    }

    protected void close(Timer timer, CloseOptions.GroupMembershipOperation membershipOperation) {
        this.isAlive.set(false);
        super.close(timer, membershipOperation);
    }

    void onWriterResigned() {
        this.currentAssignment = null;
    }

    void wakeup() {
        this.client.wakeup();
    }
}

