/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.metadata;

import io.confluent.security.auth.metadata.AuthCache;
import io.confluent.security.auth.metadata.AuthWriter;
import io.confluent.security.trustservice.store.TrustCache;
import java.io.Closeable;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.apache.kafka.common.Configurable;
import org.slf4j.Logger;

public interface AuthStore
extends Configurable,
Closeable {
    public static final Map<String, AuthStore> INSTANCES = new HashMap<String, AuthStore>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AuthStore getInstance(String brokerSessionUuid) {
        Map<String, AuthStore> map = INSTANCES;
        synchronized (map) {
            return INSTANCES.get(brokerSessionUuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addInstance(String brokerSessionUuid, AuthStore store, Logger log) {
        Map<String, AuthStore> map = INSTANCES;
        synchronized (map) {
            AuthStore instance = INSTANCES.get(brokerSessionUuid);
            if (instance == null) {
                INSTANCES.put(brokerSessionUuid, store);
            } else {
                if (store != instance) {
                    throw new UnsupportedOperationException(store.getClass().getName() + " instance already exists for broker session " + brokerSessionUuid);
                }
                log.info("Skipping configuring {} instance ({}): Already configured.", (Object)store.getClass().getName(), (Object)brokerSessionUuid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeInstance(String brokerSessionUuid, AuthStore store, Logger log) {
        Map<String, AuthStore> map = INSTANCES;
        synchronized (map) {
            AuthStore instance = INSTANCES.get(brokerSessionUuid);
            if (instance == store) {
                INSTANCES.remove(brokerSessionUuid);
                log.info("Removed {} instance for broker session {}", (Object)store.getClass().getName(), (Object)brokerSessionUuid);
            } else if (instance != null) {
                log.info("Closing {} instance that doesn't match the instance in the static map with the same broker session {} will not remove that instance from the map.", (Object)store.getClass().getName(), (Object)brokerSessionUuid);
            }
        }
    }

    public CompletionStage<Void> startReader();

    public CompletionStage<Void> startService(Collection<URL> var1);

    public AuthCache authCache();

    public TrustCache trustCache();

    public AuthWriter writer();

    public boolean isMasterWriter();

    public URL masterWriterUrl(String var1);

    public Integer masterWriterId();

    public Collection<URL> activeNodeUrls(String var1);

    default public void updateStoreAuthCacheExternally(String key, String value) {
        throw new UnsupportedOperationException("this auth store does not support update auth cache externally");
    }
}

