/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.relocated.org.agrona.collections;

import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.IntPredicate;
import java.util.function.ToIntFunction;
import org.projectnessie.cel.relocated.org.agrona.BitUtil;
import org.projectnessie.cel.relocated.org.agrona.collections.CollectionUtil;
import org.projectnessie.cel.relocated.org.agrona.collections.Hashing;
import org.projectnessie.cel.relocated.org.agrona.collections.IntIntFunction;
import org.projectnessie.cel.relocated.org.agrona.collections.ObjIntConsumer;
import org.projectnessie.cel.relocated.org.agrona.collections.ObjIntPredicate;
import org.projectnessie.cel.relocated.org.agrona.collections.ObjectIntToIntFunction;

public class Object2IntHashMap<K>
implements Map<K, Integer> {
    static final int MIN_CAPACITY = 8;
    private final float loadFactor;
    private final int missingValue;
    private int resizeThreshold;
    private int size;
    private final boolean shouldAvoidAllocation;
    private K[] keys;
    private int[] values;
    private ValueCollection valueCollection;
    private KeySet keySet;
    private EntrySet entrySet;

    public Object2IntHashMap(int missingValue) {
        this(8, 0.65f, missingValue);
    }

    public Object2IntHashMap(int initialCapacity, float loadFactor, int missingValue) {
        this(initialCapacity, loadFactor, missingValue, true);
    }

    public Object2IntHashMap(int initialCapacity, float loadFactor, int missingValue, boolean shouldAvoidAllocation) {
        CollectionUtil.validateLoadFactor(loadFactor);
        this.loadFactor = loadFactor;
        int capacity = BitUtil.findNextPositivePowerOfTwo(Math.max(8, initialCapacity));
        this.resizeThreshold = (int)((float)capacity * loadFactor);
        this.missingValue = missingValue;
        this.shouldAvoidAllocation = shouldAvoidAllocation;
        this.keys = new Object[capacity];
        this.values = new int[capacity];
        Arrays.fill(this.values, missingValue);
    }

    public Object2IntHashMap(Object2IntHashMap<K> mapToCopy) {
        this.loadFactor = mapToCopy.loadFactor;
        this.resizeThreshold = mapToCopy.resizeThreshold;
        this.size = mapToCopy.size;
        this.missingValue = mapToCopy.missingValue;
        this.shouldAvoidAllocation = mapToCopy.shouldAvoidAllocation;
        this.keys = (Object[])mapToCopy.keys.clone();
        this.values = (int[])mapToCopy.values.clone();
    }

    public int missingValue() {
        return this.missingValue;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int capacity() {
        return this.values.length;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.missingValue != this.getValue(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue((Integer)value);
    }

    public boolean containsValue(int value) {
        int[] values;
        if (this.missingValue == value) {
            return false;
        }
        boolean found = false;
        for (int v : values = this.values) {
            if (value != v) continue;
            found = true;
            break;
        }
        return found;
    }

    @Override
    public int getOrDefault(Object key, int defaultValue) {
        int value = this.getValue(key);
        return this.missingValue != value ? value : defaultValue;
    }

    @Override
    public Integer get(Object key) {
        return this.valueOrNull(this.getValue(key));
    }

    public int getValue(K key) {
        int value;
        Objects.requireNonNull(key);
        int missingValue = this.missingValue;
        K[] keys = this.keys;
        int[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(key, mask);
        while (missingValue != (value = values[index]) && !Objects.equals(keys[index], key)) {
            ++index;
            index &= mask;
        }
        return value;
    }

    public int computeIfAbsent(K key, ToIntFunction<? super K> mappingFunction) {
        int value;
        Objects.requireNonNull(key);
        int missingValue = this.missingValue;
        K[] keys = this.keys;
        int[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(key, mask);
        while (missingValue != (value = values[index])) {
            if (Objects.equals(keys[index], key)) {
                return value;
            }
            ++index;
            index &= mask;
        }
        int newValue = mappingFunction.applyAsInt(key);
        if (missingValue != newValue) {
            keys[index] = key;
            values[index] = newValue;
            if (++this.size > this.resizeThreshold) {
                this.increaseCapacity();
            }
        }
        return newValue;
    }

    public int computeIfPresent(K key, ObjectIntToIntFunction<? super K> remappingFunction) {
        int value;
        Objects.requireNonNull(key);
        int missingValue = this.missingValue;
        K[] keys = this.keys;
        int[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(key, mask);
        while (missingValue != (value = values[index])) {
            if (Objects.equals(keys[index], key)) {
                int newValue;
                values[index] = newValue = remappingFunction.apply(key, value);
                if (missingValue == newValue) {
                    keys[index] = null;
                    --this.size;
                    this.compactChain(index);
                }
                return newValue;
            }
            ++index;
            index &= mask;
        }
        return missingValue;
    }

    public int compute(K key, ObjectIntToIntFunction<? super K> remappingFunction) {
        int oldValue;
        Objects.requireNonNull(key);
        int missingValue = this.missingValue;
        K[] keys = this.keys;
        int[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(key, mask);
        while (missingValue != (oldValue = values[index]) && !Objects.equals(keys[index], key)) {
            ++index;
            index &= mask;
        }
        int newValue = remappingFunction.apply(key, oldValue);
        if (missingValue != newValue) {
            values[index] = newValue;
            if (missingValue == oldValue) {
                keys[index] = key;
                if (++this.size > this.resizeThreshold) {
                    this.increaseCapacity();
                }
            }
        } else if (missingValue != oldValue) {
            keys[index] = null;
            values[index] = missingValue;
            --this.size;
            this.compactChain(index);
        }
        return newValue;
    }

    public int merge(K key, int value, IntIntFunction remappingFunction) {
        int newValue;
        int oldValue;
        Objects.requireNonNull(key);
        Objects.requireNonNull(remappingFunction);
        int missingValue = this.missingValue;
        if (missingValue == value) {
            throw new IllegalArgumentException("cannot accept missingValue");
        }
        K[] keys = this.keys;
        int[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(key, mask);
        while (missingValue != (oldValue = values[index]) && !Objects.equals(keys[index], key)) {
            ++index;
            index &= mask;
        }
        int n = newValue = missingValue == oldValue ? value : remappingFunction.apply(oldValue, value);
        if (missingValue != newValue) {
            keys[index] = key;
            values[index] = newValue;
            if (++this.size > this.resizeThreshold) {
                this.increaseCapacity();
            }
        } else {
            keys[index] = null;
            values[index] = missingValue;
            --this.size;
            this.compactChain(index);
        }
        return newValue;
    }

    @Override
    public Integer put(K key, Integer value) {
        return this.valueOrNull(this.put(key, (int)value));
    }

    @Override
    public int put(K key, int value) {
        int oldValue;
        Objects.requireNonNull(key);
        int missingValue = this.missingValue;
        if (missingValue == value) {
            throw new IllegalArgumentException("cannot accept missingValue");
        }
        K[] keys = this.keys;
        int[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(key, mask);
        while (missingValue != (oldValue = values[index]) && !Objects.equals(keys[index], key)) {
            ++index;
            index &= mask;
        }
        if (missingValue == oldValue) {
            ++this.size;
            keys[index] = key;
        }
        values[index] = value;
        if (this.size > this.resizeThreshold) {
            this.increaseCapacity();
        }
        return oldValue;
    }

    @Override
    public Integer putIfAbsent(K key, Integer value) {
        return this.valueOrNull(this.putIfAbsent(key, (int)value));
    }

    @Override
    public int putIfAbsent(K key, int value) {
        int oldValue;
        Objects.requireNonNull(key);
        int missingValue = this.missingValue;
        if (missingValue == value) {
            throw new IllegalArgumentException("cannot accept missingValue");
        }
        K[] keys = this.keys;
        int[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(key, mask);
        while (missingValue != (oldValue = values[index])) {
            if (Objects.equals(keys[index], key)) {
                return oldValue;
            }
            ++index;
            index &= mask;
        }
        keys[index] = key;
        values[index] = value;
        if (++this.size > this.resizeThreshold) {
            this.increaseCapacity();
        }
        return missingValue;
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove(key, (Integer)value);
    }

    public boolean remove(Object key, int value) {
        int existingValue;
        int missingValue = this.missingValue;
        K[] keys = this.keys;
        int[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(key, mask);
        while (missingValue != (existingValue = values[index])) {
            if (Objects.equals(keys[index], key)) {
                if (value != existingValue) break;
                keys[index] = null;
                values[index] = missingValue;
                --this.size;
                this.compactChain(index);
                return true;
            }
            ++index;
            index &= mask;
        }
        return false;
    }

    @Override
    public Integer remove(Object key) {
        return this.valueOrNull(this.removeKey(key));
    }

    public int removeKey(K key) {
        int value;
        Objects.requireNonNull(key);
        int missingValue = this.missingValue;
        K[] keys = this.keys;
        int[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(key, mask);
        while (missingValue != (value = values[index])) {
            if (Objects.equals(keys[index], key)) {
                keys[index] = null;
                values[index] = missingValue;
                --this.size;
                this.compactChain(index);
                break;
            }
            ++index;
            index &= mask;
        }
        return value;
    }

    @Override
    public void clear() {
        if (this.size > 0) {
            Arrays.fill(this.keys, null);
            Arrays.fill(this.values, this.missingValue);
            this.size = 0;
        }
    }

    public void compact() {
        int idealCapacity = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(Math.max(8, idealCapacity)));
    }

    @Override
    public void putAll(Map<? extends K, ? extends Integer> map) {
        for (Map.Entry<K, Integer> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void putAll(Object2IntHashMap<? extends K> map) {
        int missingValue = map.missingValue;
        K[] keys = map.keys;
        int[] values = map.values;
        int length = values.length;
        int remaining = map.size;
        for (int index = 0; remaining > 0 && index < length; ++index) {
            int value = values[index];
            if (missingValue == value) continue;
            this.put(keys[index], value);
            --remaining;
        }
    }

    public KeySet keySet() {
        if (null == this.keySet) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public ValueCollection values() {
        if (null == this.valueCollection) {
            this.valueCollection = new ValueCollection();
        }
        return this.valueCollection;
    }

    public EntrySet entrySet() {
        if (null == this.entrySet) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        EntryIterator entryIterator = new EntryIterator();
        entryIterator.reset();
        StringBuilder sb = new StringBuilder().append('{');
        while (true) {
            entryIterator.next();
            sb.append(entryIterator.getKey()).append('=').append(entryIterator.getIntValue());
            if (!entryIterator.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map that = (Map)o;
        if (this.size != that.size()) {
            return false;
        }
        K[] keys = this.keys;
        int[] values = this.values;
        int missingValue = this.missingValue;
        int thatMissingValue = o instanceof Object2IntHashMap ? ((Object2IntHashMap)o).missingValue : missingValue;
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            int thisValue = values[i];
            if (missingValue == thisValue) continue;
            Object thatValueObject = that.get(keys[i]);
            if (!(thatValueObject instanceof Integer)) {
                return false;
            }
            int thatValue = (Integer)thatValueObject;
            if (thatMissingValue != thatValue && thisValue == thatValue) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;
        K[] keys = this.keys;
        int[] values = this.values;
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            int value = values[i];
            if (this.missingValue == value) continue;
            result += keys[i].hashCode() ^ Integer.hashCode(value);
        }
        return result;
    }

    @Override
    public int replace(K key, int value) {
        int existingValue;
        Objects.requireNonNull(key);
        int missingValue = this.missingValue;
        if (missingValue == value) {
            throw new IllegalArgumentException("cannot accept missingValue");
        }
        K[] keys = this.keys;
        int[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(key, mask);
        while (missingValue != (existingValue = values[index])) {
            if (Objects.equals(keys[index], key)) {
                values[index] = value;
                return existingValue;
            }
            ++index;
            index &= mask;
        }
        return missingValue;
    }

    @Override
    public boolean replace(K key, int oldValue, int newValue) {
        int existingValue;
        Objects.requireNonNull(key);
        int missingValue = this.missingValue;
        if (missingValue == newValue) {
            throw new IllegalArgumentException("cannot accept missingValue");
        }
        K[] keys = this.keys;
        int[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(key, mask);
        while (missingValue != (existingValue = values[index])) {
            if (Objects.equals(keys[index], key)) {
                if (oldValue != existingValue) break;
                values[index] = newValue;
                return true;
            }
            ++index;
            index &= mask;
        }
        return false;
    }

    public void replaceAllInt(ObjectIntToIntFunction<? super K> function) {
        Objects.requireNonNull(function);
        int missingValue = this.missingValue;
        K[] keys = this.keys;
        int[] values = this.values;
        int length = values.length;
        int remaining = this.size;
        for (int index = 0; remaining > 0 && index < length; ++index) {
            int oldValue = values[index];
            if (missingValue == oldValue) continue;
            int newVal = function.apply(keys[index], oldValue);
            if (missingValue == newVal) {
                throw new IllegalArgumentException("cannot accept missingValue");
            }
            values[index] = newVal;
            --remaining;
        }
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super Integer> action) {
        this.forEachInt(action::accept);
    }

    public void forEachInt(ObjIntConsumer<? super K> action) {
        Objects.requireNonNull(action);
        int missingValue = this.missingValue;
        K[] keys = this.keys;
        int[] values = this.values;
        int length = values.length;
        int remaining = this.size;
        for (int index = 0; remaining > 0 && index < length; ++index) {
            int oldValue = values[index];
            if (missingValue == oldValue) continue;
            action.accept(keys[index], oldValue);
            --remaining;
        }
    }

    private void increaseCapacity() {
        int newCapacity = this.values.length << 1;
        if (newCapacity < 0) {
            throw new IllegalStateException("max capacity reached at size=" + this.size);
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        int mask = newCapacity - 1;
        this.resizeThreshold = (int)((float)newCapacity * this.loadFactor);
        Object[] tempKeys = new Object[newCapacity];
        int[] tempValues = new int[newCapacity];
        Arrays.fill(tempValues, this.missingValue);
        K[] keys = this.keys;
        int[] values = this.values;
        int size = values.length;
        for (int i = 0; i < size; ++i) {
            int value = values[i];
            if (this.missingValue == value) continue;
            K key = keys[i];
            int index = Hashing.hash(key, mask);
            while (this.missingValue != tempValues[index]) {
                ++index;
                index &= mask;
            }
            tempKeys[index] = key;
            tempValues[index] = value;
        }
        this.keys = tempKeys;
        this.values = tempValues;
    }

    private void compactChain(int deleteIndex) {
        K[] keys = this.keys;
        int[] values = this.values;
        int mask = values.length - 1;
        int index = deleteIndex;
        while (true) {
            ++index;
            int value = values[index &= mask];
            if (this.missingValue == value) break;
            K key = keys[index];
            int hash = Hashing.hash(key, mask);
            if ((index >= hash || hash > deleteIndex && deleteIndex > index) && (hash > deleteIndex || deleteIndex > index)) continue;
            keys[deleteIndex] = key;
            values[deleteIndex] = value;
            keys[index] = null;
            values[index] = this.missingValue;
            deleteIndex = index;
        }
    }

    private Integer valueOrNull(int value) {
        return value == this.missingValue ? null : Integer.valueOf(value);
    }

    public final class EntryIterator
    extends AbstractIterator<Map.Entry<K, Integer>>
    implements Map.Entry<K, Integer> {
        @Override
        public Map.Entry<K, Integer> next() {
            this.findNext();
            if (Object2IntHashMap.this.shouldAvoidAllocation) {
                return this;
            }
            return this.allocateDuplicateEntry();
        }

        private Map.Entry<K, Integer> allocateDuplicateEntry() {
            return new MapEntry(this.getKey(), this.getIntValue());
        }

        @Override
        public K getKey() {
            return Object2IntHashMap.this.keys[this.position()];
        }

        public int getIntValue() {
            return Object2IntHashMap.this.values[this.position()];
        }

        @Override
        public Integer getValue() {
            return this.getIntValue();
        }

        @Override
        public Integer setValue(Integer value) {
            return this.setValue((int)value);
        }

        @Override
        public int setValue(int value) {
            if (Object2IntHashMap.this.missingValue == value) {
                throw new IllegalArgumentException("cannot accept missingValue");
            }
            int pos = this.position();
            int oldValue = Object2IntHashMap.this.values[pos];
            ((Object2IntHashMap)Object2IntHashMap.this).values[pos] = value;
            return oldValue;
        }

        @Override
        public int hashCode() {
            return this.getKey().hashCode() ^ Integer.hashCode(this.getIntValue());
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Objects.equals(this.getKey(), e.getKey()) && e.getValue() instanceof Integer && this.getIntValue() == ((Integer)e.getValue()).intValue();
        }

        public final class MapEntry
        implements Map.Entry<K, Integer> {
            private final K k;
            private int v;

            public MapEntry(K k, int v) {
                this.k = k;
                this.v = v;
            }

            @Override
            public K getKey() {
                return this.k;
            }

            @Override
            public Integer getValue() {
                return this.v;
            }

            @Override
            public Integer setValue(Integer value) {
                Integer oldValue = Object2IntHashMap.this.put(this.k, value);
                this.v = value;
                return oldValue;
            }

            @Override
            public int hashCode() {
                return this.getKey().hashCode() ^ Integer.hashCode(this.v);
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                return Objects.equals(this.getKey(), e.getKey()) && e.getValue() instanceof Integer && this.v == (Integer)e.getValue();
            }

            public String toString() {
                return this.k + "=" + this.v;
            }
        }
    }

    public final class KeyIterator
    extends AbstractIterator<K> {
        @Override
        public K next() {
            this.findNext();
            return Object2IntHashMap.this.keys[this.position()];
        }
    }

    public final class ValueIterator
    extends AbstractIterator<Integer> {
        @Override
        public Integer next() {
            return this.nextInt();
        }

        public int nextInt() {
            this.findNext();
            return Object2IntHashMap.this.values[this.position()];
        }
    }

    abstract class AbstractIterator<T>
    implements Iterator<T> {
        private int posCounter;
        private int stopCounter;
        private int remaining;
        private boolean isPositionValid = false;

        AbstractIterator() {
        }

        protected final int position() {
            return this.posCounter & Object2IntHashMap.this.values.length - 1;
        }

        @Override
        public boolean hasNext() {
            return this.remaining > 0;
        }

        protected final void findNext() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int missingValue = Object2IntHashMap.this.missingValue;
            int[] values = Object2IntHashMap.this.values;
            int mask = values.length - 1;
            for (int i = this.posCounter - 1; i >= this.stopCounter; --i) {
                int index = i & mask;
                if (missingValue == values[index]) continue;
                this.posCounter = i;
                this.isPositionValid = true;
                --this.remaining;
                return;
            }
            this.isPositionValid = false;
            throw new IllegalStateException();
        }

        @Override
        public abstract T next();

        @Override
        public void remove() {
            if (!this.isPositionValid) {
                throw new IllegalStateException();
            }
            int position = this.position();
            ((Object2IntHashMap)Object2IntHashMap.this).values[position] = Object2IntHashMap.this.missingValue;
            ((Object2IntHashMap)Object2IntHashMap.this).keys[position] = null;
            --Object2IntHashMap.this.size;
            Object2IntHashMap.this.compactChain(position);
            this.isPositionValid = false;
        }

        final void reset() {
            int capacity;
            this.remaining = Object2IntHashMap.this.size;
            int[] values = Object2IntHashMap.this.values;
            int i = capacity = values.length;
            if (Object2IntHashMap.this.missingValue != values[capacity - 1]) {
                for (i = 0; i < capacity && Object2IntHashMap.this.missingValue != values[i]; ++i) {
                }
            }
            this.stopCounter = i;
            this.posCounter = i + capacity;
            this.isPositionValid = false;
        }
    }

    public final class EntrySet
    extends AbstractSet<Map.Entry<K, Integer>> {
        private final EntryIterator entryIterator;

        public EntrySet() {
            this.entryIterator = Object2IntHashMap.this.shouldAvoidAllocation ? new EntryIterator() : null;
        }

        public EntryIterator iterator() {
            EntryIterator entryIterator = this.entryIterator;
            if (null == entryIterator) {
                entryIterator = new EntryIterator();
            }
            entryIterator.reset();
            return entryIterator;
        }

        @Override
        public int size() {
            return Object2IntHashMap.this.size();
        }

        @Override
        public void clear() {
            Object2IntHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Integer value = Object2IntHashMap.this.get(entry.getKey());
            return value != null && value.equals(entry.getValue());
        }

        public boolean removeIfInt(ObjIntPredicate<? super K> filter) {
            boolean removed = false;
            EntryIterator iterator = this.iterator();
            while (iterator.hasNext()) {
                iterator.findNext();
                if (!filter.test(iterator.getKey(), iterator.getIntValue())) continue;
                iterator.remove();
                removed = true;
            }
            return removed;
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[this.size()]);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            T[] array = a.length >= Object2IntHashMap.this.size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), Object2IntHashMap.this.size);
            EntryIterator it = this.iterator();
            for (int i = 0; i < array.length; ++i) {
                if (!it.hasNext()) {
                    array[i] = null;
                    break;
                }
                it.next();
                array[i] = it.allocateDuplicateEntry();
            }
            return array;
        }
    }

    public final class ValueCollection
    extends AbstractCollection<Integer> {
        private final ValueIterator valueIterator;

        public ValueCollection() {
            this.valueIterator = Object2IntHashMap.this.shouldAvoidAllocation ? new ValueIterator() : null;
        }

        public ValueIterator iterator() {
            ValueIterator valueIterator = this.valueIterator;
            if (null == valueIterator) {
                valueIterator = new ValueIterator();
            }
            valueIterator.reset();
            return valueIterator;
        }

        @Override
        public int size() {
            return Object2IntHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return Object2IntHashMap.this.containsValue(o);
        }

        public boolean contains(int value) {
            return Object2IntHashMap.this.containsValue(value);
        }

        @Override
        public void clear() {
            Object2IntHashMap.this.clear();
        }

        public boolean removeIfInt(IntPredicate filter) {
            boolean removed = false;
            ValueIterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (!filter.test(iterator.nextInt())) continue;
                iterator.remove();
                removed = true;
            }
            return removed;
        }
    }

    public final class KeySet
    extends AbstractSet<K> {
        private final KeyIterator keyIterator;

        public KeySet() {
            this.keyIterator = Object2IntHashMap.this.shouldAvoidAllocation ? new KeyIterator() : null;
        }

        public KeyIterator iterator() {
            KeyIterator keyIterator = this.keyIterator;
            if (null == keyIterator) {
                keyIterator = new KeyIterator();
            }
            keyIterator.reset();
            return keyIterator;
        }

        @Override
        public int size() {
            return Object2IntHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return Object2IntHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return Object2IntHashMap.this.missingValue != Object2IntHashMap.this.removeKey(o);
        }

        @Override
        public void clear() {
            Object2IntHashMap.this.clear();
        }
    }
}

