/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.relocated.org.agrona.concurrent;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.projectnessie.cel.relocated.org.agrona.collections.ArrayUtil;
import org.projectnessie.cel.relocated.org.agrona.concurrent.Agent;

public class DynamicCompositeAgent
implements Agent {
    private static final Agent[] EMPTY_AGENTS = new Agent[0];
    private int agentIndex = 0;
    private volatile Status status = Status.INIT;
    private Agent[] agents;
    private final String roleName;
    private final AtomicReference<Agent> addAgent = new AtomicReference();
    private final AtomicReference<Agent> removeAgent = new AtomicReference();

    public DynamicCompositeAgent(String roleName) {
        this.roleName = roleName;
        this.agents = EMPTY_AGENTS;
    }

    public DynamicCompositeAgent(String roleName, List<? extends Agent> agents) {
        this.roleName = roleName;
        this.agents = new Agent[agents.size()];
        int i = 0;
        for (Agent agent : agents) {
            Objects.requireNonNull(agent, "agent cannot be null");
            this.agents[i++] = agent;
        }
    }

    public Status status() {
        return this.status;
    }

    public DynamicCompositeAgent(String roleName, Agent ... agents) {
        this.roleName = roleName;
        this.agents = new Agent[agents.length];
        int i = 0;
        for (Agent agent : agents) {
            Objects.requireNonNull(agent, "agent cannot be null");
            this.agents[i++] = agent;
        }
    }

    @Override
    public void onStart() {
        for (Agent agent : this.agents) {
            agent.onStart();
        }
        this.status = Status.ACTIVE;
    }

    @Override
    public int doWork() throws Exception {
        Agent agentToRemove;
        int workCount = 0;
        Agent agentToAdd = this.addAgent.get();
        if (null != agentToAdd) {
            this.add(agentToAdd);
        }
        if (null != (agentToRemove = this.removeAgent.get())) {
            this.remove(agentToRemove);
        }
        Agent[] agents = this.agents;
        while (this.agentIndex < agents.length) {
            Agent agent = agents[this.agentIndex++];
            workCount += agent.doWork();
        }
        this.agentIndex = 0;
        return workCount;
    }

    @Override
    public void onClose() {
        this.status = Status.CLOSED;
        Throwable ce = null;
        for (Agent agent : this.agents) {
            try {
                agent.onClose();
            }
            catch (Exception ex) {
                if (ce == null) {
                    ce = new RuntimeException(this.getClass().getName() + ": underlying agent error on close");
                }
                ce.addSuppressed(ex);
            }
        }
        this.agents = EMPTY_AGENTS;
        if (null != ce) {
            throw ce;
        }
    }

    @Override
    public String roleName() {
        return this.roleName;
    }

    public boolean tryAdd(Agent agent) {
        Objects.requireNonNull(agent, "agent cannot be null");
        if (Status.ACTIVE != this.status) {
            throw new IllegalStateException("add called when not active");
        }
        return this.addAgent.compareAndSet(null, agent);
    }

    public boolean hasAddAgentCompleted() {
        if (Status.ACTIVE != this.status) {
            throw new IllegalStateException("agent is not active");
        }
        return null == this.addAgent.get();
    }

    public boolean tryRemove(Agent agent) {
        Objects.requireNonNull(agent, "agent cannot be null");
        if (Status.ACTIVE != this.status) {
            throw new IllegalStateException("remove called when not active");
        }
        return this.removeAgent.compareAndSet(null, agent);
    }

    public boolean hasRemoveAgentCompleted() {
        if (Status.ACTIVE != this.status) {
            throw new IllegalStateException("agent is not active");
        }
        return null == this.removeAgent.get();
    }

    private void add(Agent agent) {
        this.addAgent.lazySet(null);
        try {
            agent.onStart();
        }
        catch (Exception ex) {
            try {
                agent.onClose();
            }
            catch (Exception se) {
                ex.addSuppressed(se);
            }
            throw ex;
        }
        this.agents = ArrayUtil.add(this.agents, agent);
    }

    private void remove(Agent agent) {
        this.removeAgent.lazySet(null);
        Agent[] newAgents = ArrayUtil.remove(this.agents, agent);
        try {
            if (newAgents != this.agents) {
                agent.onClose();
            }
        }
        finally {
            this.agents = newAgents;
        }
    }

    public static enum Status {
        INIT,
        ACTIVE,
        CLOSED;

    }
}

