/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.types.jackson;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ser.std.EnumSerializer;
import java.util.List;
import java.util.stream.Stream;
import org.projectnessie.cel.common.types.pb.Checked;
import org.projectnessie.cel.relocated.com.google.api.expr.v1alpha1.Type;
import org.projectnessie.cel.types.jackson.JacksonEnumValue;

final class JacksonEnumDescription {
    private final String name;
    private final Type pbType;
    private final List<Enum<?>> enumValues;

    JacksonEnumDescription(JavaType javaType, EnumSerializer ser) {
        this.name = javaType.getRawClass().getName().replace('$', '.');
        this.enumValues = ser.getEnumValues().enums();
        this.pbType = Checked.checkedInt;
    }

    Type pbType() {
        return this.pbType;
    }

    Stream<JacksonEnumValue> buildValues() {
        return this.enumValues.stream().map(JacksonEnumValue::new);
    }
}

