/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.tier.state;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafka.storage.tier.serdes.FragmentDescription;
import io.confluent.kafka.storage.tier.store.objects.FragmentDescriptionWrapper;
import io.confluent.kafka.storage.tier.store.objects.FragmentType;
import io.confluent.kafka.storage.tier.store.objects.ObjectType;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;

public class SegmentAndMetadataLayout {
    private static final int BYTES_PER_FRAGMENT = 6;
    private static final int OBJECT_TYPE_INDEX = 0;
    private static final int FRAGMENT_TYPE_INDEX = 1;
    private static final int SIZE_START_INDEX = 2;
    private final byte[] fragmentInfoArray;
    static final Comparator<FragmentDescriptionWrapper> SEGMENT_FRAGMENT_DESCRIPTION_COMPARATOR = (description1, description2) -> {
        byte objectType1 = description1.objectType().getByte();
        byte objectType2 = description2.objectType().getByte();
        long filePosition1 = description1.filePosition();
        long filePosition2 = description2.filePosition();
        if (objectType1 == objectType2 && filePosition1 == filePosition2) {
            return description1.size() - description2.size();
        }
        if (objectType1 == objectType2) {
            return filePosition1 > filePosition2 ? 1 : -1;
        }
        return objectType1 - objectType2;
    };
    private static final int TO_STRING_INITIAL_STRING_BUILDER_CAPACITY = 128;

    public Optional<FragmentDescriptionWrapper> getSegmentFragmentDescription(FragmentType fragmentType) {
        FragmentDescriptionIterator fragmentDescriptionIterator = new FragmentDescriptionIterator(this.fragmentInfoArray);
        while (fragmentDescriptionIterator.hasNext()) {
            FragmentDescriptionWrapper currentFragmentDescription = (FragmentDescriptionWrapper)fragmentDescriptionIterator.next();
            if (currentFragmentDescription.fragmentType() != fragmentType) continue;
            return Optional.of(currentFragmentDescription);
        }
        return Optional.empty();
    }

    @JsonProperty(value="fragmentDescriptionsList", required=true)
    public List<FragmentDescriptionWrapper> fragmentDescriptionsList() {
        ArrayList<FragmentDescriptionWrapper> segmentFragmentDescriptionsList = new ArrayList<FragmentDescriptionWrapper>();
        FragmentDescriptionIterator fragmentDescriptionIterator = new FragmentDescriptionIterator(this.fragmentInfoArray);
        while (fragmentDescriptionIterator.hasNext()) {
            segmentFragmentDescriptionsList.add(fragmentDescriptionIterator.next());
        }
        return segmentFragmentDescriptionsList;
    }

    public SegmentAndMetadataLayout(FragmentDescription.Vector fragmentDescriptionVector, int vectorLength) {
        this.fragmentInfoArray = this.createFragmentInfoArrayFromFragmentDescriptionVector(fragmentDescriptionVector, vectorLength);
    }

    @JsonCreator
    public SegmentAndMetadataLayout(@JsonProperty(value="fragmentDescriptionsList") List<FragmentDescriptionWrapper> fragmentDescriptionsList) {
        this.fragmentInfoArray = this.createFragmentInfoArrayFromFragmentDescriptionsList(fragmentDescriptionsList);
    }

    private byte[] createFragmentInfoArrayFromFragmentDescriptionVector(FragmentDescription.Vector fragmentDescriptionVector, int vectorLength) {
        ArrayList<FragmentDescriptionWrapper> fragmentDescriptionsList = new ArrayList<FragmentDescriptionWrapper>();
        for (int i = 0; i < vectorLength; ++i) {
            FragmentDescription fragmentDescription = fragmentDescriptionVector.get(i);
            fragmentDescriptionsList.add(new FragmentDescriptionWrapper(fragmentDescription));
        }
        return this.createFragmentInfoArrayFromFragmentDescriptionsList(fragmentDescriptionsList);
    }

    private byte[] createFragmentInfoArrayFromFragmentDescriptionsList(List<FragmentDescriptionWrapper> fragmentDescriptionsList) {
        if (fragmentDescriptionsList.isEmpty()) {
            throw new IllegalArgumentException("Invalid Segment And Metadata Layout: layout must have at least one fragment");
        }
        byte[] fragmentInfoArray = new byte[fragmentDescriptionsList.size() * 6];
        fragmentDescriptionsList.sort(SEGMENT_FRAGMENT_DESCRIPTION_COMPARATOR);
        HashSet<Byte> fragmentTypeBytes = new HashSet<Byte>();
        long expectedFragmentPosition = 0L;
        byte prevObjectTypeByte = fragmentDescriptionsList.get(0).objectType().getByte();
        for (int i = 0; i < fragmentDescriptionsList.size(); ++i) {
            FragmentDescriptionWrapper fragmentDescription = fragmentDescriptionsList.get(i);
            byte objectTypeByte = fragmentDescription.objectType().getByte();
            if (objectTypeByte != prevObjectTypeByte) {
                expectedFragmentPosition = 0L;
                prevObjectTypeByte = objectTypeByte;
            }
            byte fragmentTypeByte = fragmentDescription.fragmentType().getByte();
            int fragmentSize = fragmentDescription.size();
            if (fragmentTypeBytes.contains(fragmentTypeByte)) {
                throw new IllegalArgumentException(String.format("Invalid Segment And Metadata Layout: duplicate fragment types included for fragment of type %s", new Object[]{FragmentType.byteToFragmentType(fragmentTypeByte)}));
            }
            fragmentTypeBytes.add(fragmentTypeByte);
            if (fragmentSize < 0) {
                throw new IllegalArgumentException(String.format("Invalid Segment And Metadata Layout: Fragment of type %s has a negative size of %d.", new Object[]{FragmentType.byteToFragmentType(fragmentTypeByte), fragmentSize}));
            }
            if (fragmentDescription.filePosition() != expectedFragmentPosition) {
                throw new IllegalArgumentException(String.format("Invalid Segment And Metadata Layout: all fragments present in each file must continuous (i.e. no gap between end position of priorfragment and the start position of the next one). Fragment of type %s violates this, with expected position %d and actual position %d", new Object[]{FragmentType.byteToFragmentType(fragmentTypeByte), expectedFragmentPosition, fragmentDescription.filePosition()}));
            }
            expectedFragmentPosition += (long)fragmentSize;
            int fragmentInfoArrayOffset = i * 6;
            fragmentInfoArray[fragmentInfoArrayOffset + 0] = objectTypeByte;
            fragmentInfoArray[fragmentInfoArrayOffset + 1] = fragmentTypeByte;
            byte[] currentFragmentSizeByteArray = ByteBuffer.allocate(4).putInt(fragmentSize).array();
            System.arraycopy(currentFragmentSizeByteArray, 0, fragmentInfoArray, fragmentInfoArrayOffset + 2, 4);
        }
        return fragmentInfoArray;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentAndMetadataLayout that = (SegmentAndMetadataLayout)o;
        return Arrays.equals(this.fragmentInfoArray, that.fragmentInfoArray);
    }

    public int hashCode() {
        return Arrays.hashCode(this.fragmentInfoArray);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        List<FragmentDescriptionWrapper> fragmentDescriptionsList = this.fragmentDescriptionsList();
        sb.append("SegmentAndMetadataLayout(fragmentDescriptionsList=[");
        for (FragmentDescriptionWrapper fragmentDescription : fragmentDescriptionsList) {
            sb.append(fragmentDescription.toString());
            sb.append(", ");
        }
        sb.append("])");
        return sb.toString();
    }

    private static class FragmentDescriptionIterator
    implements Iterator<FragmentDescriptionWrapper> {
        private int fragmentIndex = 0;
        private long nextFragmentFilePosition = 0L;
        private ObjectType prevFragmentObjectType = null;
        private final byte[] fragmentInfoArray;

        public FragmentDescriptionIterator(byte[] fragmentInfoArray) {
            this.fragmentInfoArray = fragmentInfoArray;
        }

        private int numFragments() {
            return this.fragmentInfoArray.length / 6;
        }

        private FragmentType getFragmentType(int fragmentOffset) {
            return FragmentType.byteToFragmentType(this.fragmentInfoArray[fragmentOffset + 1]);
        }

        private ObjectType getObjectType(int fragmentOffset) {
            return ObjectType.byteToObjectType(this.fragmentInfoArray[fragmentOffset + 0]);
        }

        private int getFragmentSize(int fragmentOffset) {
            byte[] currentSizeByteArray = Arrays.copyOfRange(this.fragmentInfoArray, fragmentOffset + 2, fragmentOffset + 6);
            return ByteBuffer.wrap(currentSizeByteArray).getInt();
        }

        @Override
        public boolean hasNext() {
            return this.fragmentIndex < this.numFragments();
        }

        @Override
        public FragmentDescriptionWrapper next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No fragment descriptions are remaining on call to FragmentDescriptionIterator.next()");
            }
            int offset = this.fragmentIndex * 6;
            FragmentType fragmentType = this.getFragmentType(offset);
            ObjectType objectType = this.getObjectType(offset);
            int fragmentSize = this.getFragmentSize(offset);
            if (objectType != this.prevFragmentObjectType) {
                this.nextFragmentFilePosition = 0L;
                this.prevFragmentObjectType = objectType;
            }
            FragmentDescriptionWrapper next = new FragmentDescriptionWrapper(fragmentType, objectType, this.nextFragmentFilePosition, fragmentSize);
            this.nextFragmentFilePosition += (long)fragmentSize;
            ++this.fragmentIndex;
            return next;
        }
    }
}

