/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.log.LogCleanerMetrics;

public class CleanerStats {
    long bytesRead = 0L;
    long bytesWritten = 0L;
    long mapBytesRead = 0L;
    long messagesRead = 0L;
    long invalidMessagesRead = 0L;
    long messagesWritten = 0L;
    double bufferUtilization = 0.0;
    private long mapCompleteTime = -1L;
    private long endTime = -1L;
    private long mapMessagesRead = 0L;
    private final Time time;
    private final long startTime;
    private long throttledTime = 0L;
    private long keyBytesRead = 0L;
    private boolean offsetMapFull = false;
    private final LogCleanerMetrics cleanerMetrics;

    public CleanerStats(Time time, LogCleanerMetrics cleanerMetrics) {
        this.time = time;
        this.startTime = time.milliseconds();
        this.cleanerMetrics = cleanerMetrics;
    }

    public void readMessages(int messagesRead, int bytesRead, int keyBytesRead) {
        this.messagesRead += (long)messagesRead;
        this.bytesRead += (long)bytesRead;
        this.keyBytesRead += (long)keyBytesRead;
        this.cleanerMetrics.bytesReadPerSec.mark((long)bytesRead);
    }

    public void invalidMessage() {
        ++this.invalidMessagesRead;
    }

    public void recopyMessages(int messagesWritten, int bytesWritten) {
        this.messagesWritten += (long)messagesWritten;
        this.bytesWritten += (long)bytesWritten;
        this.cleanerMetrics.bytesWrittenPerSec.mark((long)bytesWritten);
    }

    public void indexMessagesRead(int size) {
        this.mapMessagesRead += (long)size;
    }

    public void indexBytesRead(int size) {
        this.mapBytesRead += (long)size;
        this.cleanerMetrics.offsetIndexBytesPerSec.mark((long)size);
    }

    public void indexDone(boolean isOffsetMapFull) {
        this.offsetMapFull = isOffsetMapFull;
        this.mapCompleteTime = this.time.milliseconds();
        if (this.offsetMapFull) {
            this.cleanerMetrics.offsetMapFilledRatePerSec.mark();
        }
    }

    public void recordThrottledTime(long throttledTimeInMs) {
        this.throttledTime += throttledTimeInMs;
    }

    public void validationPassed() {
        this.cleanerMetrics.validationPassedPerSec.mark();
    }

    public void validationAborted() {
        this.cleanerMetrics.validationAbortedPerSec.mark();
    }

    public void validationFailed() {
        this.cleanerMetrics.validationFailedPerSec.mark();
    }

    public void allDone() {
        this.endTime = this.time.milliseconds();
    }

    public double elapsedSecs() {
        return (double)(this.endTime - this.startTime) / 1000.0;
    }

    public double elapsedIndexSecs() {
        return (double)(this.mapCompleteTime - this.startTime) / 1000.0;
    }

    public double throttledSecs() {
        return (double)this.throttledTime / 1000.0;
    }

    public long startTime() {
        return this.startTime;
    }

    public long endTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long bytesRead() {
        return this.bytesRead;
    }

    public long bytesWritten() {
        return this.bytesWritten;
    }

    public long mapBytesRead() {
        return this.mapBytesRead;
    }

    public long mapMessagesRead() {
        return this.mapMessagesRead;
    }

    public long messagesRead() {
        return this.messagesRead;
    }

    public long invalidMessagesRead() {
        return this.invalidMessagesRead;
    }

    public long messagesWritten() {
        return this.messagesWritten;
    }

    public double bufferUtilization() {
        return this.bufferUtilization;
    }

    public void setBufferUtilization(double bufferUtilization) {
        this.bufferUtilization = bufferUtilization;
    }

    public long keyBytesRead() {
        return this.keyBytesRead;
    }

    public boolean offsetMapFull() {
        return this.offsetMapFull;
    }
}

