/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.secretregistry;

import io.confluent.common.security.auth.JwtPrincipal;
import io.confluent.common.security.util.JwtUtils;
import io.confluent.connect.secretregistry.rbac.SecretRegistryActions;
import io.confluent.connect.secretregistry.rbac.SecretRegistryOperations;
import io.confluent.kafka.secretregistry.rest.resources.PathResource;
import io.confluent.security.auth.client.RestAuthorizer;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.AuthorizeResult;
import io.confluent.security.authorizer.Scope;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.kafka.common.security.auth.ConfluentPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.health.ConnectClusterState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectSecretRegistryFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    static final Method LIST_PATHS_METHOD;
    private static final Logger log;
    private final Scope scope;
    private final SecretRegistryActions actions;
    private final RestAuthorizer restAuthorizer;
    @Context
    private ResourceInfo resourceInfo;

    public ConnectSecretRegistryFilter(Scope scope, RestAuthorizer restAuthorizer, ConnectClusterState clusterState) {
        this(scope, SecretRegistryActions.build(scope, clusterState), restAuthorizer, null);
    }

    ConnectSecretRegistryFilter(Scope scope, SecretRegistryActions actions, RestAuthorizer restAuthorizer, ResourceInfo resourceInfo) {
        this.scope = scope;
        this.restAuthorizer = restAuthorizer;
        this.actions = actions;
        this.resourceInfo = resourceInfo;
    }

    private static <T> T responseEntity(ContainerResponseContext responseContext) {
        return (T)responseContext.getEntity();
    }

    public static KafkaPrincipal kafkaPrincipalFor(Principal userPrincipal) {
        Set groups;
        Objects.requireNonNull(userPrincipal, "Principal may not be null");
        if (userPrincipal instanceof JwtPrincipal && !(groups = JwtUtils.getGroupsFromJwtPrincipal((JwtPrincipal)((JwtPrincipal)userPrincipal))).isEmpty()) {
            return new ConfluentPrincipal("User", userPrincipal.getName(), userPrincipal.getName(), Optional.empty(), false, groups);
        }
        return new KafkaPrincipal("User", userPrincipal.getName());
    }

    public static <L, R> Stream<Pair<L, R>> zip(List<L> left, List<R> right) {
        return IntStream.range(0, Math.min(left.size(), right.size())).mapToObj(i -> Pair.of(left.get(i), right.get(i)));
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (this.restAuthorizer == null) {
            log.warn("Rest authorizer not active");
            return;
        }
        Method resourceMethod = this.resourceInfo.getResourceMethod();
        if (LIST_PATHS_METHOD.equals(resourceMethod)) {
            return;
        }
        List<Action> actions = this.actions.actions(resourceMethod, requestContext);
        if (!actions.isEmpty()) {
            Principal requestPrincipal = requestContext.getSecurityContext().getUserPrincipal();
            if (requestPrincipal == null) {
                requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"User not authenticated").build());
                return;
            }
            KafkaPrincipal userPrincipal = ConnectSecretRegistryFilter.kafkaPrincipalFor(requestPrincipal);
            log.debug("Authorizing request for principal {}. Actions: {}", (Object)userPrincipal, actions);
            List authorizations = this.restAuthorizer.authorize(userPrincipal, null, actions);
            if (!authorizations.stream().allMatch(arg_0 -> AuthorizeResult.ALLOWED.equals(arg_0))) {
                requestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"Unauthorized operation").build());
            }
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        if (this.restAuthorizer == null) {
            log.warn("Rest authorizer not active");
            return;
        }
        Method resourceMethod = this.resourceInfo.getResourceMethod();
        if (responseContext.getStatus() == Response.Status.OK.getStatusCode() && LIST_PATHS_METHOD.equals(resourceMethod)) {
            Collection allPaths = (Collection)ConnectSecretRegistryFilter.responseEntity(responseContext);
            if (allPaths.isEmpty()) {
                return;
            }
            List actions = allPaths.stream().flatMap(path -> SecretRegistryOperations.ALL.stream().map(op -> new Action(this.scope, SecretRegistryActions.SECRET_RESOURCE, path, op))).collect(Collectors.toList());
            List authorizations = this.restAuthorizer.authorize(ConnectSecretRegistryFilter.kafkaPrincipalFor(requestContext.getSecurityContext().getUserPrincipal()), null, actions);
            Collection visiblePaths = ConnectSecretRegistryFilter.zip(authorizations, actions).filter((? super T pair) -> AuthorizeResult.ALLOWED.equals(pair.getLeft())).map(Pair::getRight).map(Action::resourceName).collect(Collectors.toSet());
            responseContext.setEntity((Object)visiblePaths);
        }
    }

    static {
        log = LoggerFactory.getLogger(ConnectSecretRegistryFilter.class);
        try {
            LIST_PATHS_METHOD = PathResource.class.getMethod("list", SecurityContext.class);
        }
        catch (NoSuchMethodException e) {
            throw new ConnectException("Failed to initialize Secret Registry RBAC filter", (Throwable)e);
        }
    }
}

