/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.secretregistry.rbac;

import io.confluent.connect.secretregistry.rbac.ActionBuilder;
import io.confluent.connect.secretregistry.rbac.SecretRegistryActions;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.roledefinitions.Operation;
import jakarta.ws.rs.container.ContainerRequestContext;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

class SimpleSecretRegistryActionBuilder
implements ActionBuilder {
    private final Scope scope;
    private final List<Operation> operations;

    public SimpleSecretRegistryActionBuilder(Scope scope, Operation ... operations) {
        this.scope = scope;
        this.operations = Arrays.asList(operations);
    }

    private static String pathName(ContainerRequestContext requestContext) {
        return (String)requestContext.getUriInfo().getPathParameters().getFirst((Object)"path");
    }

    @Override
    public List<Action> computeActions(ContainerRequestContext requestContext) {
        String path = SimpleSecretRegistryActionBuilder.pathName(requestContext);
        return this.operations.stream().map(operation -> new Action(this.scope, SecretRegistryActions.SECRET_RESOURCE, path, operation)).collect(Collectors.toList());
    }
}

