/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hub.utils;

import io.confluent.connect.hub.cli.ExitCode;
import io.confluent.connect.hub.exceptions.ConfluentHubClientException;
import io.confluent.pluginregistry.PluginId;
import io.confluent.pluginregistry.rest.entities.PluginArchive;
import io.confluent.pluginregistry.rest.entities.PluginManifest;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Formatter;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class NamingUtils {
    private static final String LATEST_VERSION_TAG = "latest";
    private static final String API_PLUGIN_TEMPLATE = "/api/plugins/%s/%s";
    private static final String API_PLUGIN_VERSION_TEMPLATE = "/api/plugins/%s/%s/versions/%s";
    private static final String UNABLE_TO_PARSE_PLUGIN_ID_MSG = "Unable to parse plugin id, make sure it has format: <owner>/<name>:<version|latest>";
    private static final String UNABLE_TO_PARSE_ARCHIVE_URL_MSG = "Unable to parse archive's URL for a component";
    private static final String NULL_PLUGIN_ID_MSG = "Component identifier is required";
    private static final String MANIFEST_FILENAME = "manifest.json";

    public static PluginId parsePluginId(String pluginIdStr) throws ConfluentHubClientException {
        try {
            if (pluginIdStr == null) {
                throw new ConfluentHubClientException(NULL_PLUGIN_ID_MSG, ExitCode.COMPONENT_NOT_FOUND);
            }
            StringTokenizer tokenizer = new StringTokenizer(pluginIdStr, "/");
            String owner = tokenizer.nextToken();
            String nameVersion = tokenizer.nextToken();
            tokenizer = new StringTokenizer(nameVersion, ":");
            String name = tokenizer.nextToken();
            String version = tokenizer.nextToken();
            PluginId pluginId = new PluginId(owner, name, version);
            if (tokenizer.hasMoreTokens()) {
                throw new ConfluentHubClientException(UNABLE_TO_PARSE_PLUGIN_ID_MSG, ExitCode.COMPONENT_NOT_FOUND);
            }
            return pluginId;
        }
        catch (NoSuchElementException e) {
            throw new ConfluentHubClientException(UNABLE_TO_PARSE_PLUGIN_ID_MSG, ExitCode.COMPONENT_NOT_FOUND);
        }
    }

    public static String byteArray2Hex(byte[] bytes) {
        Formatter formatter = new Formatter();
        for (byte b : bytes) {
            formatter.format("%02x", b);
        }
        String hex = formatter.toString();
        formatter.close();
        return hex;
    }

    public static String getComponentJarName(PluginManifest manifest) {
        return manifest.getName() + "-" + manifest.getVersion() + ".jar";
    }

    public static String getInstallToComponentFolder(String path, PluginManifest manifest) {
        return path + File.separatorChar + manifest.getOwner().getUsername() + "-" + manifest.getName();
    }

    public static String getBundledComponentFolder(String path, PluginManifest manifest) {
        return path + File.separatorChar + manifest.getName();
    }

    public static String getArchivePath(String path, PluginManifest manifest) {
        return path + File.separatorChar + manifest.getArchive().getName();
    }

    public static String getManifestPath(String path) {
        return path + File.separatorChar + MANIFEST_FILENAME;
    }

    public static String getPathForComponent(PluginId pluginId) {
        if (LATEST_VERSION_TAG.equals(pluginId.version())) {
            return String.format(API_PLUGIN_TEMPLATE, pluginId.owner(), pluginId.name(), pluginId.version());
        }
        return String.format(API_PLUGIN_VERSION_TEMPLATE, pluginId.owner(), pluginId.name(), pluginId.version());
    }

    public static URI getArchiveUri(PluginArchive archive) {
        try {
            URL url = new URL(archive.getUrl());
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new ConfluentHubClientException(UNABLE_TO_PARSE_ARCHIVE_URL_MSG, ExitCode.UNKNOWN_ERROR);
        }
        catch (MalformedURLException e) {
            throw new ConfluentHubClientException(UNABLE_TO_PARSE_ARCHIVE_URL_MSG, ExitCode.UNKNOWN_ERROR);
        }
    }

    public static String getArchiveItemAbsolutePath(String root, String relativePath) {
        return Paths.get(root, relativePath).toFile().getAbsolutePath();
    }
}

