/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.pluginregistry.rest.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.pluginregistry.util.JsonUtil;
import io.confluent.pluginregistry.util.ObjectUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public class PluginStatistics
implements Comparable<PluginStatistics> {
    @JsonProperty
    private Integer rating;
    @JsonProperty
    private Long downloads;

    public static PluginStatistics fromJson(String json) throws IOException {
        return (PluginStatistics)JsonUtil.newObjectMapper().readValue(json, PluginStatistics.class);
    }

    public static PluginStatistics fromJson(InputStream json) throws IOException {
        return (PluginStatistics)JsonUtil.newObjectMapper().readValue(json, PluginStatistics.class);
    }

    public PluginStatistics() {
    }

    public PluginStatistics(Integer rating, Long downloads) {
        this.rating = rating;
        this.downloads = downloads;
    }

    public PluginStatistics(PluginStatistics original) {
        this.setRating(original.rating);
        this.setDownloads(original.downloads);
    }

    public String toJson() throws IOException {
        return JsonUtil.newObjectMapper().writeValueAsString((Object)this);
    }

    public Integer getRating() {
        return this.rating;
    }

    public void setRating(Integer rating) {
        this.rating = rating;
    }

    public Long getDownloads() {
        return this.downloads;
    }

    public void setDownloads(Long downloads) {
        this.downloads = downloads;
    }

    public int hashCode() {
        return Objects.hash(this.rating, this.downloads);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginStatistics that = (PluginStatistics)o;
        return ObjectUtil.equals(this.rating, that.rating) && ObjectUtil.equals(this.downloads, that.downloads);
    }

    @Override
    public int compareTo(PluginStatistics that) {
        if (this == that) {
            return 0;
        }
        if (that == null) {
            return 1;
        }
        int diff = this.rating - that.rating;
        if (diff != 0) {
            return diff;
        }
        diff = Long.compare(this.downloads, that.downloads);
        return diff;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{rating=" + this.rating + ",");
        sb.append("downloads=" + this.downloads + "}");
        return sb.toString();
    }
}

