/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.pluginregistry.rest.entities;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.pluginregistry.Version;
import io.confluent.pluginregistry.util.JsonUtil;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.Objects;

public class PluginVersion
implements Comparable<PluginVersion> {
    private Version version;
    @JsonProperty(value="manifest_url")
    private String manifestUrl;
    @JsonProperty(value="release_date")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    private LocalDate releaseDate;

    public static PluginVersion fromJson(String json) throws IOException {
        return (PluginVersion)JsonUtil.newObjectMapper().readValue(json, PluginVersion.class);
    }

    public static PluginVersion fromJson(InputStream json) throws IOException {
        return (PluginVersion)JsonUtil.newObjectMapper().readValue(json, PluginVersion.class);
    }

    public PluginVersion() {
    }

    public PluginVersion(String version, String manifestUrl, LocalDate releaseDate) {
        this.setVersion(version);
        this.manifestUrl = manifestUrl;
        this.releaseDate = releaseDate;
    }

    public PluginVersion(PluginVersion original) {
        this.setVersion(original.getVersion());
        this.manifestUrl = original.manifestUrl;
        this.releaseDate = original.releaseDate;
    }

    public String toJson() throws IOException {
        return JsonUtil.newObjectMapper().writeValueAsString((Object)this);
    }

    @JsonProperty(value="version")
    public String getVersion() {
        return this.version != null ? this.version.toString() : null;
    }

    @JsonProperty(value="version")
    public void setVersion(String version) {
        this.version = version != null ? new Version(version) : null;
    }

    public LocalDate getReleaseDate() {
        return this.releaseDate;
    }

    public void setReleaseDate(LocalDate releaseDate) {
        this.releaseDate = releaseDate;
    }

    public String getManifestUrl() {
        return this.manifestUrl;
    }

    public void setManifestUrl(String manifestUrl) {
        this.manifestUrl = manifestUrl;
    }

    public int hashCode() {
        return this.version != null ? this.version.hashCode() : 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginVersion that = (PluginVersion)o;
        return Objects.equals(this.version, that.version) && Objects.equals(this.releaseDate, that.releaseDate) && Objects.equals(this.manifestUrl, that.manifestUrl);
    }

    @Override
    public int compareTo(PluginVersion that) {
        if (this == that) {
            return 0;
        }
        if (that == null) {
            return 1;
        }
        Version thisVersion = this.version;
        Version thatVersion = that.version;
        return thisVersion != null ? thisVersion.compareTo(thatVersion) : -1 * thatVersion.compareTo(thisVersion);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{version=" + String.valueOf(this.version) + ",");
        sb.append("releaseDate=" + String.valueOf(this.releaseDate) + ",");
        sb.append("manifestUrl=" + this.manifestUrl + "}");
        return sb.toString();
    }
}

