/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.ingester;

import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.record.TimestampType;

public final class IngesterRecord {
    private final long timeMs;
    private final TopicPartition topicPartition;
    private final long offset;
    private final String key;
    private final String value;

    public static IngesterRecord fromConsumerRecord(ConsumerRecord<String, String> record) {
        return new IngesterRecord(record.timestamp(), new TopicPartition(record.topic(), record.partition()), record.offset(), (String)record.key(), (String)record.value());
    }

    public IngesterRecord(long timeMs, TopicPartition topicPartition, long offset, String key, String value) {
        this.timeMs = timeMs;
        this.topicPartition = topicPartition;
        this.offset = offset;
        this.key = Objects.requireNonNull(key);
        this.value = value == null ? "" : value;
    }

    public long timeMs() {
        return this.timeMs;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public long offset() {
        return this.offset;
    }

    public String key() {
        return this.key;
    }

    public String value() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(IngesterRecord.class)) {
            return false;
        }
        IngesterRecord other = (IngesterRecord)o;
        return this.timeMs == other.timeMs && this.topicPartition.equals((Object)other.topicPartition) && this.offset == other.offset && this.key.equals(other.key) && this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.timeMs, this.topicPartition, this.offset, this.key, this.value);
    }

    public ConsumerRecord<String, String> toConsumerRecord() {
        return new ConsumerRecord(this.topicPartition.topic(), this.topicPartition.partition(), this.offset, this.timeMs, TimestampType.NO_TIMESTAMP_TYPE, -1, -1, (Object)this.key, (Object)this.value, (Headers)new RecordHeaders(), Optional.empty());
    }

    public String toString() {
        return "IngesterRecord(timeMs=" + this.timeMs + ", topicPartition=" + String.valueOf(this.topicPartition) + ", offset=" + this.offset + ", key='" + this.key + "', value='" + this.value + "')";
    }
}

