/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.common.runtime;

import java.util.ArrayList;
import java.util.PriorityQueue;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.common.runtime.CoordinatorEvent;
import org.apache.kafka.coordinator.common.runtime.EventLogger;
import org.slf4j.Logger;

public class SlowEventLogger
implements EventLogger {
    private final Logger log;
    private final Time time;
    private final int logIntervalMs;
    private final int logEventCount;
    private final PriorityQueue<EventAndProcessingTime> eventsMinHeap;
    private long lastLogTimeMs;

    public SlowEventLogger(LogContext logContext, Time time, int logIntervalMs, int logEventCount) {
        this.log = logContext.logger(SlowEventLogger.class);
        this.time = time;
        this.logIntervalMs = logIntervalMs;
        this.logEventCount = logEventCount;
        this.eventsMinHeap = new PriorityQueue(logEventCount + 1, (a, b) -> Long.compare(a.processingTimeMs, b.processingTimeMs));
        this.lastLogTimeMs = time.milliseconds();
    }

    @Override
    public void onEventProcessed(CoordinatorEvent event, long processingTimeMs) {
        long now;
        if (this.logEventCount <= 0) {
            return;
        }
        if (this.eventsMinHeap.size() < this.logEventCount || processingTimeMs > this.eventsMinHeap.peek().processingTimeMs) {
            this.eventsMinHeap.add(new EventAndProcessingTime((TopicPartition)event.key(), event.toString(), processingTimeMs));
        }
        if (this.eventsMinHeap.size() > this.logEventCount) {
            this.eventsMinHeap.poll();
        }
        if ((now = this.time.milliseconds()) - this.lastLogTimeMs >= (long)this.logIntervalMs) {
            this.logSlowEvents(now - this.lastLogTimeMs);
            this.lastLogTimeMs = now;
        }
    }

    private void logSlowEvents(long logIntervalMs) {
        ArrayList<EventAndProcessingTime> events = new ArrayList<EventAndProcessingTime>(this.eventsMinHeap.size());
        while (!this.eventsMinHeap.isEmpty()) {
            events.add(this.eventsMinHeap.poll());
        }
        StringBuilder stringBuilder = new StringBuilder(String.format("Top %d events with the longest processing times in the last %d ms:", events.size(), logIntervalMs));
        for (int i = events.size() - 1; i >= 0; --i) {
            EventAndProcessingTime event = (EventAndProcessingTime)events.get(i);
            stringBuilder.append(String.format("\n  %5d ms - %s %s", event.processingTimeMs, event.tp, event.name));
        }
        this.log.info(stringBuilder.toString());
    }

    private record EventAndProcessingTime(TopicPartition tp, String name, long processingTimeMs) {
    }
}

