/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authorizer.utils;

import io.confluent.security.authorizer.RequestContext;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.network.BrokerFqdnBuilder;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;

public class AuthorizerUtils {
    public static RequestContext newRequestContext(String source, KafkaPrincipal principal, String host) {
        return AuthorizerUtils.newRequestContext(source, principal, host, null, false);
    }

    public static RequestContext newRequestContext(final String source, final KafkaPrincipal principal, final String host, final String requestId, final boolean isProxyModeLocal) {
        return new RequestContext(){

            @Override
            public String requestId() {
                return requestId;
            }

            @Override
            public String requestSource() {
                return source;
            }

            public String listenerName() {
                return null;
            }

            public SecurityProtocol securityProtocol() {
                return null;
            }

            public KafkaPrincipal principal() {
                return principal;
            }

            public InetAddress clientAddress() {
                try {
                    return InetAddress.getByName(host);
                }
                catch (UnknownHostException e) {
                    throw new KafkaException((Throwable)e);
                }
            }

            public boolean isProxyModeLocal() {
                return isProxyModeLocal;
            }

            public BrokerFqdnBuilder.FQDNPropertiesFromPPV2 fqdnPropertiesFromPpv2() {
                return null;
            }

            public int requestType() {
                return -1;
            }

            public int requestVersion() {
                return -1;
            }

            public String clientId() {
                return null;
            }

            public int correlationId() {
                return -1;
            }
        };
    }

    public static RequestContext kafkaRequestContext(final AuthorizableRequestContext kafkaContext) {
        return new RequestContext(){

            @Override
            public String requestSource() {
                return "kafka";
            }

            public String listenerName() {
                return kafkaContext.listenerName();
            }

            public SecurityProtocol securityProtocol() {
                return kafkaContext.securityProtocol();
            }

            public KafkaPrincipal principal() {
                return kafkaContext.principal();
            }

            public InetAddress clientAddress() {
                return kafkaContext.clientAddress();
            }

            public boolean isProxyModeLocal() {
                return kafkaContext.isProxyModeLocal();
            }

            public BrokerFqdnBuilder.FQDNPropertiesFromPPV2 fqdnPropertiesFromPpv2() {
                return kafkaContext.fqdnPropertiesFromPpv2();
            }

            public int requestType() {
                return kafkaContext.requestType();
            }

            public int requestVersion() {
                return kafkaContext.requestVersion();
            }

            public String clientId() {
                return kafkaContext.clientId();
            }

            public int correlationId() {
                return kafkaContext.correlationId();
            }

            public long kafkaRequestId() {
                return kafkaContext.kafkaRequestId();
            }

            public long sessionId() {
                return kafkaContext.sessionId();
            }
        };
    }
}

