/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.util.Csv;

public class SocketServerConfigs {
    public static final String LISTENER_SECURITY_PROTOCOL_MAP_CONFIG = "listener.security.protocol.map";
    public static final String LISTENER_SECURITY_PROTOCOL_MAP_DEFAULT = Arrays.stream(SecurityProtocol.values()).collect(Collectors.toMap(ListenerName::forSecurityProtocol, sp -> sp)).entrySet().stream().map(entry -> ((ListenerName)entry.getKey()).value() + ":" + ((SecurityProtocol)entry.getValue()).name()).collect(Collectors.joining(","));
    public static final String LISTENER_SECURITY_PROTOCOL_MAP_DOC = "Map between listener names and security protocols. This must be defined for the same security protocol to be usable in more than one port or IP. For example, internal and external traffic can be separated even if SSL is required for both. Concretely, the user could define listeners with names INTERNAL and EXTERNAL and this property as: <code>INTERNAL:SSL,EXTERNAL:SSL</code>. As shown, key and value are separated by a colon and map entries are separated by commas. Each listener name should only appear once in the map. Different security (SSL and SASL) settings can be configured for each listener by adding a normalised prefix (the listener name is lowercased) to the config name. For example, to set a different keystore for the INTERNAL listener, a config with name <code>listener.name.internal.ssl.keystore.location</code> would be set. If the config for the listener name is not set, the config will fallback to the generic config (i.e. <code>ssl.keystore.location</code>). Note that in KRaft a default mapping from the listener names defined by <code>controller.listener.names</code> to PLAINTEXT is assumed if no explicit mapping is provided and no other security protocol is in use.";
    public static final String LISTENERS_CONFIG = "listeners";
    public static final String LISTENERS_DEFAULT = "PLAINTEXT://:9092";
    public static final String LISTENERS_DOC = String.format("Listener List - Comma-separated list of URIs we will listen on and the listener names. If the listener name is not a security protocol, <code>%s</code> must also be set.%n Listener names and port numbers must be unique unless one listener is an IPv4 address and the other listener is an IPv6 address (for the same port).%n Specify hostname as 0.0.0.0 to bind to all interfaces.%n Leave hostname empty to bind to default interface.%n Examples of legal listener lists:%n <code>PLAINTEXT://myhost:9092,SSL://:9091</code>%n <code>CLIENT://0.0.0.0:9092,REPLICATION://localhost:9093</code>%n <code>PLAINTEXT://127.0.0.1:9092,SSL://[::1]:9092</code>%n", "listener.security.protocol.map");
    public static final String ADVERTISED_LISTENERS_CONFIG = "advertised.listeners";
    public static final String ADVERTISED_LISTENERS_DOC = String.format("Specifies the listener addresses that the Kafka brokers will advertise to clients and other brokers. The config is useful where the actual listener configuration <code>%s</code> does not represent the addresses that clients should use to connect, such as in cloud environments. The addresses are published to and managed by the controller, the brokers pull these data from the controller as needed. In IaaS environments, this may need to be different from the interface to which the broker binds. If this is not set, the value for <code>%1$1s</code> will be used. Unlike <code>%1$1s</code>, it is not valid to advertise the 0.0.0.0 meta-address.%n Also unlike <code>%1$1s</code>, there can be duplicated ports in this property, so that one listener can be configured to advertise another listener's address. This can be useful in some cases where external load balancers are used.", "listeners");
    public static final String SOCKET_SEND_BUFFER_BYTES_CONFIG = "socket.send.buffer.bytes";
    public static final int SOCKET_SEND_BUFFER_BYTES_DEFAULT = 102400;
    public static final String SOCKET_SEND_BUFFER_BYTES_DOC = "The SO_SNDBUF buffer of the socket server sockets. If the value is -1, the OS default will be used.";
    public static final String SOCKET_RECEIVE_BUFFER_BYTES_CONFIG = "socket.receive.buffer.bytes";
    public static final int SOCKET_RECEIVE_BUFFER_BYTES_DEFAULT = 102400;
    public static final String SOCKET_RECEIVE_BUFFER_BYTES_DOC = "The SO_RCVBUF buffer of the socket server sockets. If the value is -1, the OS default will be used.";
    public static final String SOCKET_REQUEST_MAX_BYTES_CONFIG = "socket.request.max.bytes";
    public static final int SOCKET_REQUEST_MAX_BYTES_DEFAULT = 0x6400000;
    public static final String SOCKET_REQUEST_MAX_BYTES_DOC = "The maximum number of bytes in a socket request";
    public static final String SOCKET_LISTEN_BACKLOG_SIZE_CONFIG = "socket.listen.backlog.size";
    public static final int SOCKET_LISTEN_BACKLOG_SIZE_DEFAULT = 50;
    public static final String SOCKET_LISTEN_BACKLOG_SIZE_DOC = "The maximum number of pending connections on the socket. In Linux, you may also need to configure <code>somaxconn</code> and <code>tcp_max_syn_backlog</code> kernel parameters accordingly to make the configuration takes effect.";
    public static final String MAX_CONNECTIONS_PER_IP_OVERRIDES_CONFIG = "max.connections.per.ip.overrides";
    public static final String MAX_CONNECTIONS_PER_IP_OVERRIDES_DEFAULT = "";
    public static final String MAX_CONNECTIONS_PER_IP_OVERRIDES_DOC = "A comma-separated list of per-ip or hostname overrides to the default maximum number of connections. An example value is \"hostName:100,127.0.0.1:200\"";
    public static final String MAX_CONNECTIONS_PER_IP_CONFIG = "max.connections.per.ip";
    public static final int MAX_CONNECTIONS_PER_IP_DEFAULT = Integer.MAX_VALUE;
    public static final String MAX_CONNECTIONS_PER_IP_DOC = "The maximum number of connections we allow from each ip address. This can be set to 0 if there are overrides " + String.format("configured using %s property. New connections from the ip address are dropped if the limit is reached.", "max.connections.per.ip.overrides");
    public static final String MAX_CONNECTIONS_CONFIG = "max.connections";
    public static final int MAX_CONNECTIONS_DEFAULT = Integer.MAX_VALUE;
    public static final String MAX_CONNECTIONS_DOC = String.format("The maximum number of connections we allow in the broker at any time. This limit is applied in addition to any per-ip limits configured using %s. Listener-level limits may also be configured by prefixing the config name with the listener prefix, for example, <code>listener.name.internal.%1$1s</code>. Broker-wide limit should be configured based on broker capacity while listener limits should be configured based on application requirements. New connections are blocked if either the listener or broker limit is reached. Connections on the inter-broker listener are permitted even if broker-wide limit is reached. The least recently used connection on another listener will be closed in this case.", "max.connections.per.ip");
    public static final String MAX_CONNECTION_CREATION_RATE_CONFIG = "max.connection.creation.rate";
    public static final double MAX_CONNECTION_CREATION_RATE_DEFAULT = Double.MAX_VALUE;
    public static final String MAX_CONNECTION_CREATION_RATE_DOC = "The maximum connection creation rate we allow in the broker at any time. Listener-level limits " + String.format("may also be configured by prefixing the config name with the listener prefix, for example, <code>listener.name.internal.%s</code>.", "max.connection.creation.rate") + "Broker-wide connection rate limit should be configured based on broker capacity while listener limits should be configured based on application requirements. New connections will be throttled if either the listener or the broker limit is reached, with the exception of inter-broker listener. Connections on the inter-broker listener will be throttled only when the listener-level rate limit is reached.";
    public static final String CONNECTIONS_MAX_IDLE_MS_CONFIG = "connections.max.idle.ms";
    public static final long CONNECTIONS_MAX_IDLE_MS_DEFAULT = 600000L;
    public static final String CONNECTIONS_MAX_IDLE_MS_DOC = "Idle connections timeout: the server socket processor threads close the connections that idle more than this";
    public static final String FAILED_AUTHENTICATION_DELAY_MS_CONFIG = "connection.failed.authentication.delay.ms";
    public static final int FAILED_AUTHENTICATION_DELAY_MS_DEFAULT = 100;
    public static final String FAILED_AUTHENTICATION_DELAY_MS_DOC = "Connection close delay on failed authentication: this is the time (in milliseconds) by which connection close will be delayed on authentication failure. " + String.format("This must be configured to be less than %s to prevent connection timeout.", "connections.max.idle.ms");
    public static final String QUEUED_MAX_REQUESTS_CONFIG = "queued.max.requests";
    public static final int QUEUED_MAX_REQUESTS_DEFAULT = 500;
    public static final String QUEUED_MAX_REQUESTS_DOC = "The number of queued requests allowed for data-plane, before blocking the network threads";
    public static final String QUEUED_MAX_BYTES_CONFIG = "queued.max.request.bytes";
    public static final int QUEUED_MAX_REQUEST_BYTES_DEFAULT = -1;
    public static final String QUEUED_MAX_REQUEST_BYTES_DOC = "The number of queued bytes allowed before no more requests are read";
    public static final String NUM_NETWORK_THREADS_CONFIG = "num.network.threads";
    public static final int NUM_NETWORK_THREADS_DEFAULT = 3;
    public static final String NUM_NETWORK_THREADS_DOC = "The number of threads that the server uses for receiving requests from the network and sending responses to the network. Noted: each listener (except for controller listener) creates its own thread pool.";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("listeners", ConfigDef.Type.STRING, (Object)"PLAINTEXT://:9092", ConfigDef.Importance.HIGH, LISTENERS_DOC).define("advertised.listeners", ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, ADVERTISED_LISTENERS_DOC).define("listener.security.protocol.map", ConfigDef.Type.STRING, (Object)LISTENER_SECURITY_PROTOCOL_MAP_DEFAULT, ConfigDef.Importance.LOW, "Map between listener names and security protocols. This must be defined for the same security protocol to be usable in more than one port or IP. For example, internal and external traffic can be separated even if SSL is required for both. Concretely, the user could define listeners with names INTERNAL and EXTERNAL and this property as: <code>INTERNAL:SSL,EXTERNAL:SSL</code>. As shown, key and value are separated by a colon and map entries are separated by commas. Each listener name should only appear once in the map. Different security (SSL and SASL) settings can be configured for each listener by adding a normalised prefix (the listener name is lowercased) to the config name. For example, to set a different keystore for the INTERNAL listener, a config with name <code>listener.name.internal.ssl.keystore.location</code> would be set. If the config for the listener name is not set, the config will fallback to the generic config (i.e. <code>ssl.keystore.location</code>). Note that in KRaft a default mapping from the listener names defined by <code>controller.listener.names</code> to PLAINTEXT is assumed if no explicit mapping is provided and no other security protocol is in use.").define("socket.send.buffer.bytes", ConfigDef.Type.INT, (Object)102400, ConfigDef.Importance.HIGH, "The SO_SNDBUF buffer of the socket server sockets. If the value is -1, the OS default will be used.").define("socket.receive.buffer.bytes", ConfigDef.Type.INT, (Object)102400, ConfigDef.Importance.HIGH, "The SO_RCVBUF buffer of the socket server sockets. If the value is -1, the OS default will be used.").define("socket.request.max.bytes", ConfigDef.Type.INT, (Object)0x6400000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "The maximum number of bytes in a socket request").define("socket.listen.backlog.size", ConfigDef.Type.INT, (Object)50, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The maximum number of pending connections on the socket. In Linux, you may also need to configure <code>somaxconn</code> and <code>tcp_max_syn_backlog</code> kernel parameters accordingly to make the configuration takes effect.").define("max.connections.per.ip", ConfigDef.Type.INT, (Object)Integer.MAX_VALUE, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, MAX_CONNECTIONS_PER_IP_DOC).define("max.connections.per.ip.overrides", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, "A comma-separated list of per-ip or hostname overrides to the default maximum number of connections. An example value is \"hostName:100,127.0.0.1:200\"").define("max.connections", ConfigDef.Type.INT, (Object)Integer.MAX_VALUE, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, MAX_CONNECTIONS_DOC).define("max.connection.creation.rate", ConfigDef.Type.DOUBLE, (Object)Double.MAX_VALUE, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, MAX_CONNECTION_CREATION_RATE_DOC).define("connections.max.idle.ms", ConfigDef.Type.LONG, (Object)600000L, ConfigDef.Importance.MEDIUM, "Idle connections timeout: the server socket processor threads close the connections that idle more than this").define("connection.failed.authentication.delay.ms", ConfigDef.Type.INT, (Object)100, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, FAILED_AUTHENTICATION_DELAY_MS_DOC).define("queued.max.requests", ConfigDef.Type.INT, (Object)500, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "The number of queued requests allowed for data-plane, before blocking the network threads").define("queued.max.request.bytes", ConfigDef.Type.LONG, (Object)-1, ConfigDef.Importance.MEDIUM, "The number of queued bytes allowed before no more requests are read").define("num.network.threads", ConfigDef.Type.INT, (Object)3, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "The number of threads that the server uses for receiving requests from the network and sending responses to the network. Noted: each listener (except for controller listener) creates its own thread pool.");
    private static final Pattern URI_PARSE_REGEXP = Pattern.compile("^(.*)://\\[?([0-9a-zA-Z\\-%._:]*)\\]?:(-?[0-9]+)");
    public static final Map<ListenerName, SecurityProtocol> DEFAULT_NAME_TO_SECURITY_PROTO;

    public static List<Endpoint> listenerListToEndPoints(String input, Map<ListenerName, SecurityProtocol> nameToSecurityProto) {
        return SocketServerConfigs.listenerListToEndPoints(input, (ListenerName n) -> {
            SecurityProtocol result = (SecurityProtocol)nameToSecurityProto.get(n);
            if (result == null) {
                throw new IllegalArgumentException("No security protocol defined for listener " + n.value());
            }
            return result;
        });
    }

    public static List<Endpoint> listenerListToEndPoints(String input, Function<ListenerName, SecurityProtocol> nameToSecurityProto) {
        ArrayList<Endpoint> results = new ArrayList<Endpoint>();
        for (String entry : Csv.parseCsvList((String)input.trim())) {
            Matcher matcher = URI_PARSE_REGEXP.matcher(entry);
            if (!matcher.matches()) {
                throw new KafkaException("Unable to parse " + entry + " to a broker endpoint");
            }
            ListenerName listenerName = ListenerName.normalised((String)matcher.group(1));
            String host = matcher.group(2);
            if (host.isEmpty()) {
                host = null;
            }
            String portString = matcher.group(3);
            int port = Integer.parseInt(portString);
            SecurityProtocol securityProtocol = nameToSecurityProto.apply(listenerName);
            results.add(new Endpoint(listenerName.value(), securityProtocol, host, port));
        }
        return results;
    }

    static {
        HashMap<ListenerName, SecurityProtocol> nameToSecurityProtocol = new HashMap<ListenerName, SecurityProtocol>();
        for (SecurityProtocol securityProtocol : SecurityProtocol.values()) {
            nameToSecurityProtocol.put(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol);
        }
        DEFAULT_NAME_TO_SECURITY_PROTO = Collections.unmodifiableMap(nameToSecurityProtocol);
    }
}

