/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.AesCbcSpi;
import com.amazon.corretto.crypto.provider.AesXtsSpi;
import com.amazon.corretto.crypto.provider.ConcatenationKdfSpi;
import com.amazon.corretto.crypto.provider.CounterKdfSpi;
import com.amazon.corretto.crypto.provider.DebugFlag;
import com.amazon.corretto.crypto.provider.EvpHmac;
import com.amazon.corretto.crypto.provider.EvpKey;
import com.amazon.corretto.crypto.provider.EvpKeyFactory;
import com.amazon.corretto.crypto.provider.EvpKeyType;
import com.amazon.corretto.crypto.provider.ExtraCheck;
import com.amazon.corretto.crypto.provider.HkdfSecretKeyFactorySpi;
import com.amazon.corretto.crypto.provider.LibCryptoRng;
import com.amazon.corretto.crypto.provider.Loader;
import com.amazon.corretto.crypto.provider.RuntimeCryptoException;
import com.amazon.corretto.crypto.provider.SecretKeyGenerator;
import com.amazon.corretto.crypto.provider.SelfTestStatus;
import com.amazon.corretto.crypto.provider.SelfTestSuite;
import com.amazon.corretto.crypto.provider.Utils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.crypto.CipherSpi;

public final class AmazonCorrettoCryptoProvider
extends Provider {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final String PACKAGE_PREFIX = "com.amazon.corretto.crypto.provider.";
    private static final String PROPERTY_CACHE_SELF_TEST_RESULTS = "cacheselftestresults";
    private static final String PROPERTY_REGISTER_EC_PARAMS = "registerEcParams";
    private static final String PROPERTY_REGISTER_SECURE_RANDOM = "registerSecureRandom";
    private static final String PROPERTY_REGISTER_ED_KEYFACTORY = "registerEdKeyFactory";
    private static final long serialVersionUID = 1L;
    public static final AmazonCorrettoCryptoProvider INSTANCE;
    public static final String PROVIDER_NAME = "AmazonCorrettoCryptoProvider";
    private final EnumSet<ExtraCheck> extraChecks = EnumSet.noneOf(ExtraCheck.class);
    private final boolean relyOnCachedSelfTestResults;
    private final boolean shouldRegisterEcParams;
    private final boolean shouldRegisterSecureRandom;
    private final boolean shouldRegisterEdDSA;
    private final boolean shouldRegisterEdKeyFactory;
    private final boolean shouldRegisterMLDSA;
    private final Utils.NativeContextReleaseStrategy nativeContextReleaseStrategy;
    private transient SelfTestSuite selfTestSuite = new SelfTestSuite();
    private volatile transient KeyFactory rsaFactory;
    private volatile transient KeyFactory ecFactory;
    private volatile transient KeyFactory edFactory;
    private volatile transient KeyFactory mlDsaFactory;

    private void buildServiceMap() {
        this.addService("MessageDigest", "SHA-512", "SHA512Spi");
        this.addService("MessageDigest", "SHA-384", "SHA384Spi");
        this.addService("MessageDigest", "SHA-256", "SHA256Spi");
        this.addService("MessageDigest", "SHA-1", "SHA1Spi");
        this.addService("MessageDigest", "MD5", "MD5Spi");
        this.addService("Cipher", "AES/GCM/NoPadding", "AesGcmSpi");
        this.addService("Cipher", "AES_128/GCM/NoPadding", "AesGcmSpi");
        this.addService("Cipher", "AES_256/GCM/NoPadding", "AesGcmSpi");
        this.addService("Cipher", "AES/KWP/NoPadding", "AesKeyWrapPaddingSpi", null, "AesWrapPad");
        this.addService("KeyFactory", "RSA", "EvpKeyFactory$RSA");
        this.addService("KeyFactory", "EC", "EvpKeyFactory$EC");
        if (this.shouldRegisterMLDSA) {
            this.addService("KeyFactory", "ML-DSA", "EvpKeyFactory$MLDSA");
            this.addService("KeyFactory", "ML-DSA-44", "EvpKeyFactory$MLDSA");
            this.addService("KeyFactory", "ML-DSA-65", "EvpKeyFactory$MLDSA");
            this.addService("KeyFactory", "ML-DSA-87", "EvpKeyFactory$MLDSA");
        }
        if (this.shouldRegisterEdDSA) {
            if (this.shouldRegisterEdKeyFactory) {
                this.addService("KeyFactory", "EdDSA", "EvpKeyFactory$EdDSA");
                this.addService("KeyFactory", "Ed25519", "EvpKeyFactory$EdDSA");
            }
            this.addService("KeyPairGenerator", "EdDSA", "EdGen");
            this.addService("KeyPairGenerator", "Ed25519", "EdGen");
        }
        this.addService("SecretKeyFactory", "HkdfWithHmacSHA1", "HkdfSecretKeyFactorySpi", false);
        this.addService("SecretKeyFactory", "HkdfWithHmacSHA256", "HkdfSecretKeyFactorySpi", false);
        this.addService("SecretKeyFactory", "HkdfWithHmacSHA384", "HkdfSecretKeyFactorySpi", false);
        this.addService("SecretKeyFactory", "HkdfWithHmacSHA512", "HkdfSecretKeyFactorySpi", false);
        this.addService("SecretKeyFactory", "ConcatenationKdfWithSHA256", "ConcatenationKdfSpi", false);
        this.addService("SecretKeyFactory", "ConcatenationKdfWithSHA384", "ConcatenationKdfSpi", false);
        this.addService("SecretKeyFactory", "ConcatenationKdfWithSHA512", "ConcatenationKdfSpi", false);
        this.addService("SecretKeyFactory", "ConcatenationKdfWithHmacSHA256", "ConcatenationKdfSpi", false);
        this.addService("SecretKeyFactory", "ConcatenationKdfWithHmacSHA512", "ConcatenationKdfSpi", false);
        this.addService("SecretKeyFactory", "CounterKdfWithHmacSHA256", "CounterKdfSpi", false);
        this.addService("SecretKeyFactory", "CounterKdfWithHmacSHA384", "CounterKdfSpi", false);
        this.addService("SecretKeyFactory", "CounterKdfWithHmacSHA512", "CounterKdfSpi", false);
        this.addService("KeyPairGenerator", "RSA", "RsaGen");
        this.addService("KeyPairGenerator", "EC", "EcGen");
        if (this.shouldRegisterMLDSA) {
            this.addService("KeyPairGenerator", "ML-DSA", "MlDsaGen$MlDsaGen44");
            this.addService("KeyPairGenerator", "ML-DSA-44", "MlDsaGen$MlDsaGen44");
            this.addService("KeyPairGenerator", "ML-DSA-65", "MlDsaGen$MlDsaGen65");
            this.addService("KeyPairGenerator", "ML-DSA-87", "MlDsaGen$MlDsaGen87");
        }
        this.addService("KeyGenerator", "AES", "SecretKeyGenerator", false);
        this.addService("Cipher", "AES/XTS/NoPadding", "AesXtsSpi", false);
        this.addService("Cipher", "AES", "AesCbcSpi", false, Collections.singletonMap("SupportedModes", "CBC"), "AES_128", "AES_192", "AES_256");
        this.addService("Cipher", "RSA/ECB/NoPadding", "RsaCipher$NoPadding");
        this.addService("Cipher", "RSA/ECB/Pkcs1Padding", "RsaCipher$Pkcs1");
        this.addService("Cipher", "RSA/ECB/OAEPPadding", "RsaCipher$OAEP");
        this.addService("Cipher", "RSA/ECB/OAEPWithSHA-1AndMGF1Padding", "RsaCipher$OAEPSha1");
        this.addService("Cipher", "RSA/ECB/OAEPWithSHA1AndMGF1Padding", "RsaCipher$OAEPSha1");
        for (String string : new String[]{"MD5", "SHA1", "SHA256", "SHA384", "SHA512"}) {
            this.addService("Mac", "Hmac" + string, "EvpHmac$" + string);
        }
        this.addService("KeyAgreement", "ECDH", "EvpKeyAgreement$ECDH", Collections.singletonMap("SupportedKeyClasses", "java.security.interfaces.ECPublicKey|java.security.interfaces.ECPrivateKey"), new String[0]);
        if (this.shouldRegisterEcParams) {
            this.registerEcParams();
        }
        if (this.shouldRegisterSecureRandom) {
            this.addService("SecureRandom", "LibCryptoRng", "LibCryptoRng$SPI", Collections.singletonMap("ThreadSafe", "true"), "DEFAULT").setSelfTest(LibCryptoRng.SPI.SELF_TEST);
        }
        this.addSignatures();
    }

    private void addSignatures() {
        List<String> list = Arrays.asList("RSA", "ECDSA");
        List<String> list2 = Arrays.asList("SHA1", "SHA224", "SHA256", "SHA384", "SHA512");
        for (String string : list) {
            for (String string2 : list2) {
                String string3 = String.format("%swith%s", string2, string);
                String string4 = String.format("EvpSignature$%s", string3);
                this.addService("Signature", string3, string4);
                if (!string.equals("ECDSA")) continue;
                this.addService("Signature", string3 + "inP1363Format", string4);
            }
        }
        this.addService("Signature", "RSASSA-PSS", "EvpSignature$RSASSA_PSS");
        this.addService("Signature", "NONEwithECDSA", "EvpSignatureRaw$NONEwithECDSA");
        if (this.shouldRegisterEdDSA) {
            this.addService("Signature", "EdDSA", "EvpSignatureRaw$Ed25519");
            this.addService("Signature", "Ed25519", "EvpSignatureRaw$Ed25519");
            this.addService("Signature", "Ed25519ph", "EvpSignature$Ed25519ph");
        }
        if (this.shouldRegisterMLDSA) {
            this.addService("Signature", "ML-DSA", "EvpSignatureRaw$MLDSA");
            this.addService("Signature", "ML-DSA-ExtMu", "EvpSignatureRaw$MLDSAExtMu");
        }
    }

    private ACCPService addService(String string, String string2, String string3) {
        return this.addService(string, string2, string3, true, null, new String[0]);
    }

    private ACCPService addService(String string, String string2, String string3, boolean bl) {
        return this.addService(string, string2, string3, bl, null, new String[0]);
    }

    private ACCPService addService(String string, String string2, String string3, Map<String, String> map, String ... stringArray) {
        return this.addService(string, string2, string3, true, map, stringArray);
    }

    private ACCPService addService(String string, String string2, String string3, boolean bl, Map<String, String> map, String ... stringArray) {
        ACCPService aCCPService = new ACCPService(string, string2, string3, bl, Arrays.asList(stringArray), map);
        this.putService(aCCPService);
        return aCCPService;
    }

    private void resetAllSelfTests() {
        this.selfTestSuite.resetAllSelfTests();
    }

    public AmazonCorrettoCryptoProvider() {
        super(PROVIDER_NAME, Loader.PROVIDER_VERSION, String.format("%s %s%s%s (%s)", PROVIDER_NAME, Loader.PROVIDER_VERSION_STR, Loader.FIPS_BUILD ? "+FIPS" : "", Loader.EXPERIMENTAL_FIPS_BUILD ? "+EXP" : "", Loader.AWS_LC_VERSION_STR));
        this.relyOnCachedSelfTestResults = Utils.getBooleanProperty(PROPERTY_CACHE_SELF_TEST_RESULTS, true);
        this.shouldRegisterEcParams = Utils.getBooleanProperty(PROPERTY_REGISTER_EC_PARAMS, false);
        this.shouldRegisterSecureRandom = Utils.getBooleanProperty(PROPERTY_REGISTER_SECURE_RANDOM, true);
        this.shouldRegisterEdDSA = Utils.getJavaVersion() >= 15;
        this.shouldRegisterEdKeyFactory = Utils.getBooleanProperty(PROPERTY_REGISTER_ED_KEYFACTORY, false);
        this.shouldRegisterMLDSA = !this.isFips() || this.isExperimentalFips();
        this.nativeContextReleaseStrategy = Utils.getNativeContextReleaseStrategyProperty();
        Utils.optionsFromProperty(ExtraCheck.class, this.extraChecks, "extrachecks");
        if (!Loader.IS_AVAILABLE) {
            if (DebugFlag.VERBOSELOGS.isEnabled()) {
                Logger.getLogger(PROVIDER_NAME).fine("Native JCE libraries are unavailable - disabling");
            }
            return;
        }
        this.buildServiceMap();
        this.initializeSelfTests();
    }

    Utils.NativeContextReleaseStrategy getNativeContextReleaseStrategy() {
        return this.nativeContextReleaseStrategy;
    }

    private synchronized void initializeSelfTests() {
        if (this.selfTestSuite == null) {
            this.selfTestSuite = new SelfTestSuite();
        }
        if (!Loader.IS_AVAILABLE) {
            return;
        }
        this.selfTestSuite.addSelfTest(SelfTestSuite.AWS_LC_SELF_TESTS);
        this.selfTestSuite.addSelfTest(LibCryptoRng.SPI.SELF_TEST);
        this.selfTestSuite.addSelfTest(EvpHmac.SHA512.SELF_TEST);
        this.selfTestSuite.addSelfTest(EvpHmac.SHA384.SELF_TEST);
        this.selfTestSuite.addSelfTest(EvpHmac.SHA256.SELF_TEST);
        this.selfTestSuite.addSelfTest(EvpHmac.SHA1.SELF_TEST);
        this.selfTestSuite.addSelfTest(EvpHmac.MD5.SELF_TEST);
        ForkJoinPool.commonPool().submit(this.selfTestSuite::runTests);
    }

    @Override
    public String getVersionStr() {
        return Loader.PROVIDER_VERSION_STR;
    }

    public String getAwsLcVersionStr() {
        return Loader.AWS_LC_VERSION_STR;
    }

    public static void install() {
        Security.insertProviderAt(INSTANCE, 1);
    }

    public SelfTestStatus getSelfTestStatus() {
        return this.selfTestSuite.getOverallStatus();
    }

    public SelfTestStatus runSelfTests() {
        if (!this.relyOnCachedSelfTestResults) {
            this.resetAllSelfTests();
        }
        return this.selfTestSuite.runTests();
    }

    public Throwable getLoadingError() {
        return Loader.LOADING_ERROR;
    }

    public void assertHealthy() throws RuntimeCryptoException {
        if (Loader.LOADING_ERROR != null) {
            throw new RuntimeCryptoException("Unable to load native library", Loader.LOADING_ERROR);
        }
        if (!this.relyOnCachedSelfTestResults) {
            this.resetAllSelfTests();
        }
        this.selfTestSuite.assertAllTestsPassed();
    }

    public boolean isFips() {
        return Loader.FIPS_BUILD;
    }

    public boolean isExperimentalFips() {
        return Loader.EXPERIMENTAL_FIPS_BUILD;
    }

    public void registerEcParams() {
        this.addService("AlgorithmParameters", "EC", "EcParameters");
    }

    @Override
    public synchronized boolean equals(Object object) {
        return this == object;
    }

    @Override
    public synchronized int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public String toString() {
        return super.toString() + (this.isFips() ? " (FIPS)" : "");
    }

    public Set<ExtraCheck> getExtraChecks() {
        return Collections.unmodifiableSet(this.extraChecks);
    }

    public boolean hasExtraCheck(ExtraCheck extraCheck) {
        return this.extraChecks.contains((Object)extraCheck);
    }

    public void addExtraChecks(ExtraCheck ... extraCheckArray) {
        this.extraChecks.addAll(Arrays.asList(extraCheckArray));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.readObjectNoData();
    }

    private void readObjectNoData() {
        this.initializeSelfTests();
    }

    KeyFactory getKeyFactory(EvpKeyType evpKeyType) {
        try {
            switch (evpKeyType) {
                case RSA: {
                    if (this.rsaFactory == null) {
                        this.rsaFactory = KeyFactory.getInstance(evpKeyType.jceName, this);
                    }
                    return this.rsaFactory;
                }
                case EC: {
                    if (this.ecFactory == null) {
                        this.ecFactory = KeyFactory.getInstance(evpKeyType.jceName, this);
                    }
                    return this.ecFactory;
                }
                case EdDSA: {
                    if (this.edFactory == null) {
                        this.edFactory = new EdKeyFactory(this);
                    }
                    return this.edFactory;
                }
                case MLDSA: {
                    if (this.mlDsaFactory == null) {
                        this.mlDsaFactory = KeyFactory.getInstance(evpKeyType.jceName, this);
                    }
                    return this.mlDsaFactory;
                }
            }
            throw new AssertionError((Object)String.format("Unsupported key type: %s", evpKeyType.jceName));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError((Object)noSuchAlgorithmException);
        }
    }

    KeyFactory getKeyFactory(String string) {
        return this.getKeyFactory(EvpKeyType.valueOf(string));
    }

    EvpKey translateKey(Key key, EvpKeyType evpKeyType) throws InvalidKeyException {
        if (key instanceof EvpKey) {
            return (EvpKey)key;
        }
        return (EvpKey)this.getKeyFactory(evpKeyType).translateKey(key);
    }

    static {
        if (!Loader.IS_AVAILABLE && DebugFlag.VERBOSELOGS.isEnabled()) {
            Logger.getLogger(PROVIDER_NAME).fine("Native JCE libraries are unavailable - disabling");
        }
        INSTANCE = new AmazonCorrettoCryptoProvider();
    }

    private static class EdKeyFactory
    extends KeyFactory {
        EdKeyFactory(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(new EvpKeyFactory.EdDSA(amazonCorrettoCryptoProvider), amazonCorrettoCryptoProvider, "Ed25519");
        }
    }

    private class ACCPService
    extends Provider.Service {
        private final boolean useReflection;
        private final MethodHandle ctor;
        private final MethodHandle algorithmSetter;
        private boolean failMessagePrinted;
        private volatile boolean testsPassed;
        private Supplier<SelfTestStatus> getTestStatus;

        public ACCPService(String string, String string2, String string3, boolean bl, List<String> list, Map<String, String> map) {
            super(AmazonCorrettoCryptoProvider.this, string, string2, AmazonCorrettoCryptoProvider.PACKAGE_PREFIX + string3, list, map);
            this.failMessagePrinted = false;
            this.testsPassed = false;
            this.getTestStatus = AmazonCorrettoCryptoProvider.this.selfTestSuite::runTests;
            this.useReflection = bl;
            if (!bl) {
                this.ctor = null;
                this.algorithmSetter = null;
                return;
            }
            try {
                MethodHandle methodHandle;
                block7: {
                    MethodHandle methodHandle2;
                    Class<?> clazz = AmazonCorrettoCryptoProvider.class.getClassLoader().loadClass(AmazonCorrettoCryptoProvider.PACKAGE_PREFIX + string3);
                    try {
                        methodHandle2 = LOOKUP.findConstructor(clazz, MethodType.methodType(Void.TYPE)).asType(MethodType.methodType(Object.class));
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        methodHandle2 = LOOKUP.findConstructor(clazz, MethodType.methodType(Void.TYPE, AmazonCorrettoCryptoProvider.class)).asType(MethodType.methodType(Object.class, AmazonCorrettoCryptoProvider.class)).bindTo(AmazonCorrettoCryptoProvider.this);
                    }
                    this.ctor = methodHandle2;
                    methodHandle = null;
                    MethodType methodType = MethodType.methodType(Void.TYPE, String.class);
                    try {
                        methodHandle = LOOKUP.findVirtual(clazz, "setAlgorithmName", methodType);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        if (!string.equals("Signature")) break block7;
                        throw noSuchMethodException;
                    }
                }
                this.algorithmSetter = methodHandle;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public Object newInstance(Object object) throws NoSuchAlgorithmException {
            if (object != null) {
                throw new NoSuchAlgorithmException("Constructor parameters not used with " + this.getType() + "/" + this.getAlgorithm());
            }
            if (!this.testsPassed) {
                this.checkTests();
            }
            if (!this.useReflection) {
                String string = this.getType();
                String string2 = this.getAlgorithm();
                if ("SecretKeyFactory".equalsIgnoreCase(string)) {
                    HkdfSecretKeyFactorySpi hkdfSecretKeyFactorySpi = HkdfSecretKeyFactorySpi.INSTANCES.get(HkdfSecretKeyFactorySpi.getSpiFactoryForAlgName(string2));
                    if (hkdfSecretKeyFactorySpi != null) {
                        return hkdfSecretKeyFactorySpi;
                    }
                    ConcatenationKdfSpi concatenationKdfSpi = ConcatenationKdfSpi.INSTANCES.get(ConcatenationKdfSpi.getSpiFactoryForAlgName(string2));
                    if (concatenationKdfSpi != null) {
                        return concatenationKdfSpi;
                    }
                    CounterKdfSpi counterKdfSpi = CounterKdfSpi.INSTANCES.get(CounterKdfSpi.getSpiFactoryForAlgName(string2));
                    if (counterKdfSpi != null) {
                        return counterKdfSpi;
                    }
                }
                if ("KeyGenerator".equalsIgnoreCase(string) && "AES".equalsIgnoreCase(string2)) {
                    return SecretKeyGenerator.createAesKeyGeneratorSpi();
                }
                if ("Cipher".equalsIgnoreCase(string)) {
                    return this.getCipherSpiInstance(string2);
                }
                throw new NoSuchAlgorithmException(String.format("No service class for %s/%s", string, string2));
            }
            try {
                Object object2 = this.ctor.invokeExact();
                if (this.algorithmSetter != null) {
                    this.algorithmSetter.invoke(object2, this.getAlgorithm());
                }
                return object2;
            }
            catch (Error | RuntimeException throwable) {
                throw throwable;
            }
            catch (Throwable throwable) {
                throw new NoSuchAlgorithmException("Unexpected error constructing algorithm", throwable);
            }
        }

        private CipherSpi getCipherSpiInstance(String string) throws NoSuchAlgorithmException {
            boolean bl;
            boolean bl2 = bl = AmazonCorrettoCryptoProvider.this.nativeContextReleaseStrategy == Utils.NativeContextReleaseStrategy.LAZY;
            if ("AES/XTS/NoPadding".equalsIgnoreCase(string)) {
                return new AesXtsSpi();
            }
            if (AesCbcSpi.AES_CBC_PKCS7_PADDING_NAMES.contains(string.toLowerCase())) {
                return new AesCbcSpi(AesCbcSpi.Padding.PKCS7, bl);
            }
            if (AesCbcSpi.AES_CBC_ISO10126_PADDING_NAMES.contains(string.toLowerCase())) {
                return new AesCbcSpi(AesCbcSpi.Padding.ISO10126, bl);
            }
            if (string.toUpperCase().startsWith("AES")) {
                return new AesCbcSpi(AesCbcSpi.Padding.NONE, bl);
            }
            throw new NoSuchAlgorithmException(String.format("No service class for Cipher/%s", string));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkTests() throws NoSuchAlgorithmException {
            if (this.inJarValidation() && !this.getType().equals("SecureRandom")) {
                throw new NoSuchAlgorithmException("Can't use ACCP before JAR validation completes");
            }
            SelfTestStatus selfTestStatus = this.getTestStatus.get();
            switch (selfTestStatus) {
                case RECURSIVELY_INVOKED: {
                    throw new NoSuchAlgorithmException("Algorithm unavailable until self tests complete");
                }
                case FAILED: {
                    ACCPService aCCPService = this;
                    synchronized (aCCPService) {
                        if (!this.failMessagePrinted) {
                            Logger.getLogger(AmazonCorrettoCryptoProvider.PROVIDER_NAME).severe("Self tests failed - disabling. Detailed results: " + AmazonCorrettoCryptoProvider.this.selfTestSuite.getAllTestResults().toString());
                            this.failMessagePrinted = true;
                        }
                    }
                    throw new NoSuchAlgorithmException("Self-tests failed");
                }
                case NOT_RUN: {
                    throw new NoSuchAlgorithmException("Internal error: self tests not run");
                }
                case PASSED: {
                    this.testsPassed = true;
                }
            }
        }

        private boolean inJarValidation() {
            StackTraceElement[] stackTraceElementArray;
            for (StackTraceElement stackTraceElement : stackTraceElementArray = Thread.currentThread().getStackTrace()) {
                if (!stackTraceElement.getClassName().equals("javax.crypto.JarVerifier")) continue;
                return true;
            }
            return false;
        }

        public void setSelfTest(SelfTestSuite.SelfTest selfTest) {
            this.getTestStatus = () -> selfTest.runTest().getStatus();
        }
    }
}

