/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.NativeResource;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.spec.ECField;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class EcUtils {
    private static final BigInteger MAX_COFACTOR = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final Pattern NIST_CURVE_PATTERN = Pattern.compile("(?:NIST )?(.)-(\\d+)");
    private static final ConcurrentHashMap<String, ECInfo> EC_INFO_CACHE = new ConcurrentHashMap();
    private static final Function<String, ECInfo> EC_INFO_LOADER = new Function<String, ECInfo>(){

        @Override
        public ECInfo apply(String string) {
            int[] nArray = new int[1];
            byte[] byArray = new byte[128];
            byte[] byArray2 = new byte[128];
            byte[] byArray3 = new byte[128];
            byte[] byArray4 = new byte[128];
            byte[] byArray5 = new byte[128];
            byte[] byArray6 = new byte[128];
            byte[] byArray7 = new byte[128];
            byte[] byArray8 = new byte[128];
            byte[] byArray9 = new byte[128];
            int n = EcUtils.curveNameToInfo(this.normalizeName(string), nArray, byArray, byArray2, byArray3, byArray4, byArray5, byArray6, byArray7, byArray8, byArray9);
            if (n == 0) {
                throw new IllegalArgumentException("Invalid curve name: " + string);
            }
            BigInteger bigInteger = new BigInteger(byArray4);
            if (bigInteger.compareTo(MAX_COFACTOR) > 0) {
                throw new IllegalArgumentException("Requested curve has a cofactor which is too large. Curve: " + string + " cofactor " + bigInteger);
            }
            ECField eCField = nArray[0] != 0 ? new ECFieldF2m(nArray[0], new BigInteger(byArray)) : new ECFieldFp(new BigInteger(byArray));
            EllipticCurve ellipticCurve = new EllipticCurve(eCField, new BigInteger(byArray2), new BigInteger(byArray3));
            ECPoint eCPoint = new ECPoint(new BigInteger(byArray5), new BigInteger(byArray6));
            ECParameterSpec eCParameterSpec = new ECParameterSpec(ellipticCurve, eCPoint, new BigInteger(byArray7), bigInteger.intValue());
            return new ECInfo(string, eCParameterSpec, n, new String(this.trimTrailingNullBytes(byArray8)), this.trimTrailingNullBytes(byArray9));
        }

        private byte[] trimTrailingNullBytes(byte[] byArray) {
            int n = byArray.length;
            int n2 = byArray.length - 1;
            while (n2 >= 0 && byArray[n2] == 0) {
                n = n2--;
            }
            return Arrays.copyOf(byArray, n);
        }

        private String normalizeName(String string) {
            Matcher matcher = NIST_CURVE_PATTERN.matcher(string);
            if (matcher.matches()) {
                switch (matcher.group(1)) {
                    case "P": {
                        if ("256".equals(matcher.group(2))) {
                            return "prime256v1";
                        }
                        return "secp" + matcher.group(2) + "r1";
                    }
                    case "K": {
                        return "sect" + matcher.group(2) + "k1";
                    }
                    case "B": {
                        if ("163".equals(matcher.group(2))) {
                            return "sect163r2";
                        }
                        return "sect" + matcher.group(2) + "r1";
                    }
                }
                return string;
            }
            if (string.startsWith("X9.62 ")) {
                return string.substring(6);
            }
            if (string.equals("secp256r1")) {
                return "prime256v1";
            }
            return string;
        }
    };
    private static final ConcurrentHashMap<ByteBuffer, String> EC_NAME_BY_ENCODED = new ConcurrentHashMap();
    private static final ConcurrentHashMap<EllipticCurve, String> EC_NAME_BY_CURVE = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Integer, String> EC_NAME_BY_KEY_SIZE = new ConcurrentHashMap();

    private static native int curveNameToInfo(String var0, int[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5, byte[] var6, byte[] var7, byte[] var8, byte[] var9, byte[] var10);

    private static native long buildGroup(int var0);

    private static native void freeGroup(long var0);

    private static native String[] getCurveNames();

    private static native String getCurveNameFromEncoded(byte[] var0);

    static String getOidFromName(String string) {
        if (string == null) {
            return null;
        }
        return EcUtils.getSpecByName(string) == null ? null : EcUtils.getSpecByName((String)string).oid;
    }

    private EcUtils() {
    }

    static ECInfo getSpecByName(String string) {
        return EC_INFO_CACHE.computeIfAbsent(string, EC_INFO_LOADER);
    }

    static String getNameBySpec(ECParameterSpec eCParameterSpec) {
        return EC_NAME_BY_CURVE.get(eCParameterSpec.getCurve());
    }

    static String getNameByKeySize(Integer n) {
        return EC_NAME_BY_KEY_SIZE.get(n);
    }

    static String getNameByEncoded(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        String string = EC_NAME_BY_ENCODED.get(ByteBuffer.wrap(byArray));
        if (string == null && (string = EcUtils.getCurveNameFromEncoded(byArray)) != null) {
            EC_NAME_BY_ENCODED.put(ByteBuffer.wrap((byte[])byArray.clone()), string);
        }
        return string;
    }

    static boolean ecParameterSpecsAreEqual(ECParameterSpec eCParameterSpec, ECParameterSpec eCParameterSpec2) {
        if (eCParameterSpec == eCParameterSpec2) {
            return true;
        }
        if (eCParameterSpec == null || eCParameterSpec2 == null) {
            return false;
        }
        return eCParameterSpec.getCofactor() == eCParameterSpec2.getCofactor() && eCParameterSpec.getOrder().equals(eCParameterSpec2.getOrder()) && eCParameterSpec.getCurve().equals(eCParameterSpec2.getCurve()) && eCParameterSpec.getGenerator().equals(eCParameterSpec2.getGenerator());
    }

    static {
        for (String string : EcUtils.getCurveNames()) {
            EcUtils.getSpecByName(string);
            EcUtils.getSpecByName(EcUtils.getOidFromName(string));
            EC_NAME_BY_CURVE.put(EcUtils.getSpecByName((String)string).spec.getCurve(), string);
            EC_NAME_BY_KEY_SIZE.put(EcUtils.getSpecByName((String)string).spec.getCurve().getField().getFieldSize(), string);
            EC_NAME_BY_ENCODED.put(ByteBuffer.wrap(EcUtils.getSpecByName((String)string).encoded), string);
        }
    }

    static final class NativeGroup
    extends NativeResource {
        protected NativeGroup(long l2) {
            super(l2, l -> EcUtils.freeGroup(l));
        }
    }

    static final class ECInfo {
        private final ThreadLocal<NativeGroup> group = new ThreadLocal<NativeGroup>(){

            @Override
            protected NativeGroup initialValue() {
                if (nid != 0) {
                    return new NativeGroup(EcUtils.buildGroup(nid));
                }
                return null;
            }
        };
        final String name;
        final ECParameterSpec spec;
        final int nid;
        final String oid;
        final byte[] encoded;

        private ECInfo(String string, ECParameterSpec eCParameterSpec, int n, String string2, byte[] byArray) {
            this.name = string;
            this.spec = eCParameterSpec;
            this.nid = n;
            this.oid = string2;
            this.encoded = byArray;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.nid);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ECInfo eCInfo = (ECInfo)object;
            if (!Objects.equals(this.name, eCInfo.name)) {
                return false;
            }
            return Objects.equals(this.nid, eCInfo.nid);
        }

        NativeGroup getGroup() {
            return this.group.get();
        }

        public String toString() {
            return "ECInfo [name=" + this.name + ", spec=" + this.spec + ", nid=" + this.nid + "]";
        }
    }
}

