/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.AccessibleByteArrayOutputStream;
import com.amazon.corretto.crypto.provider.AmazonCorrettoCryptoProvider;
import com.amazon.corretto.crypto.provider.EvpKeyType;
import com.amazon.corretto.crypto.provider.EvpSignatureBase;
import java.nio.ByteBuffer;
import java.security.SignatureException;

class EvpSignatureRaw
extends EvpSignatureBase {
    private AccessibleByteArrayOutputStream buffer = new AccessibleByteArrayOutputStream(64, 0x100000);

    private EvpSignatureRaw(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider, EvpKeyType evpKeyType, int n, boolean bl) {
        super(amazonCorrettoCryptoProvider, evpKeyType, n, 0L, bl);
    }

    @Override
    protected void engineReset() {
        this.buffer.reset();
    }

    @Override
    protected void engineUpdate(byte by) throws SignatureException {
        this.buffer.write(by & 0xFF);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.buffer.write(byArray, n, n2);
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        this.buffer.write(byteBuffer);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        try {
            this.ensureInitialized(true);
            byte[] byArray = this.key_.use(l -> EvpSignatureRaw.signRaw(l, this.paddingType_, this.preHash_, 0L, 0, this.buffer.getDataBuffer(), 0, this.buffer.size()));
            return byArray;
        }
        finally {
            this.engineReset();
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        return this.engineVerify(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean engineVerify(byte[] byArray, int n, int n2) throws SignatureException {
        try {
            this.ensureInitialized(false);
            this.sniffTest(byArray, n, n2);
            boolean bl = this.key_.use(l -> EvpSignatureRaw.verifyRaw(l, this.paddingType_, this.preHash_, 0L, 0, this.buffer.getDataBuffer(), 0, this.buffer.size(), byArray, n, n2));
            return bl;
        }
        finally {
            this.engineReset();
        }
    }

    @Override
    protected boolean isBufferEmpty() {
        return this.buffer.size() == 0;
    }

    private static native byte[] signRaw(long var0, int var2, boolean var3, long var4, int var6, byte[] var7, int var8, int var9);

    private static native boolean verifyRaw(long var0, int var2, boolean var3, long var4, int var6, byte[] var7, int var8, int var9, byte[] var10, int var11, int var12) throws SignatureException;

    static final class MLDSAExtMu
    extends EvpSignatureRaw {
        MLDSAExtMu(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, EvpKeyType.MLDSA, 0, true);
        }
    }

    static final class MLDSA
    extends EvpSignatureRaw {
        MLDSA(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, EvpKeyType.MLDSA, 0, false);
        }
    }

    static final class Ed25519
    extends EvpSignatureRaw {
        Ed25519(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, EvpKeyType.EdDSA, 0, false);
        }
    }

    static final class NONEwithECDSA
    extends EvpSignatureRaw {
        NONEwithECDSA(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, EvpKeyType.EC, 0, false);
        }
    }
}

