/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.auditlog;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class AuditLogUtils {
    public static boolean IsIpInternal(String ipAddress) throws UnknownHostException {
        InetAddress address = InetAddress.getByName(ipAddress);
        return !AuditLogUtils.IsGlobalUnicast(address) || AuditLogUtils.isPrivateSubnet(address);
    }

    public static boolean IsGlobalUnicast(InetAddress inetAddress) {
        return !inetAddress.isLinkLocalAddress() && !inetAddress.isMulticastAddress() && !inetAddress.isLoopbackAddress() && !inetAddress.isAnyLocalAddress();
    }

    public static boolean isPrivateSubnet(InetAddress inetAddress) {
        if (inetAddress instanceof Inet6Address) {
            return false;
        }
        return (inetAddress.getAddress()[0] & 0xFF) == 10 || (inetAddress.getAddress()[0] & 0xFF) == 100 && (inetAddress.getAddress()[1] & 0xFF) >= 64 && (inetAddress.getAddress()[1] & 0xFF) <= 127 || (inetAddress.getAddress()[0] & 0xFF) == 172 && (inetAddress.getAddress()[1] & 0xFF) >= 16 && (inetAddress.getAddress()[1] & 0xFF) <= 31 || (inetAddress.getAddress()[0] & 0xFF) == 192 && (inetAddress.getAddress()[1] & 0xFF) == 0 && (inetAddress.getAddress()[2] & 0xFF) == 0 || (inetAddress.getAddress()[0] & 0xFF) == 192 && (inetAddress.getAddress()[1] & 0xFF) == 168 || (inetAddress.getAddress()[0] & 0xFF) == 198 && (inetAddress.getAddress()[1] & 0xFF) >= 18 && (inetAddress.getAddress()[1] & 0xFF) <= 19;
    }
}

