/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.rest.datapreview.extension;

import io.confluent.connect.rest.datapreview.extension.resources.ConnectorDataPreviewsResource;
import io.confluent.connect.rest.datapreview.extension.service.ConnectorDataPreviewConfig;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.connect.rest.ConnectRestExtension;
import org.apache.kafka.connect.rest.ConnectRestExtensionContext;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorDataPreviewRestExtension
implements ConnectRestExtension {
    private static final Logger log = LoggerFactory.getLogger(ConnectorDataPreviewRestExtension.class);
    private Map<String, Object> configs;

    public void register(ConnectRestExtensionContext restPluginContext) {
        log.info("Registering connector data preview rest extension.");
        try {
            restPluginContext.configurable().register(ConnectorDataPreviewsResource.class);
            restPluginContext.configurable().register((Object)new AbstractBinder(){

                protected void configure() {
                    this.bind((Object)new ConnectorDataPreviewConfig(ConnectorDataPreviewRestExtension.this.configs)).to(ConnectorDataPreviewConfig.class);
                }
            });
            log.info("Finished registering connector data preview rest extension.");
        }
        catch (ConfigException e) {
            log.error("Could not register connector data preview rest extension due to failure in validation of configurations. ", (Throwable)e);
        }
    }

    public void close() {
    }

    public void configure(Map<String, ?> configs) {
        this.configs = new HashMap(configs);
    }

    public String version() {
        return AppInfoParser.getVersion();
    }
}

