/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.rest.datapreview.extension.resources;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.connect.rest.datapreview.extension.entities.ConnectorDataPreviewRequest;
import io.confluent.connect.rest.datapreview.extension.service.ConnectorDataPreviewConfig;
import io.confluent.connect.rest.datapreview.extension.service.ConnectorDataPreviewService;
import jakarta.inject.Inject;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import org.apache.kafka.connect.runtime.rest.resources.ConnectorPluginsResource;
import org.apache.kafka.connect.runtime.rest.resources.ConnectorsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/connector-datapreviews")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ConnectorDataPreviewsResource {
    private static final Logger log = LoggerFactory.getLogger(ConnectorDataPreviewsResource.class);
    private final ConnectorDataPreviewService dataPreviewService;

    @Inject
    public ConnectorDataPreviewsResource(ConnectorsResource connectorsResource, ConnectorPluginsResource connectorPluginsResource, ConnectorDataPreviewConfig config) {
        this.dataPreviewService = new ConnectorDataPreviewService(connectorsResource, connectorPluginsResource, config.originals());
    }

    @VisibleForTesting
    ConnectorDataPreviewsResource(ConnectorDataPreviewService dataPreviewService) {
        this.dataPreviewService = dataPreviewService;
    }

    @POST
    @Path(value="/")
    public Response createDataPreview(@Context HttpHeaders headers, ConnectorDataPreviewRequest createRequest) throws Throwable {
        if (createRequest == null) {
            log.error("Data Preview request cannot be null.");
            throw new BadRequestException("Data Preview request cannot be null.");
        }
        log.info("Creating connector data preview with request name {}", (Object)createRequest.name());
        return this.dataPreviewService.createDataPreview(createRequest, headers);
    }
}

