/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.common.types;

import java.util.Objects;
import org.projectnessie.cel.common.types.Err;
import org.projectnessie.cel.common.types.IntT;
import org.projectnessie.cel.common.types.StringT;
import org.projectnessie.cel.common.types.TypeT;
import org.projectnessie.cel.common.types.Types;
import org.projectnessie.cel.common.types.ref.BaseVal;
import org.projectnessie.cel.common.types.ref.Type;
import org.projectnessie.cel.common.types.ref.TypeEnum;
import org.projectnessie.cel.common.types.ref.Val;
import org.projectnessie.cel.common.types.traits.Comparer;
import org.projectnessie.cel.common.types.traits.Negater;
import org.projectnessie.cel.common.types.traits.Trait;
import org.projectnessie.cel.relocated.com.google.protobuf.Any;
import org.projectnessie.cel.relocated.com.google.protobuf.BoolValue;
import org.projectnessie.cel.relocated.com.google.protobuf.Value;

public final class BoolT
extends BaseVal
implements Comparer,
Negater {
    public static final Type BoolType = TypeT.newTypeValue(TypeEnum.Bool, Trait.ComparerType, Trait.NegatorType);
    public static final BoolT False = new BoolT(false);
    public static final BoolT True = new BoolT(true);
    private final boolean b;

    BoolT(boolean b) {
        this.b = b;
    }

    @Override
    public boolean booleanValue() {
        return this.b;
    }

    @Override
    public Val compare(Val other) {
        if (!(other instanceof BoolT)) {
            return Err.noSuchOverload(this, "compare", other);
        }
        return IntT.intOfCompare(Boolean.compare(this.b, ((BoolT)other).b));
    }

    @Override
    public <T> T convertToNative(Class<T> typeDesc) {
        if (typeDesc == Boolean.class || typeDesc == Boolean.TYPE || typeDesc == Object.class) {
            return (T)Boolean.valueOf(this.b);
        }
        if (typeDesc == Any.class) {
            return (T)Any.pack(BoolValue.of(this.b));
        }
        if (typeDesc == BoolValue.class) {
            return (T)BoolValue.of(this.b);
        }
        if (typeDesc == Val.class || typeDesc == BoolT.class) {
            return (T)this;
        }
        if (typeDesc == Value.class) {
            return (T)Value.newBuilder().setBoolValue(this.b).build();
        }
        throw new RuntimeException(String.format("native type conversion error from '%s' to '%s'", BoolType, typeDesc.getName()));
    }

    @Override
    public Val convertToType(Type typeVal) {
        switch (typeVal.typeEnum()) {
            case String: {
                return StringT.stringOf(Boolean.toString(this.b));
            }
            case Bool: {
                return this;
            }
            case Type: {
                return BoolType;
            }
        }
        return Err.newTypeConversionError(BoolType, typeVal);
    }

    @Override
    public Val equal(Val other) {
        switch (other.type().typeEnum()) {
            case Bool: {
                return Types.boolOf(this.b == ((BoolT)other).b);
            }
            case Null: {
                return False;
            }
        }
        return Err.noSuchOverload(this, "equal", other);
    }

    @Override
    public Val negate() {
        return Types.boolOf(!this.b);
    }

    @Override
    public Type type() {
        return BoolType;
    }

    @Override
    public Object value() {
        return this.b;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoolT boolT = (BoolT)o;
        return this.b == boolT.b;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.b);
    }
}

