/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.common.types.pb;

import org.projectnessie.cel.common.ULong;
import org.projectnessie.cel.common.types.Err;
import org.projectnessie.cel.common.types.Types;
import org.projectnessie.cel.common.types.pb.Db;
import org.projectnessie.cel.common.types.pb.PbTypeDescription;
import org.projectnessie.cel.common.types.ref.TypeAdapter;
import org.projectnessie.cel.common.types.ref.TypeAdapterSupport;
import org.projectnessie.cel.common.types.ref.Val;
import org.projectnessie.cel.relocated.com.google.api.expr.v1alpha1.Value;
import org.projectnessie.cel.relocated.com.google.protobuf.Message;

public final class DefaultTypeAdapter
implements TypeAdapter {
    public static final DefaultTypeAdapter Instance = new DefaultTypeAdapter(Db.defaultDb);
    private final Db db;

    private DefaultTypeAdapter(Db db) {
        this.db = db;
    }

    @Override
    public Val nativeToValue(Object value) {
        Val val = DefaultTypeAdapter.nativeToValue(this.db, this, value);
        if (val != null) {
            return val;
        }
        return Err.unsupportedRefValConversionErr(value);
    }

    public static Val nativeToValue(Db db, TypeAdapter a, Object value) {
        Val v = TypeAdapterSupport.maybeNativeToValue(a, value);
        if (v != null) {
            return v;
        }
        if (value instanceof Val) {
            return (Val)value;
        }
        if (value instanceof Message) {
            Message msg = (Message)value;
            String typeName = PbTypeDescription.typeNameFromMessage(msg);
            if (typeName.isEmpty()) {
                return Err.anyWithEmptyType();
            }
            PbTypeDescription type = db.describeType(typeName);
            if (type == null) {
                return Err.unknownType(typeName);
            }
            value = type.maybeUnwrap(db, msg);
            if (value instanceof Message) {
                value = type.maybeUnwrap(db, value);
            }
            return a.nativeToValue(value);
        }
        return Err.newErr("unsupported conversion from '%s' to value", value.getClass());
    }

    static Object maybeUnwrapValue(Object value) {
        if (value instanceof Value) {
            Value v = (Value)value;
            switch (v.getKindCase()) {
                case BOOL_VALUE: {
                    return v.getBoolValue();
                }
                case BYTES_VALUE: {
                    return v.getBytesValue();
                }
                case DOUBLE_VALUE: {
                    return v.getDoubleValue();
                }
                case INT64_VALUE: {
                    return v.getInt64Value();
                }
                case LIST_VALUE: {
                    return v.getListValue();
                }
                case NULL_VALUE: {
                    return v.getNullValue();
                }
                case MAP_VALUE: {
                    return v.getMapValue();
                }
                case STRING_VALUE: {
                    return v.getStringValue();
                }
                case TYPE_VALUE: {
                    return Types.getTypeByName(v.getTypeValue());
                }
                case UINT64_VALUE: {
                    return ULong.valueOf(v.getUint64Value());
                }
                case OBJECT_VALUE: {
                    return v.getObjectValue();
                }
            }
        }
        return value;
    }
}

