/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.interpreter;

import java.util.Objects;

public final class ResolvedValue {
    public static final ResolvedValue NULL_VALUE = new ResolvedValue(null, true);
    public static final ResolvedValue ABSENT = new ResolvedValue(null, false);
    private final Object value;
    private final boolean present;

    public static ResolvedValue resolvedValue(Object value) {
        return new ResolvedValue(Objects.requireNonNull(value), true);
    }

    private ResolvedValue(Object value, boolean present) {
        this.value = value;
        this.present = present;
    }

    public Object value() {
        return this.value;
    }

    public boolean present() {
        return this.present;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolvedValue that = (ResolvedValue)o;
        if (this.present != that.present) {
            return false;
        }
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + (this.present ? 1 : 0);
        return result;
    }

    public String toString() {
        return "ResolvedValue{present=" + this.present + ", value=" + this.value + '}';
    }
}

