/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.relocated.org.agrona;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.projectnessie.cel.relocated.org.agrona.AsciiEncoding;
import org.projectnessie.cel.relocated.org.agrona.PropertyAction;

public final class SystemUtil {
    public static final long PID_NOT_FOUND = 0L;
    public static final String NULL_PROPERTY_VALUE = "@null";
    private static final String SUN_PID_PROP_NAME = "sun.java.launcher.pid";
    private static final long MAX_G_VALUE = 0x1FFFFFFFFL;
    private static final long MAX_M_VALUE = 0x7FFFFFFFFFFL;
    private static final long MAX_K_VALUE = 9007199254739968L;
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase();
    private static final String OS_ARCH = System.getProperty("os.arch", "unknown");
    private static final long PID;

    private SystemUtil() {
    }

    public static String osName() {
        return OS_NAME;
    }

    public static String osArch() {
        return OS_ARCH;
    }

    public static long getPid() {
        return PID;
    }

    public static boolean isWindows() {
        return OS_NAME.startsWith("win");
    }

    public static boolean isLinux() {
        return OS_NAME.contains("linux");
    }

    public static boolean isX64Arch() {
        return SystemUtil.isX64Arch(OS_ARCH);
    }

    public static boolean isDebuggerAttached() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        for (String arg : runtimeMXBean.getInputArguments()) {
            if (!arg.contains("-agentlib:jdwp")) continue;
            return true;
        }
        return false;
    }

    public static String tmpDirName() {
        String tmpDirName = System.getProperty("java.io.tmpdir");
        if (!tmpDirName.endsWith(File.separator)) {
            tmpDirName = tmpDirName + File.separator;
        }
        return tmpDirName;
    }

    public static String threadDump() {
        StringBuilder sb = new StringBuilder();
        SystemUtil.threadDump(sb);
        return sb.toString();
    }

    public static void threadDump(StringBuilder sb) {
        ThreadMXBean mxBean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo threadInfo : mxBean.getThreadInfo(mxBean.getAllThreadIds(), Integer.MAX_VALUE)) {
            if (null == threadInfo) continue;
            sb.append('\"').append(threadInfo.getThreadName()).append("\": ").append((Object)threadInfo.getThreadState());
            for (StackTraceElement stackTraceElement : threadInfo.getStackTrace()) {
                sb.append("\n    at ").append(stackTraceElement.toString());
            }
            sb.append("\n\n");
        }
    }

    public static void loadPropertiesFile(String filenameOrUrl) {
        SystemUtil.loadPropertiesFile(PropertyAction.REPLACE, filenameOrUrl);
    }

    public static void loadPropertiesFile(PropertyAction propertyAction, String filenameOrUrl) {
        Throwable throwable;
        InputStream in3;
        File file;
        URL resource = ClassLoader.getSystemClassLoader().getResource(filenameOrUrl);
        if (null != resource) {
            try (InputStream in22 = resource.openStream();){
                SystemUtil.loadProperties(propertyAction, in22);
            }
            catch (Exception in22) {
                // empty catch block
            }
        }
        if ((file = new File(filenameOrUrl)).exists()) {
            try {
                in3 = Files.newInputStream(file.toPath(), new OpenOption[0]);
                throwable = null;
                try {
                    SystemUtil.loadProperties(propertyAction, in3);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in3 != null) {
                        if (throwable != null) {
                            try {
                                in3.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            in3.close();
                        }
                    }
                }
            }
            catch (Exception in3) {
                // empty catch block
            }
        }
        try {
            in3 = new URI(filenameOrUrl).toURL().openStream();
            throwable = null;
            try {
                SystemUtil.loadProperties(propertyAction, in3);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (in3 != null) {
                    if (throwable != null) {
                        try {
                            in3.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        in3.close();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void loadPropertiesFiles(String ... filenamesOrUrls) {
        SystemUtil.loadPropertiesFiles(PropertyAction.REPLACE, filenamesOrUrls);
    }

    public static void loadPropertiesFiles(PropertyAction propertyAction, String ... filenamesOrUrls) {
        for (String filenameOrUrl : filenamesOrUrls) {
            SystemUtil.loadPropertiesFile(propertyAction, filenameOrUrl);
        }
    }

    public static String getProperty(String propertyName) {
        String propertyValue = System.getProperty(propertyName);
        return NULL_PROPERTY_VALUE.equals(propertyValue) ? null : propertyValue;
    }

    public static String getProperty(String propertyName, String defaultValue) {
        String propertyValue = System.getProperty(propertyName);
        if (NULL_PROPERTY_VALUE.equals(propertyValue)) {
            return null;
        }
        return null == propertyValue ? defaultValue : propertyValue;
    }

    public static int getSizeAsInt(String propertyName, int defaultValue) {
        String propertyValue = System.getProperty(propertyName);
        if (propertyValue != null) {
            long value = SystemUtil.parseSize(propertyName, propertyValue);
            if (value < 0L || value > Integer.MAX_VALUE) {
                throw new NumberFormatException(propertyName + " must positive and less than Integer.MAX_VALUE: " + value);
            }
            return (int)value;
        }
        return defaultValue;
    }

    public static long getSizeAsLong(String propertyName, long defaultValue) {
        String propertyValue = System.getProperty(propertyName);
        if (propertyValue != null) {
            long value = SystemUtil.parseSize(propertyName, propertyValue);
            if (value < 0L) {
                throw new NumberFormatException(propertyName + " must be positive: " + value);
            }
            return value;
        }
        return defaultValue;
    }

    public static long parseSize(String propertyName, String propertyValue) {
        int lengthMinusSuffix = propertyValue.length() - 1;
        char lastCharacter = propertyValue.charAt(lengthMinusSuffix);
        if (Character.isDigit(lastCharacter)) {
            return Long.parseLong(propertyValue);
        }
        long value = AsciiEncoding.parseLongAscii(propertyValue, 0, lengthMinusSuffix);
        switch (lastCharacter) {
            case 'K': 
            case 'k': {
                if (value > 9007199254739968L) {
                    throw new NumberFormatException(propertyName + " would overflow a long: " + propertyValue);
                }
                return value * 1024L;
            }
            case 'M': 
            case 'm': {
                if (value > 0x7FFFFFFFFFFL) {
                    throw new NumberFormatException(propertyName + " would overflow a long: " + propertyValue);
                }
                return value * 1024L * 1024L;
            }
            case 'G': 
            case 'g': {
                if (value > 0x1FFFFFFFFL) {
                    throw new NumberFormatException(propertyName + " would overflow a long: " + propertyValue);
                }
                return value * 1024L * 1024L * 1024L;
            }
        }
        throw new NumberFormatException(propertyName + ": " + propertyValue + " should end with: k, m, or g.");
    }

    public static long getDurationInNanos(String propertyName, long defaultValue) {
        String propertyValue = System.getProperty(propertyName);
        if (propertyValue != null) {
            long value = SystemUtil.parseDuration(propertyName, propertyValue);
            if (value < 0L) {
                throw new NumberFormatException(propertyName + " must be positive: " + value);
            }
            return value;
        }
        return defaultValue;
    }

    public static long parseDuration(String propertyName, String propertyValue) {
        char lastCharacter = propertyValue.charAt(propertyValue.length() - 1);
        if (Character.isDigit(lastCharacter)) {
            return Long.parseLong(propertyValue);
        }
        if (lastCharacter != 's' && lastCharacter != 'S') {
            throw new NumberFormatException(propertyName + ": " + propertyValue + " should end with: s, ms, us, or ns.");
        }
        char secondLastCharacter = propertyValue.charAt(propertyValue.length() - 2);
        if (Character.isDigit(secondLastCharacter)) {
            long value = AsciiEncoding.parseLongAscii(propertyValue, 0, propertyValue.length() - 1);
            return TimeUnit.SECONDS.toNanos(value);
        }
        long value = AsciiEncoding.parseLongAscii(propertyValue, 0, propertyValue.length() - 2);
        switch (secondLastCharacter) {
            case 'N': 
            case 'n': {
                return value;
            }
            case 'U': 
            case 'u': {
                return TimeUnit.MICROSECONDS.toNanos(value);
            }
            case 'M': 
            case 'm': {
                return TimeUnit.MILLISECONDS.toNanos(value);
            }
        }
        throw new NumberFormatException(propertyName + ": " + propertyValue + " should end with: s, ms, us, or ns.");
    }

    static boolean isX64Arch(String arch) {
        return arch.equals("amd64") || arch.equals("x86_64") || arch.equals("x64");
    }

    private static void loadProperties(PropertyAction propertyAction, InputStream in) throws IOException {
        Properties systemProperties = System.getProperties();
        Properties properties = new Properties();
        properties.load(in);
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            switch (propertyAction) {
                case PRESERVE: {
                    if (systemProperties.containsKey(k)) break;
                    systemProperties.setProperty((String)k, (String)v);
                    break;
                }
                default: {
                    systemProperties.setProperty((String)k, (String)v);
                }
            }
        }));
    }

    static {
        long pid = 0L;
        try {
            Class<?> processHandleClass = Class.forName("java.lang.ProcessHandle");
            Method currentMethod = processHandleClass.getMethod("current", new Class[0]);
            Object processHandle = currentMethod.invoke(null, new Object[0]);
            Method pidMethod = processHandleClass.getMethod("pid", new Class[0]);
            pid = (Long)pidMethod.invoke(processHandle, new Object[0]);
        }
        catch (Throwable ignore) {
            try {
                String pidPropertyValue = System.getProperty(SUN_PID_PROP_NAME);
                if (null != pidPropertyValue) {
                    pid = Long.parseLong(pidPropertyValue);
                } else {
                    String jvmName = ManagementFactory.getRuntimeMXBean().getName();
                    pid = Long.parseLong(jvmName.split("@")[0]);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        PID = pid;
    }
}

