/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.relocated.org.agrona.concurrent;

import java.nio.ByteBuffer;
import org.projectnessie.cel.relocated.org.agrona.AbstractMutableDirectBuffer;
import org.projectnessie.cel.relocated.org.agrona.BufferUtil;
import org.projectnessie.cel.relocated.org.agrona.DirectBuffer;
import org.projectnessie.cel.relocated.org.agrona.UnsafeAccess;
import org.projectnessie.cel.relocated.org.agrona.collections.ArrayUtil;
import org.projectnessie.cel.relocated.org.agrona.concurrent.AtomicBuffer;

public class UnsafeBuffer
extends AbstractMutableDirectBuffer
implements AtomicBuffer {
    public static final int ALIGNMENT = 8;
    public static final String DISABLE_BOUNDS_CHECKS_PROP_NAME = "agrona.disable.bounds.checks";
    public static final boolean SHOULD_BOUNDS_CHECK = DirectBuffer.SHOULD_BOUNDS_CHECK;
    private ByteBuffer byteBuffer;
    private int wrapAdjustment;

    public UnsafeBuffer() {
        this.wrap(ArrayUtil.EMPTY_BYTE_ARRAY);
    }

    public UnsafeBuffer(byte[] buffer) {
        this.wrap(buffer);
    }

    public UnsafeBuffer(byte[] buffer, int offset, int length) {
        this.wrap(buffer, offset, length);
    }

    public UnsafeBuffer(ByteBuffer buffer) {
        this.wrap(buffer);
    }

    public UnsafeBuffer(ByteBuffer buffer, int offset, int length) {
        this.wrap(buffer, offset, length);
    }

    public UnsafeBuffer(DirectBuffer buffer) {
        this.wrap(buffer);
    }

    public UnsafeBuffer(DirectBuffer buffer, int offset, int length) {
        this.wrap(buffer, offset, length);
    }

    public UnsafeBuffer(long address, int length) {
        this.wrap(address, length);
    }

    @Override
    public void wrap(byte[] buffer) {
        this.capacity = buffer.length;
        this.addressOffset = BufferUtil.ARRAY_BASE_OFFSET;
        this.byteBuffer = null;
        this.wrapAdjustment = 0;
        if (buffer != this.byteArray) {
            this.byteArray = buffer;
        }
    }

    @Override
    public void wrap(byte[] buffer, int offset, int length) {
        if (SHOULD_BOUNDS_CHECK) {
            UnsafeBuffer.boundsCheckWrap(offset, length, buffer.length);
        }
        this.capacity = length;
        this.addressOffset = BufferUtil.ARRAY_BASE_OFFSET + (long)offset;
        this.byteBuffer = null;
        this.wrapAdjustment = offset;
        if (buffer != this.byteArray) {
            this.byteArray = buffer;
        }
    }

    @Override
    public void wrap(ByteBuffer buffer) {
        this.capacity = buffer.capacity();
        if (buffer != this.byteBuffer) {
            this.byteBuffer = buffer;
        }
        if (buffer.isDirect()) {
            this.byteArray = null;
            this.addressOffset = BufferUtil.address(buffer);
            this.wrapAdjustment = 0;
        } else {
            this.byteArray = BufferUtil.array(buffer);
            int arrayOffset = BufferUtil.arrayOffset(buffer);
            this.addressOffset = BufferUtil.ARRAY_BASE_OFFSET + (long)arrayOffset;
            this.wrapAdjustment = arrayOffset;
        }
    }

    @Override
    public void wrap(ByteBuffer buffer, int offset, int length) {
        if (SHOULD_BOUNDS_CHECK) {
            UnsafeBuffer.boundsCheckWrap(offset, length, buffer.capacity());
        }
        this.capacity = length;
        if (buffer != this.byteBuffer) {
            this.byteBuffer = buffer;
        }
        if (buffer.isDirect()) {
            this.byteArray = null;
            this.addressOffset = BufferUtil.address(buffer) + (long)offset;
            this.wrapAdjustment = offset;
        } else {
            this.byteArray = BufferUtil.array(buffer);
            int totalOffset = BufferUtil.arrayOffset(buffer) + offset;
            this.addressOffset = BufferUtil.ARRAY_BASE_OFFSET + (long)totalOffset;
            this.wrapAdjustment = totalOffset;
        }
    }

    @Override
    public void wrap(DirectBuffer buffer) {
        ByteBuffer byteBuffer;
        this.capacity = buffer.capacity();
        this.addressOffset = buffer.addressOffset();
        this.wrapAdjustment = buffer.wrapAdjustment();
        byte[] array = buffer.byteArray();
        if (array != this.byteArray) {
            this.byteArray = array;
        }
        if ((byteBuffer = buffer.byteBuffer()) != this.byteBuffer) {
            this.byteBuffer = byteBuffer;
        }
    }

    @Override
    public void wrap(DirectBuffer buffer, int offset, int length) {
        ByteBuffer byteBuffer;
        if (SHOULD_BOUNDS_CHECK) {
            UnsafeBuffer.boundsCheckWrap(offset, length, buffer.capacity());
        }
        this.capacity = length;
        this.addressOffset = buffer.addressOffset() + (long)offset;
        this.wrapAdjustment = buffer.wrapAdjustment() + offset;
        byte[] array = buffer.byteArray();
        if (array != this.byteArray) {
            this.byteArray = array;
        }
        if ((byteBuffer = buffer.byteBuffer()) != this.byteBuffer) {
            this.byteBuffer = byteBuffer;
        }
    }

    @Override
    public void wrap(long address, int length) {
        this.capacity = length;
        this.addressOffset = address;
        this.byteArray = null;
        this.byteBuffer = null;
    }

    @Override
    public ByteBuffer byteBuffer() {
        return this.byteBuffer;
    }

    @Override
    public int wrapAdjustment() {
        return this.wrapAdjustment;
    }

    @Override
    public boolean isExpandable() {
        return false;
    }

    @Override
    public void verifyAlignment() {
        if (null != this.byteArray) {
            String msg = "AtomicBuffer was created from a byte[] and is not correctly aligned by 8";
            if (STRICT_ALIGNMENT_CHECKS) {
                throw new IllegalStateException("AtomicBuffer was created from a byte[] and is not correctly aligned by 8");
            }
            System.err.println("AtomicBuffer was created from a byte[] and is not correctly aligned by 8");
        } else if (0L != (this.addressOffset & 7L)) {
            throw new IllegalStateException("AtomicBuffer is not correctly aligned: addressOffset=" + this.addressOffset + " is not divisible by " + 8);
        }
    }

    @Override
    public long getLongVolatile(int index) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        return UnsafeAccess.UNSAFE.getLongVolatile(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putLongVolatile(int index, long value) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        UnsafeAccess.UNSAFE.putLongVolatile(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public void putLongOrdered(int index, long value) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        UnsafeAccess.UNSAFE.putOrderedLong(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public long addLongOrdered(int index, long increment) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        long offset = this.addressOffset + (long)index;
        byte[] array = this.byteArray;
        long value = UnsafeAccess.UNSAFE.getLong(array, offset);
        UnsafeAccess.UNSAFE.putOrderedLong(array, offset, value + increment);
        return value;
    }

    @Override
    public boolean compareAndSetLong(int index, long expectedValue, long updateValue) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        return UnsafeAccess.UNSAFE.compareAndSwapLong(this.byteArray, this.addressOffset + (long)index, expectedValue, updateValue);
    }

    @Override
    public long getAndSetLong(int index, long value) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        return UnsafeAccess.UNSAFE.getAndSetLong(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public long getAndAddLong(int index, long delta) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        return UnsafeAccess.UNSAFE.getAndAddLong(this.byteArray, this.addressOffset + (long)index, delta);
    }

    @Override
    public int getIntVolatile(int index) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        return UnsafeAccess.UNSAFE.getIntVolatile(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putIntVolatile(int index, int value) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        UnsafeAccess.UNSAFE.putIntVolatile(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public void putIntOrdered(int index, int value) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        UnsafeAccess.UNSAFE.putOrderedInt(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public int addIntOrdered(int index, int increment) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        long offset = this.addressOffset + (long)index;
        byte[] array = this.byteArray;
        int value = UnsafeAccess.UNSAFE.getInt(array, offset);
        UnsafeAccess.UNSAFE.putOrderedInt(array, offset, value + increment);
        return value;
    }

    @Override
    public boolean compareAndSetInt(int index, int expectedValue, int updateValue) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        return UnsafeAccess.UNSAFE.compareAndSwapInt(this.byteArray, this.addressOffset + (long)index, expectedValue, updateValue);
    }

    @Override
    public int getAndSetInt(int index, int value) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        return UnsafeAccess.UNSAFE.getAndSetInt(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public int getAndAddInt(int index, int delta) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        return UnsafeAccess.UNSAFE.getAndAddInt(this.byteArray, this.addressOffset + (long)index, delta);
    }

    @Override
    public short getShortVolatile(int index) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        return UnsafeAccess.UNSAFE.getShortVolatile(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putShortVolatile(int index, short value) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        UnsafeAccess.UNSAFE.putShortVolatile(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public byte getByteVolatile(int index) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 1);
        }
        return UnsafeAccess.UNSAFE.getByteVolatile(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putByteVolatile(int index, byte value) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 1);
        }
        UnsafeAccess.UNSAFE.putByteVolatile(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public char getCharVolatile(int index) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        return UnsafeAccess.UNSAFE.getCharVolatile(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putCharVolatile(int index, char value) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        UnsafeAccess.UNSAFE.putCharVolatile(this.byteArray, this.addressOffset + (long)index, value);
    }

    public String toString() {
        return "UnsafeBuffer{addressOffset=" + this.addressOffset + ", capacity=" + this.capacity + ", byteArray=" + (null == this.byteArray ? "null" : "byte[" + this.byteArray.length + "]") + ", byteBuffer=" + this.byteBuffer + '}';
    }

    @Override
    protected final void ensureCapacity(int index, int length) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length);
        }
    }

    private static void boundsCheckWrap(int offset, int length, int capacity) {
        if (offset < 0) {
            throw new IllegalArgumentException("invalid offset: " + offset);
        }
        if (length < 0) {
            throw new IllegalArgumentException("invalid length: " + length);
        }
        if (offset > capacity - length || length > capacity - offset) {
            throw new IllegalArgumentException("offset=" + offset + " length=" + length + " not valid for capacity=" + capacity);
        }
    }
}

