/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.types.jackson;

import org.projectnessie.cel.common.types.Err;
import org.projectnessie.cel.common.types.ObjectT;
import org.projectnessie.cel.common.types.StringT;
import org.projectnessie.cel.common.types.Types;
import org.projectnessie.cel.common.types.ref.Val;
import org.projectnessie.cel.types.jackson.JacksonRegistry;
import org.projectnessie.cel.types.jackson.JacksonTypeDescription;

final class JacksonObjectT
extends ObjectT {
    private JacksonObjectT(JacksonRegistry registry, Object value, JacksonTypeDescription typeDesc) {
        super(registry, value, typeDesc, typeDesc.type());
    }

    static JacksonObjectT newObject(JacksonRegistry registry, Object value, JacksonTypeDescription typeDesc) {
        return new JacksonObjectT(registry, value, typeDesc);
    }

    JacksonTypeDescription typeDesc() {
        return (JacksonTypeDescription)this.typeDesc;
    }

    JacksonRegistry registry() {
        return (JacksonRegistry)this.adapter;
    }

    @Override
    public Val isSet(Val field) {
        if (!(field instanceof StringT)) {
            return Err.noSuchOverload(this, "isSet", field);
        }
        String fieldName = (String)field.value();
        if (!this.typeDesc().hasProperty(fieldName)) {
            return Err.noSuchField(fieldName);
        }
        Object value = this.typeDesc().fromObject(this.value(), fieldName);
        return Types.boolOf(value != null);
    }

    @Override
    public Val get(Val index) {
        if (!(index instanceof StringT)) {
            return Err.noSuchOverload(this, "get", index);
        }
        String fieldName = (String)index.value();
        if (!this.typeDesc().hasProperty(fieldName)) {
            return Err.noSuchField(fieldName);
        }
        Object v = this.typeDesc().fromObject(this.value(), fieldName);
        return this.registry().nativeToValue(v);
    }

    @Override
    public <T> T convertToNative(Class<T> typeDesc) {
        if (typeDesc.isAssignableFrom(this.value.getClass())) {
            return (T)this.value;
        }
        if (typeDesc.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        throw new IllegalArgumentException(Err.newTypeConversionError(this.value.getClass().getName(), typeDesc).toString());
    }
}

