/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryKey;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryKeyType;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class SubjectKey
extends SchemaRegistryKey {
    private String subject;

    public SubjectKey(@JsonProperty(value="keytype") SchemaRegistryKeyType keyType, @JsonProperty(value="subject") String subject) {
        super(keyType);
        this.subject = subject;
    }

    @JsonProperty(value="subject")
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        SubjectKey that = (SubjectKey)o;
        return Objects.equals(this.subject, that.subject);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.subject);
    }

    @Override
    public int compareTo(SchemaRegistryKey o) {
        int compare = super.compareTo(o);
        if (compare == 0) {
            SubjectKey otherKey = (SubjectKey)o;
            if (this.subject == null && otherKey.getSubject() == null) {
                return 0;
            }
            if (this.subject == null) {
                return -1;
            }
            if (otherKey.getSubject() == null) {
                return 1;
            }
            return this.subject.compareTo(otherKey.getSubject());
        }
        return compare;
    }
}

