/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.utils;

import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaRegistryDeployment;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Props {
    public static final String PROPERTY_SCHEMA_REGISTRY_DEPLOYMENT_ATTRIBUTES = "schema.registry.metadata.deployment.attributes";
    private static final Logger log = LoggerFactory.getLogger(Props.class);

    public static SchemaRegistryDeployment getSchemaRegistryDeployment(Map<String, Object> props) {
        Object srDeployment = props.getOrDefault(PROPERTY_SCHEMA_REGISTRY_DEPLOYMENT_ATTRIBUTES, null);
        if (srDeployment == null) {
            return new SchemaRegistryDeployment();
        }
        if (srDeployment instanceof List) {
            List srDeploymentList = srDeployment;
            List processedList = srDeploymentList.stream().map(item -> item.toString().trim()).collect(Collectors.toList());
            return new SchemaRegistryDeployment(processedList);
        }
        log.error("Schema registry deployment attribute type unexpected");
        throw new IllegalArgumentException("Invalid schema registry deployment: " + String.valueOf(srDeployment));
    }
}

