/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.client.plugins.ssl;

import java.security.cert.X509Certificate;
import java.util.Locale;
import java.util.Objects;

public class CertificateId {
    private final String issuer;
    private final String serialNumber;

    public CertificateId(X509Certificate cert) {
        this.issuer = cert.getIssuerX500Principal().getName().toLowerCase(Locale.ROOT);
        this.serialNumber = cert.getSerialNumber().toString(16).toLowerCase(Locale.ROOT);
    }

    public CertificateId(String issuer, String serialNumber) {
        this.issuer = issuer;
        this.serialNumber = serialNumber;
    }

    public String issuer() {
        return this.issuer;
    }

    public String serialNumber() {
        return this.serialNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CertificateId that = (CertificateId)o;
        return Objects.equals(this.issuer, that.issuer) && Objects.equals(this.serialNumber, that.serialNumber);
    }

    public int hashCode() {
        return Objects.hash(this.issuer, this.serialNumber);
    }

    public String toString() {
        return this.issuer + ":" + this.serialNumber;
    }
}

