/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.security.config.provider;

import io.confluent.kafka.security.config.provider.DecryptionEngine;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.kafka.common.config.ConfigData;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.provider.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurePassConfigProvider
implements ConfigProvider {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String DATA_ENCRYPTION_KEY = "_metadata.symmetric_key.0.enc";
    public static final String MASTER_KEY_ENV_VAR = "_metadata.symmetric_key.0.envvar";
    public static final String METADATA_KEY_LENGTH = "_metadata.symmetric_key.0.length";
    public static final String METADATA_PREFIX = "_metadata";

    public void configure(Map<String, ?> configs) {
    }

    protected DecryptionEngine initializeDecryptionEngine(Properties properties) {
        try {
            String dataKey = properties.getProperty(DATA_ENCRYPTION_KEY);
            String masterKeyEnvVar = properties.getProperty(MASTER_KEY_ENV_VAR);
            String keyLength = properties.getProperty(METADATA_KEY_LENGTH);
            return new DecryptionEngine(masterKeyEnvVar, dataKey, keyLength);
        }
        catch (Exception e) {
            this.log.warn("Failed to initialize the decryption engine.");
            throw new ConfigException("Failed to initialize the decryption engine.", (Object)e);
        }
    }

    private boolean isCipherText(String config) {
        Matcher matcher = DecryptionEngine.CIPHER_PATTERN.matcher(config);
        return matcher.matches();
    }

    public ConfigData get(String path) {
        ConfigData configData;
        block14: {
            HashMap<String, String> data = new HashMap<String, String>();
            if (path == null || path.isEmpty()) {
                return new ConfigData(data);
            }
            Reader reader = this.reader(path);
            try {
                Properties properties = new Properties();
                properties.load(reader);
                DecryptionEngine decryptionEngine = this.initializeDecryptionEngine(properties);
                Enumeration<Object> keys = properties.keys();
                while (keys.hasMoreElements()) {
                    String value;
                    String key = keys.nextElement().toString();
                    if (key.startsWith(METADATA_PREFIX) || (value = properties.getProperty(key)) == null || value.isEmpty()) continue;
                    if (this.isCipherText(value)) {
                        try {
                            value = decryptionEngine.decryptWithDEK(value);
                        }
                        catch (Exception e) {
                            this.log.warn("Failed to decrypt the value.");
                        }
                    }
                    data.put(key, value);
                }
                configData = new ConfigData(data);
                if (reader == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ConfigException("Could not read properties from file " + path);
                }
                catch (ConfigException e) {
                    throw e;
                }
            }
            reader.close();
        }
        return configData;
    }

    public ConfigData get(String path, Set<String> keys) {
        ConfigData configData;
        block14: {
            HashMap<String, String> data = new HashMap<String, String>();
            if (path == null || path.isEmpty()) {
                return new ConfigData(data);
            }
            Reader reader = this.reader(path);
            try {
                Properties properties = new Properties();
                properties.load(reader);
                DecryptionEngine decryptionEngine = this.initializeDecryptionEngine(properties);
                for (String key : keys) {
                    String value = properties.getProperty(key);
                    if (value == null) continue;
                    if (this.isCipherText(value)) {
                        try {
                            value = decryptionEngine.decryptWithDEK(value);
                        }
                        catch (Exception e) {
                            this.log.warn("Failed to decrypt the value.");
                        }
                    }
                    data.put(key, value);
                }
                configData = new ConfigData(data);
                if (reader == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ConfigException("Could not read properties from file " + path);
                }
                catch (ConfigException e) {
                    throw e;
                }
            }
            reader.close();
        }
        return configData;
    }

    protected Reader reader(String path) throws IOException {
        return Files.newBufferedReader(Paths.get(path, new String[0]));
    }

    public void close() {
    }
}

