/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.k2.kafka;

import io.confluent.k2.kafka.link.K2MirrorTopicMetadata;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicType;
import org.apache.kafka.common.Uuid;

public record K2TopicMetadata(String topicName, Uuid topicId, int numPartitions, K2TopicLifecycleState k2TopicLifecycleState, Map<String, String> topicConfigs, Optional<K2MirrorTopicMetadata> mirrorTopicMetadataOpt) {
    public K2TopicMetadata(String topicName, Uuid topicId, int numPartitions, K2TopicLifecycleState k2TopicLifecycleState, Map<String, String> topicConfigs) {
        this(topicName, topicId, numPartitions, k2TopicLifecycleState, topicConfigs, Optional.empty());
    }

    public K2TopicMetadata(String topicName, Uuid topicId, int numPartitions, K2TopicLifecycleState k2TopicLifecycleState) {
        this(topicName, topicId, numPartitions, k2TopicLifecycleState, Collections.emptyMap());
    }

    public K2TopicMetadata {
        Objects.requireNonNull(topicName);
        Objects.requireNonNull(topicId);
        Objects.requireNonNull(k2TopicLifecycleState);
        Objects.requireNonNull(topicConfigs);
        Objects.requireNonNull(mirrorTopicMetadataOpt);
    }

    public Stream<TopicIdPartition> partitions() {
        return IntStream.range(0, this.numPartitions).mapToObj(part -> new TopicIdPartition(this.topicId, part, this.topicName));
    }

    public boolean isVirtual() {
        return TopicType.VIRTUAL.logConfigValue().equals(this.topicConfigs.get("confluent.topic.type"));
    }

    public boolean isMirror() {
        return this.mirrorTopicMetadataOpt.isPresent();
    }

    public Optional<Uuid> linkId() {
        return this.mirrorTopicMetadataOpt.map(K2MirrorTopicMetadata::clusterLinkId);
    }

    public static enum K2TopicLifecycleState {
        CREATING,
        ONLINE,
        DELETING;

    }
}

